/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.services.accessor.internal.loader;

import com.sap.core.services.accessor.equinox.extension.hook.DelegatingClassLoaderDelegateHook;
import com.sap.core.services.accessor.internal.loader.ClassLoaderJarScanner;
import com.sap.core.services.accessor.internal.loader.WebAppBundleClassLoaderDelegateHook;
import com.sap.core.services.accessor.internal.loader.WebAppBundleTrackerCustomizer;
import java.lang.instrument.ClassFileTransformer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tomcat.JarScanner;
import org.eclipse.gemini.web.tomcat.spi.ClassLoaderCustomizer;
import org.eclipse.gemini.web.tomcat.spi.JarScannerCustomizer;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppBundleClassloaderCustomizer
implements ClassLoaderCustomizer,
JarScannerCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAppBundleClassloaderCustomizer.class);
    private final WebAppBundleClassLoaderDelegateHook wabClassLoaderDelegateHook = new WebAppBundleClassLoaderDelegateHook();
    private BundleTracker<String> bundleTracker;
    private final WebAppBundleTrackerCustomizer webAppBundleCustomizer = new WebAppBundleTrackerCustomizer(this.wabClassLoaderDelegateHook);

    public void addClassFileTransformer(ClassFileTransformer cft, Bundle bundle) {
    }

    public ClassLoader createThrowawayClassLoader(Bundle bundle) {
        return null;
    }

    public ClassLoader[] extendClassLoaderChain(Bundle bundle) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Extending web application bundle " + bundle);
        }
        this.webAppBundleCustomizer.processAdditionalAPIBundles(this.bundleTracker.getBundles());
        this.wabClassLoaderDelegateHook.addWebAppBundle(bundle);
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader[]>(){

            @Override
            public ClassLoader[] run() {
                return WebAppBundleClassloaderCustomizer.this.wabClassLoaderDelegateHook.getImplBundlesClassloaders();
            }
        });
    }

    protected final void activate(ComponentContext componentContext) {
        this.bundleTracker = new BundleTracker(componentContext.getBundleContext(), 44, (BundleTrackerCustomizer)this.webAppBundleCustomizer);
        this.bundleTracker.open();
        DelegatingClassLoaderDelegateHook.getInstance().addDelegate((ClassLoaderDelegateHook)this.wabClassLoaderDelegateHook);
    }

    protected final void deactivate(ComponentContext componentContext) {
        DelegatingClassLoaderDelegateHook.getInstance().removeDelegate((ClassLoaderDelegateHook)this.wabClassLoaderDelegateHook);
        this.bundleTracker.close();
    }

    public JarScanner[] extendJarScannerChain(Bundle arg0) {
        return new JarScanner[]{new ClassLoaderJarScanner(this.webAppBundleCustomizer.getBundlesForJarScanner())};
    }

    WebAppBundleClassLoaderDelegateHook getWebAppBundleClassLoaderDelegateHook() {
        return this.wabClassLoaderDelegateHook;
    }

    WebAppBundleTrackerCustomizer getWebAppBundleTrackerCustomizer() {
        return this.webAppBundleCustomizer;
    }
}

