/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.services.accessor.internal.naming;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.spi.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFactoryTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectFactoryTracker.class);
    static final String REFERENCE_TYPE = "reference.type";
    static final String REFERENCE_TYPES_DELIMETER = ",";
    private static final Map<String, List<ObjectFactory>> objectFactories = new ConcurrentHashMap<String, List<ObjectFactory>>();

    public void bindObjectFactory(ObjectFactory factory, Map properties) {
        Vector<String> referenceTypes = this.collectReferenceTypes(properties, factory);
        for (String refType : referenceTypes) {
            List<ObjectFactory> factories = objectFactories.get(refType);
            if (factories == null) {
                factories = new ArrayList<ObjectFactory>();
            }
            factories.add(factory);
            objectFactories.put(refType, factories);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(factory + " was added to the cache with reference type " + refType);
        }
    }

    public void unbindObjectFactory(ObjectFactory factory, Map properties) {
        Vector<String> referenceTypes = this.collectReferenceTypes(properties, factory);
        for (String refType : referenceTypes) {
            List<ObjectFactory> factories = objectFactories.get(refType);
            if (factories == null) continue;
            factories.remove(factory);
            if (!factories.isEmpty()) {
                objectFactories.put(refType, factories);
            } else {
                objectFactories.remove(refType);
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(factory + " was removed form the cache with reference type " + refType);
        }
    }

    public static List<ObjectFactory> getObjectFactories(String referenceType) {
        return objectFactories.get(referenceType);
    }

    public static Map<String, List<ObjectFactory>> getObjectFactories() {
        return objectFactories;
    }

    private Vector<String> collectReferenceTypes(Map properties, ObjectFactory factory) {
        String propsRefTypeStr = (String)properties.get(REFERENCE_TYPE);
        Vector<String> types = new Vector<String>();
        if (propsRefTypeStr != null && !propsRefTypeStr.isEmpty()) {
            Scanner scanner = new Scanner(propsRefTypeStr).useDelimiter(REFERENCE_TYPES_DELIMETER);
            while (scanner.hasNext()) {
                types.add(scanner.next().trim());
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(factory + " does not provide any reference types with [" + REFERENCE_TYPE + "] property. ");
        }
        return types;
    }
}

