/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.services.accessor.tomcat.support;

import com.sap.core.services.accessor.internal.naming.ObjectFactoryTracker;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingObjectFactory
implements ObjectFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingObjectFactory.class);
    private static final String OSGI_JNDI_URLSCHEME = "osgi:service/";
    protected boolean osgiSupport = true;

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        if (obj instanceof Reference) {
            Reference reference = (Reference)obj;
            String referenceType = reference.getClassName();
            Object objectInstance = this.getObjectInstanceFromFactory(obj, name, nameCtx, environment, referenceType);
            if (objectInstance != null) {
                return objectInstance;
            }
            if (this.osgiSupport && (objectInstance = this.getObjectInstanceFromRegistry(referenceType)) != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Object instance is obtained from service registry.");
                }
                return objectInstance;
            }
            objectInstance = this.getObjectInstanceFromDefaults(obj, name, nameCtx, environment);
            if (objectInstance != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Object instance is obtained from default factory.");
                }
                return objectInstance;
            }
        }
        throw new NamingException("Object instance with name [" + name + "] could not be created.");
    }

    private Object getObjectInstanceFromRegistry(String referenceType) throws NamingException {
        Object objectInstance = null;
        try {
            InitialContext ctx = new InitialContext();
            objectInstance = ctx.lookup(OSGI_JNDI_URLSCHEME + referenceType);
        }
        catch (NameNotFoundException nne) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Could not create object instance through osgi service registry. NameNotFoundException was thrown: ", (Object)nne.getMessage());
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Could not create object instance through osgi service registry. Exception was thrown: " + e);
            }
            NamingException ne = new NamingException("Cannot create resource  object instance through the service regestry.");
            ne.initCause(e);
            throw ne;
        }
        return objectInstance;
    }

    private Object getObjectInstanceFromFactory(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment, String referenceType) throws NamingException {
        List<ObjectFactory> factories = this.getObjectFactories(referenceType);
        if (factories != null) {
            for (ObjectFactory factory : factories) {
                Object objectInstance = null;
                try {
                    objectInstance = factory.getObjectInstance(obj, name, nameCtx, environment);
                }
                catch (NameNotFoundException nne) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Will move to next factory as facroty [" + factory + "] could not retrieve object instance for name [" + name + "]. NameNotFoundException was thrown. ", (Object)nne.getMessage());
                    }
                }
                catch (Exception e) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("Exception is thrown by facroty [" + factory + "] during retrieving object instance. Exception is: " + e);
                    }
                    NamingException ne = new NamingException("Cannot create resource  object instance due to exception in the object factory");
                    ne.initCause(e);
                    throw ne;
                }
                if (objectInstance == null) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Object instance with name [" + name + "]is created by factory [" + factory + "].");
                }
                return objectInstance;
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No object factories are found for referenceType [" + referenceType + "].");
        }
        return null;
    }

    protected List<ObjectFactory> getObjectFactories(String referenceType) {
        return ObjectFactoryTracker.getObjectFactories(referenceType);
    }

    private Object getObjectInstanceFromDefaults(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        Reference reference = (Reference)obj;
        RefAddr removedFactory = this.removeDelegatingObjectFactoryFromReference(reference);
        Object objectInstance = null;
        try {
            try {
                String factoryClassName = reference.getFactoryClassName();
                if (factoryClassName != null) {
                    ObjectFactory objectFactory = (ObjectFactory)this.getClass().getClassLoader().loadClass(factoryClassName).newInstance();
                    objectInstance = objectFactory.getObjectInstance(reference, name, nameCtx, environment);
                }
            }
            catch (NameNotFoundException nne) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Default object creation factory could not retrieve object instance for name [" + name + "]. NameNotFoundException was thrown. ", (Object)nne.getMessage());
                }
                if (removedFactory != null) {
                    reference.add(removedFactory);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Add [" + this.getClass().getName() + "] to the communication endpoits of reference object  [" + reference + "].");
                    }
                }
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Exception is thrown by default object creation facroty during retrieving object instance. Exception is: " + e);
                }
                NamingException ne = new NamingException("Cannot create resource  object instance due to exception in the object factory");
                ne.initCause(e);
                throw ne;
            }
        }
        finally {
            if (removedFactory != null) {
                reference.add(removedFactory);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Add [" + this.getClass().getName() + "] to the communication endpoits of reference object  [" + reference + "].");
                }
            }
        }
        return objectInstance;
    }

    private RefAddr removeDelegatingObjectFactoryFromReference(Reference reference) {
        RefAddr removed = null;
        int i = 0;
        while (i < reference.size()) {
            RefAddr refAddr = reference.get(i);
            Object content = refAddr.getContent();
            if (content != null && this.getClass().getName().equals(content.toString())) {
                reference.remove(i);
                removed = refAddr;
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("Remove [" + this.getClass().getName() + "] from the communication endpoits of reference object  [" + reference + "].");
                break;
            }
            ++i;
        }
        return removed;
    }
}

