/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.jaxp;

import com.sap.engine.lib.xml.parser.NestedSAXParseException;
import com.sap.engine.lib.xml.util.SAXToDOMHandler;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.TransformerHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TransformerHandlerImpl
extends SAXToDOMHandler
implements TransformerHandler {
    private Result result = null;
    private String systemId = null;
    private Transformer transformer = null;

    protected TransformerHandlerImpl() throws TransformerConfigurationException {
        this.transformer = TransformerFactory.newInstance().newTransformer();
    }

    protected TransformerHandlerImpl(Templates templates) throws TransformerConfigurationException {
        this.transformer = templates.newTransformer();
    }

    @Override
    public void setResult(Result result) throws IllegalArgumentException {
        if (result == null) {
            throw new IllegalArgumentException("Result is invalid: null");
        }
        this.result = result;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        try {
            if (this.result == null) {
                throw new SAXException("Cannot process transformation: result is null");
            }
            this.transformer.transform(new DOMSource((Document)this.getRoot(), this.systemId), this.result);
        }
        catch (TransformerException e) {
            throw new NestedSAXParseException("Could not process transformation", e);
        }
    }
}

