/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.log;

import com.sap.engine.lib.log.LogFormatter;
import com.sap.engine.lib.log.WriterHandler;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.xml.sax.SAXParseException;

public class LogWriter {
    private static final LogWriter systemLogWriter = new LogWriter();
    private Logger logger;

    private LogWriter() {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new LogFormatter());
        this.initLogger(consoleHandler);
    }

    private LogWriter(OutputStream outputStream) {
        this.initLogger(new StreamHandler(outputStream, new LogFormatter()));
    }

    private LogWriter(Writer writer) {
        this.initLogger(new WriterHandler(writer, new LogFormatter()));
    }

    private void initLogger(Handler handler) {
        this.logger = Logger.getAnonymousLogger();
        this.logger.setUseParentHandlers(false);
        this.logger.addHandler(handler);
    }

    public static LogWriter getSystemLogWriter() {
        return systemLogWriter;
    }

    public static LogWriter newLogWriter(OutputStream outputStream) {
        return new LogWriter(outputStream);
    }

    public static LogWriter newLogWriter(Writer writer) {
        return new LogWriter(writer);
    }

    public void print(String message) {
        this.print(message, false);
    }

    public void println(String message) {
        this.print(message, true);
    }

    private void print(String message, boolean appendNewLine) {
        this.logger.severe(message);
        if (appendNewLine) {
            this.logger.severe("\n");
        }
        Handler handler = this.logger.getHandlers()[0];
        handler.flush();
    }

    public static String createExceptionRepresentation(Throwable thr) {
        Throwable cause;
        SAXParseException saxParseException;
        int line;
        StringBuffer buffer = new StringBuffer();
        buffer.append(thr.getClass().getName());
        String message = thr.getMessage();
        if (message != null) {
            buffer.append(": ");
            buffer.append(message);
        }
        if (thr instanceof SAXParseException && (line = (saxParseException = (SAXParseException)thr).getLineNumber()) >= 0) {
            String systemId = saxParseException.getSystemId();
            if (systemId == null) {
                systemId = ":main:";
            }
            buffer.append("(");
            buffer.append(systemId);
            buffer.append(", ");
            buffer.append("row=");
            buffer.append(line);
            buffer.append(", ");
            buffer.append("col=");
            buffer.append(saxParseException.getColumnNumber());
            buffer.append(")");
        }
        if ((cause = thr.getCause()) != null) {
            buffer.append(" -> ");
            buffer.append(cause.toString());
        }
        return buffer.toString();
    }
}

