/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.log;

import com.sap.engine.lib.xml.util.NestedRuntimeException;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class WriterHandler
extends Handler {
    private Writer writer;

    WriterHandler(Writer writer, Formatter formatter) {
        this.writer = writer;
        this.setFormatter(formatter);
    }

    @Override
    public void publish(LogRecord record) {
        String message = this.getFormatter().format(record);
        try {
            this.writer.write(message);
        }
        catch (Exception exc) {
            throw new NestedRuntimeException(exc);
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception exc) {
            throw new NestedRuntimeException(exc);
        }
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.writer.close();
        }
        catch (Exception exc) {
            throw new NestedRuntimeException(exc);
        }
    }
}

