/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.canonicalizator;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.canonicalizator.CanonicalizationProcessor;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.exception.CanonicalizationException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.parser.DOMParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class Canonicalizator
implements Constants {
    private boolean useExternalSchema;
    private DOMParser parser;
    private Object schemaSource;

    public Canonicalizator() throws CanonicalizationException {
        try {
            this.useExternalSchema = true;
            this.parser = new DOMParser();
            this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
            this.parser.setFeature("http://xml.org/sax/features/validation", true);
            this.parser.setFeature("http://sap.com/xml/schemaCanonicalizationProcessing", true);
            this.parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    public void setSchema(Schema schema) {
        this.schemaSource = schema;
    }

    public void setSchema(String schemaLocation) {
        this.schemaSource = schemaLocation;
    }

    public void setSchema(String[] schemaLocations) {
        this.schemaSource = schemaLocations;
    }

    public void setSchema(Node schemaNode) {
        this.schemaSource = schemaNode;
    }

    public void setSchema(Node[] schemaNodes) {
        this.schemaSource = schemaNodes;
    }

    public void setSchema(StreamSource schemaSource) {
        this.schemaSource = schemaSource;
    }

    public void setSchema(StreamSource[] schemaSources) {
        this.schemaSource = schemaSources;
    }

    public void setSchema(InputStream schemaInput) {
        this.schemaSource = schemaInput;
    }

    public void setSchema(InputStream[] schemaInputs) {
        this.schemaSource = schemaInputs;
    }

    public void setSchema(InputSource schemaInput) {
        this.schemaSource = schemaInput;
    }

    public void setSchema(InputSource[] schemaInputs) {
        this.schemaSource = schemaInputs;
    }

    public void setSchema(File schemaFile) {
        this.schemaSource = schemaFile;
    }

    public void setSchema(File[] schemaFiles) {
        this.schemaSource = schemaFiles;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.parser.setEntityResolver(resolver);
    }

    public void setUseExternalSchema(boolean useExternalSchema) {
        this.useExternalSchema = useExternalSchema;
    }

    public void canonicalize(String inputXmlLocation, String outputXmlFile) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(inputXmlLocation), outputXmlFile);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    public void canonicalize(String inputXmlLocation, OutputStream xmlOutput) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(inputXmlLocation), xmlOutput);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    public void canonicalize(String inputXmlLocation, Writer xmlWriter) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(inputXmlLocation), xmlWriter);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    private void canonicalize(Element inputXmlElement, String xmlOutputFile) throws CanonicalizationException {
        FileOutputStream xmlOutput = null;
        try {
            xmlOutput = new FileOutputStream(xmlOutputFile);
        }
        catch (FileNotFoundException fNFExc) {
            throw new CanonicalizationException(xmlOutputFile, fNFExc);
        }
        CanonicalizationProcessor processor = new CanonicalizationProcessor(inputXmlElement, xmlOutput);
        processor.process();
    }

    private void canonicalize(Element inputXmlElement, OutputStream xmlOutput) throws CanonicalizationException {
        CanonicalizationProcessor processor = new CanonicalizationProcessor(inputXmlElement, xmlOutput);
        processor.process();
    }

    private void canonicalize(Element inputXmlElement, Writer xmlWriter) throws CanonicalizationException {
        CanonicalizationProcessor processor = new CanonicalizationProcessor(inputXmlElement, xmlWriter);
        processor.process();
    }

    public void canonicalize(StreamSource inputXmlSource, String outputXmlFile) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(Tools.createInputSource(inputXmlSource)), outputXmlFile);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    public void canonicalize(StreamSource inputXmlSource, OutputStream xmlOutput) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(Tools.createInputSource(inputXmlSource)), xmlOutput);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    public void canonicalize(StreamSource inputXmlSource, Writer xmlWriter) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(Tools.createInputSource(inputXmlSource)), xmlWriter);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    public void canonicalize(InputStream inputXmlInput, String outputXmlFile) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(inputXmlInput), outputXmlFile);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    public void canonicalize(InputStream inputXmlInput, OutputStream xmlOutput) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(inputXmlInput), xmlOutput);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    public void canonicalize(InputStream inputXmlInput, Writer xmlWriter) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(inputXmlInput), xmlWriter);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    public void canonicalize(InputSource inputXmlSource, String outputXmlFile) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(inputXmlSource), outputXmlFile);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    public void canonicalize(InputSource inputXmlSource, OutputStream xmlOutput) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(inputXmlSource), xmlOutput);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    public void canonicalize(InputSource inputXmlSource, Writer xmlWriter) throws CanonicalizationException {
        try {
            this.canonicalize(this.parse(inputXmlSource), xmlWriter);
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    private Element parse(String inputXml) throws CanonicalizationException {
        try {
            this.parser.setProperty(this.schemaSource instanceof Schema ? "http://apache.org/xml/properties/schema/schemaObject" : "http://java.sun.com/xml/jaxp/properties/schemaSource", this.useExternalSchema ? this.schemaSource : null);
            return this.parser.parse(inputXml).getDocumentElement();
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    private Element parse(InputStream inputXml) throws CanonicalizationException {
        try {
            this.parser.setProperty(this.schemaSource instanceof Schema ? "http://apache.org/xml/properties/schema/schemaObject" : "http://java.sun.com/xml/jaxp/properties/schemaSource", this.useExternalSchema ? this.schemaSource : null);
            return this.parser.parse(inputXml).getDocumentElement();
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }

    private Element parse(InputSource inputXml) throws CanonicalizationException {
        try {
            this.parser.setProperty(this.schemaSource instanceof Schema ? "http://apache.org/xml/properties/schema/schemaObject" : "http://java.sun.com/xml/jaxp/properties/schemaSource", this.useExternalSchema ? this.schemaSource : null);
            return this.parser.parse(inputXml).getDocumentElement();
        }
        catch (Exception exc) {
            throw new CanonicalizationException(exc.getMessage(), exc);
        }
    }
}

