/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl;

import com.sap.engine.lib.jaxp.MultiSource;
import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.jaxp.TransformerImpl;
import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.Loader;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.impl.SchemaForSchemaEntityResolver;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.DOMParser;
import com.sap.engine.lib.xml.parser.URLLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LoaderImpl
implements Loader,
Constants {
    private static SchemaImpl xmlSDForXSDDoc;
    private EntityResolver entityResolver;
    private URIResolver uriResolver;
    private DOMParser parser;
    private TransformerImpl transformer;
    private boolean validateXSDDoc = true;
    private Hashtable locationToSchemasMapping;
    private Hashtable nsToSchemasMapping;
    private Hashtable nsToNsModifiedSchemaLocationsMapping;
    private boolean backwardsCompatibilityMode = false;
    private boolean loadPatternRegularExpressions = true;

    @Override
    public void setLoadPatternRegularExpressions(boolean loadPatternRegularExpressions) {
        this.loadPatternRegularExpressions = loadPatternRegularExpressions;
    }

    @Override
    public boolean getLoadPatternRegularExpressions() {
        return this.loadPatternRegularExpressions;
    }

    @Override
    public void setBackwardsCompatibilityMode(boolean backwardsCompatibilityMode) {
        this.backwardsCompatibilityMode = backwardsCompatibilityMode;
    }

    @Override
    public boolean getBackwardsCompatibilityMode() {
        return this.backwardsCompatibilityMode;
    }

    @Override
    public void setValidateXSDDoc(boolean validateXSDDoc) {
        this.validateXSDDoc = validateXSDDoc;
    }

    @Override
    public boolean getValidateXSDDoc() {
        return this.validateXSDDoc;
    }

    @Override
    public Schema load(String location) throws SchemaComponentException {
        return this.load(null, location);
    }

    @Override
    public Schema load(String namespace, String location) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl schema = this.determineSchema(this.produceSchemas_Location(null, location, null, namespace));
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(String[] locations) throws SchemaComponentException {
        return this.load(new String[locations.length], locations);
    }

    @Override
    public Schema load(String[] namespaces, String[] locations) throws SchemaComponentException {
        if (namespaces.length != locations.length) {
            throw new SchemaComponentException("ERROR : The count of namespaces has to be equal to the count of locations.");
        }
        try {
            this.init();
            SchemaImpl[][] schemas = new SchemaImpl[locations.length][];
            int i = 0;
            while (i < locations.length) {
                schemas[i] = this.produceSchemas_Location(null, locations[i], null, namespaces[i]);
                ++i;
            }
            SchemaImpl schema = this.determineSchema(schemas);
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(Node node) throws SchemaComponentException {
        return this.load(null, node);
    }

    @Override
    public Schema load(String namespace, Node node) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl schema = this.produceSchema_Node(node, namespace);
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(Node[] nodes) throws SchemaComponentException {
        return this.load(new String[nodes.length], nodes);
    }

    @Override
    public Schema load(String[] namespaces, Node[] nodes) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl[] schemas = new SchemaImpl[nodes.length];
            int i = 0;
            while (i < nodes.length) {
                schemas[i] = this.produceSchema_Node(nodes[i], namespaces[i]);
                ++i;
            }
            SchemaImpl schema = this.determineSchema(schemas);
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema loadFromWSDLDocument(MultiSource source) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl schema = this.determineSchema(this.produceSchemas_Source(source, null, null, true));
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(Source source) throws SchemaComponentException {
        return this.load(null, source);
    }

    @Override
    public Schema load(String namespace, Source source) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl schema = this.determineSchema(this.produceSchemas_Source(source, null, namespace, false));
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(Source[] sources) throws SchemaComponentException {
        return this.load(new String[sources.length], sources);
    }

    @Override
    public Schema load(String[] namespaces, Source[] sources) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl[][] schemas = new SchemaImpl[sources.length][];
            int i = 0;
            while (i < sources.length) {
                schemas[i] = this.produceSchemas_Source(sources[i], null, namespaces[i], false);
                ++i;
            }
            SchemaImpl schema = this.determineSchema(schemas);
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(InputStream inputStream) throws SchemaComponentException {
        return this.load(null, inputStream);
    }

    @Override
    public Schema load(String namespace, InputStream inputStream) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl schema = this.produceSchema_InputSource(new InputSource(inputStream), null, namespace);
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(InputStream[] inputStreams) throws SchemaComponentException {
        return this.load(new String[inputStreams.length], inputStreams);
    }

    @Override
    public Schema load(String[] namespaces, InputStream[] inputStreams) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl[] schemas = new SchemaImpl[inputStreams.length];
            int i = 0;
            while (i < inputStreams.length) {
                schemas[i] = this.produceSchema_InputSource(new InputSource(inputStreams[i]), null, namespaces[i]);
                ++i;
            }
            SchemaImpl schema = this.determineSchema(schemas);
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(InputSource inputSource) throws SchemaComponentException {
        return this.load(null, inputSource);
    }

    @Override
    public Schema load(String namespace, InputSource inputSource) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl schema = this.produceSchema_InputSource(inputSource, null, namespace);
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(InputSource[] inputSources) throws SchemaComponentException {
        return this.load(new String[inputSources.length], inputSources);
    }

    @Override
    public Schema load(String[] namespaces, InputSource[] inputSources) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl[] schemas = new SchemaImpl[inputSources.length];
            int i = 0;
            while (i < inputSources.length) {
                schemas[i] = this.produceSchema_InputSource(inputSources[i], null, namespaces[i]);
                ++i;
            }
            SchemaImpl schema = this.determineSchema(schemas);
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(File file) throws SchemaComponentException {
        return this.load(null, file);
    }

    @Override
    public Schema load(String namespace, File file) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl schema = this.determineSchema(this.produceSchemas_Location(null, this.retriveSchemaLocation(file), null, namespace));
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(File[] files) throws SchemaComponentException {
        return this.load(new String[files.length], files);
    }

    @Override
    public Schema load(String[] namespaces, File[] files) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl[][] schemas = new SchemaImpl[files.length][];
            int i = 0;
            while (i < files.length) {
                schemas[i] = this.produceSchemas_Location(null, this.retriveSchemaLocation(files[i]), null, namespaces[i]);
                ++i;
            }
            SchemaImpl schema = this.determineSchema(schemas);
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public Schema load(Object schemaObj) throws SchemaComponentException {
        if (!schemaObj.getClass().isArray()) {
            return this.load(null, schemaObj);
        }
        Schema result = null;
        if (schemaObj instanceof String[]) {
            result = this.load((String[])schemaObj);
        } else if (schemaObj instanceof Node[]) {
            result = this.load((Node[])schemaObj);
        } else if (schemaObj instanceof InputStream[]) {
            result = this.load((InputStream[])schemaObj);
        } else if (schemaObj instanceof InputSource[]) {
            result = this.load((InputSource[])schemaObj);
        } else if (schemaObj instanceof File[]) {
            result = this.load((File[])schemaObj);
        } else if (schemaObj instanceof Source[]) {
            result = this.load((Source[])schemaObj);
        } else if (schemaObj instanceof String[][]) {
            String[][] namespacesAndLocations = (String[][])schemaObj;
            result = this.load(namespacesAndLocations[0], namespacesAndLocations[1]);
        } else if (schemaObj instanceof Object[]) {
            result = this.load((Object[])schemaObj);
        } else {
            throw new SchemaComponentException("Unable to load schema. Schema source object with class : " + schemaObj.getClass().getName() + " is not supported.");
        }
        return result;
    }

    @Override
    public Schema load(String namespace, Object schemaObj) throws SchemaComponentException {
        Schema result = null;
        if (schemaObj instanceof String) {
            result = this.load(namespace, (String)schemaObj);
        } else if (schemaObj instanceof Node) {
            result = this.load(namespace, (Node)schemaObj);
        } else if (schemaObj instanceof InputStream) {
            result = this.load(namespace, (InputStream)schemaObj);
        } else if (schemaObj instanceof InputSource) {
            result = this.load(namespace, (InputSource)schemaObj);
        } else if (schemaObj instanceof File) {
            result = this.load(namespace, (File)schemaObj);
        } else if (schemaObj instanceof Source) {
            result = this.load(namespace, (Source)schemaObj);
        } else {
            throw new SchemaComponentException("Unable to load schema. Schema source object with class : " + schemaObj.getClass().getName() + " is not supported.");
        }
        return result;
    }

    @Override
    public Schema load(Object[] schemaObjs) throws SchemaComponentException {
        return this.load(new String[schemaObjs.length], schemaObjs);
    }

    @Override
    public Schema load(String[] namespaces, Object[] schemaObjs) throws SchemaComponentException {
        try {
            this.init();
            SchemaImpl[][] schemas = new SchemaImpl[schemaObjs.length][];
            int i = 0;
            while (i < schemaObjs.length) {
                Object source;
                Object schemaObj = schemaObjs[i];
                if (schemaObj instanceof String) {
                    String location = (String)schemaObj;
                    schemas[i] = this.produceSchemas_Location(null, location, null, namespaces[i]);
                } else if (schemaObj instanceof Node) {
                    Node node = (Node)schemaObj;
                    schemas[i] = new SchemaImpl[]{this.produceSchema_Node(node, namespaces[i])};
                } else if (schemaObj instanceof Source) {
                    source = (Source)schemaObj;
                    schemas[i] = this.produceSchemas_Source((Source)source, null, namespaces[i], false);
                } else if (schemaObj instanceof InputStream) {
                    source = new InputSource((InputStream)schemaObj);
                    schemas[i] = new SchemaImpl[]{this.produceSchema_InputSource((InputSource)source, null, namespaces[i])};
                } else if (schemaObj instanceof InputSource) {
                    source = (InputSource)schemaObj;
                    schemas[i] = new SchemaImpl[]{this.produceSchema_InputSource((InputSource)source, null, namespaces[i])};
                } else if (schemaObj instanceof File) {
                    File file = (File)schemaObj;
                    schemas[i] = this.produceSchemas_Location(null, this.retriveSchemaLocation(file), null, namespaces[i]);
                } else {
                    throw new SchemaComponentException("Unable to load schema. Schema source object with class : " + schemaObj.getClass().getName() + " is not supported.");
                }
                ++i;
            }
            SchemaImpl schema = this.determineSchema(schemas);
            SchemaStructuresLoader.loadBase(schema);
            SchemaImpl schemaImpl = schema;
            return schemaImpl;
        }
        finally {
            this.finish();
        }
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    private void init() {
        this.locationToSchemasMapping = new Hashtable();
        this.nsToSchemasMapping = new Hashtable();
        this.nsToNsModifiedSchemaLocationsMapping = new Hashtable();
    }

    private void finish() {
        this.locationToSchemasMapping = null;
        this.nsToSchemasMapping = null;
        this.nsToNsModifiedSchemaLocationsMapping = null;
    }

    private String createSchemaStructuresResolverRegistrationKey(String namespace, String location) {
        return location == null || namespace == null ? null : "<" + namespace + "> : " + location;
    }

    public String canonicalizeLocation(String location) {
        if (location != null) {
            if (location.startsWith("http:")) {
                return LoaderImpl.canonicalizeHttpLocation("http", location);
            }
            if (location.startsWith("https:")) {
                return LoaderImpl.canonicalizeHttpLocation("https", location);
            }
            if (location.startsWith("file:")) {
                return this.canonicalizeFileLocation(location, true);
            }
            if (location.startsWith("jar:")) {
                return LoaderImpl.canonicalizeJarLocation(location);
            }
            return this.canonicalizeFileLocation(location, false);
        }
        return null;
    }

    private String canonicalizeFileLocation(String location, boolean hasScheme) {
        if (hasScheme) {
            return LoaderImpl.canonicalizeLocation("file", location, "/");
        }
        location = location.replace('\\', '/');
        return "file:/" + location;
    }

    private static String canonicalizeHttpLocation(String schema, String location) {
        return LoaderImpl.canonicalizeLocation(schema, location, "//");
    }

    private static String canonicalizeJarLocation(String location) {
        return LoaderImpl.canonicalizeLocation("jar", location, "");
    }

    private static String canonicalizeLocation(String scheme, String location, String schemeFromPathDelimiter) {
        int index = scheme.length() + 1;
        while (location.charAt(index++) == '/' && index < location.length()) {
        }
        String canonicalizaedLocation = String.valueOf(scheme) + ":" + schemeFromPathDelimiter + location.substring(index - 1);
        return canonicalizaedLocation.replace('\\', '/');
    }

    private String retriveSchemaLocation(File file) throws SchemaComponentException {
        String schemaLocation = null;
        try {
            schemaLocation = file.getCanonicalPath();
        }
        catch (IOException ioExc) {
            throw new SchemaComponentException("ERROR : An error occured while tring to retrieve schema location.", ioExc);
        }
        return schemaLocation;
    }

    private TransformerImpl determineTransformer() throws SchemaComponentException {
        if (this.transformer == null) {
            TransformerFactoryImpl factory = new TransformerFactoryImpl();
            try {
                this.transformer = (TransformerImpl)((TransformerFactory)factory).newTransformer();
                this.transformer.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
                this.transformer.setAttribute("http://xml.org/sax/features/validation", new Boolean(this.validateXSDDoc));
                this.transformer.setAttribute("http://inqmy.org/sax/features/read-dtd", Boolean.FALSE);
                if (this.validateXSDDoc) {
                    this.transformer.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    this.transformer.setAttribute("http://apache.org/xml/properties/schema/schemaObject", this.determineXSDForXSDDoc());
                }
            }
            catch (Exception exc) {
                throw new SchemaComponentException(exc);
            }
        }
        return this.transformer;
    }

    private SchemaImpl determineSchema(SchemaImpl[] schemas) {
        SchemaImpl schema = null;
        schema = schemas.length == 1 ? schemas[0] : new SchemaImpl(schemas);
        return schema;
    }

    private SchemaImpl determineSchema(SchemaImpl[][] schemas) {
        SchemaImpl schema = null;
        schema = schemas.length == 1 && schemas[0].length == 1 ? schemas[0][0] : new SchemaImpl(schemas);
        return schema;
    }

    public SchemaImpl[] produceSchemas_Location(String parentLocation, String location, String includingNamespace, String requiredNamespace) throws SchemaComponentException {
        try {
            InputSource inputSource;
            Source source;
            if (this.uriResolver != null && (source = this.uriResolver.resolve(location, parentLocation == null ? "xsd://" : parentLocation)) != null) {
                return this.produceSchemas_Source(source, includingNamespace, requiredNamespace, false);
            }
            if (this.entityResolver != null && (inputSource = this.entityResolver.resolveEntity(null, location)) != null) {
                return new SchemaImpl[]{this.produceSchema_InputSource(inputSource, includingNamespace, requiredNamespace)};
            }
            return new SchemaImpl[]{this.produceSchema_Location(parentLocation, location, includingNamespace, requiredNamespace)};
        }
        catch (Exception exc) {
            if (exc instanceof SchemaComponentException) {
                throw (SchemaComponentException)exc;
            }
            throw new SchemaComponentException(exc);
        }
    }

    private SchemaImpl produceSchema_Location(String parentLocation, String location, String includingNamespace, String requiredNamespace) throws SchemaComponentException {
        try {
            URL baseURL = parentLocation == null ? null : new URL(parentLocation);
            URL schemaURL = URLLoader.fileOrURLToURL(baseURL, location);
            String canonicalizedLocation = this.canonicalizeLocation(schemaURL.toExternalForm());
            SchemaImpl schema = this.getRegisteredSchema(canonicalizedLocation, includingNamespace);
            if (schema == null) {
                Element schemaElement = this.retriveElement(new InputSource(schemaURL.openStream()));
                schema = this.createSchema(schemaElement, canonicalizedLocation, includingNamespace, requiredNamespace, false);
            }
            return schema;
        }
        catch (Exception exc) {
            if (exc instanceof SchemaComponentException) {
                throw (SchemaComponentException)exc;
            }
            throw new SchemaComponentException(exc);
        }
    }

    private SchemaImpl produceSchema_InputSource(InputSource inputSource, String includingNamespace, String requiredNamespace) throws SchemaComponentException {
        if (inputSource.getByteStream() == null && inputSource.getCharacterStream() == null) {
            if (inputSource.getSystemId() == null) {
                throw new SchemaComponentException("ERROR : Empty input source. Input source without system id, input stream and reader detected.");
            }
            return this.produceSchema_Location(null, inputSource.getSystemId(), includingNamespace, requiredNamespace);
        }
        try {
            String location = inputSource.getSystemId();
            String canonicalizedLocation = this.canonicalizeLocation(location);
            SchemaImpl schema = this.getRegisteredSchema(canonicalizedLocation, includingNamespace);
            if (schema == null) {
                Element schemaElement = this.retriveElement(inputSource);
                schema = this.createSchema(schemaElement, canonicalizedLocation, includingNamespace, requiredNamespace, false);
            }
            return schema;
        }
        catch (Exception exc) {
            if (exc instanceof SchemaComponentException) {
                throw (SchemaComponentException)exc;
            }
            throw new SchemaComponentException(exc);
        }
    }

    private SchemaImpl getRegisteredSchema(String canonicalizedLocation, String includingNamespace) {
        SchemaImpl schema = null;
        if (canonicalizedLocation != null) {
            if (includingNamespace != null && !includingNamespace.equals("")) {
                schema = this.getRegisteredNsUnmodifiedSchema(canonicalizedLocation);
                if (schema != null) {
                    if (schema.getTargetNamespace().equals("")) {
                        schema = this.getRegisteredNsModifiedSchema(canonicalizedLocation, includingNamespace);
                    }
                } else {
                    schema = this.getRegisteredNsModifiedSchema(canonicalizedLocation, includingNamespace);
                }
            } else {
                schema = this.getRegisteredNsUnmodifiedSchema(canonicalizedLocation);
            }
        }
        return schema;
    }

    private SchemaImpl getRegisteredNsUnmodifiedSchema(String canonicalizedLocation) {
        return (SchemaImpl)this.locationToSchemasMapping.get(canonicalizedLocation);
    }

    private SchemaImpl getRegisteredNsModifiedSchema(String canonicalizedLocation, String includingNamespace) {
        Hashtable locationToIncludedSchemasMapping = (Hashtable)this.nsToNsModifiedSchemaLocationsMapping.get(includingNamespace);
        SchemaImpl schema = null;
        if (locationToIncludedSchemasMapping != null) {
            schema = (SchemaImpl)locationToIncludedSchemasMapping.get(canonicalizedLocation);
        }
        return schema;
    }

    private SchemaImpl createSchema(Element schemaElement, String canonicalizedLocation, String includingNamespace, String requiredNamespace, boolean fromWSDLDocument) throws SchemaComponentException {
        SchemaImpl schema = new SchemaImpl(schemaElement, this, canonicalizedLocation, includingNamespace);
        if (requiredNamespace != null && !schema.getTargetNamespace().equals(requiredNamespace)) {
            throw new SchemaComponentException("[location : '" + schema.getLocation() + "'] ERROR : Target namespace '" + requiredNamespace + "' is required.");
        }
        this.registerSchema(canonicalizedLocation, schema, includingNamespace, fromWSDLDocument);
        schema.collectComponents();
        return schema;
    }

    private void registerSchema(String canonicalizedLocation, SchemaImpl schema, String includingNamespace, boolean fromWSDLDocument) {
        this.registerNs(schema);
        if (canonicalizedLocation != null && !fromWSDLDocument) {
            if (includingNamespace != null) {
                if (includingNamespace.equals(schema.getTargetNamespace())) {
                    this.registerNsUnmodifiedSchema(canonicalizedLocation, schema);
                } else {
                    this.registerNsModifiedSchema(canonicalizedLocation, schema, includingNamespace);
                }
            } else {
                this.registerNsUnmodifiedSchema(canonicalizedLocation, schema);
            }
        }
    }

    private void registerNsUnmodifiedSchema(String canonicalizedLocation, SchemaImpl schema) {
        this.locationToSchemasMapping.put(canonicalizedLocation, schema);
    }

    private void registerNsModifiedSchema(String canonicalizedLocation, SchemaImpl schema, String includingNamespace) {
        Hashtable<String, SchemaImpl> locationToSchemaMapping = (Hashtable<String, SchemaImpl>)this.nsToNsModifiedSchemaLocationsMapping.get(includingNamespace);
        if (locationToSchemaMapping == null) {
            locationToSchemaMapping = new Hashtable<String, SchemaImpl>();
            this.nsToNsModifiedSchemaLocationsMapping.put(includingNamespace, locationToSchemaMapping);
        }
        locationToSchemaMapping.put(canonicalizedLocation, schema);
    }

    private void registerNs(SchemaImpl schema) {
        Vector<SchemaImpl> schemasCollector = (Vector<SchemaImpl>)this.nsToSchemasMapping.get(schema.getTargetNamespace());
        if (schemasCollector == null) {
            schemasCollector = new Vector<SchemaImpl>();
            this.nsToSchemasMapping.put(schema.getTargetNamespace(), schemasCollector);
        }
        schemasCollector.add(schema);
    }

    private SchemaImpl[] produceSchemas_Source(Source source, String includingNamespace, String requiredNamespace, boolean fromWSDLDocument) throws SchemaComponentException {
        Source[] sources = null;
        if (source instanceof MultiSource) {
            MultiSource multiSource = (MultiSource)source;
            sources = multiSource.getSources();
        } else {
            sources = new Source[]{source};
        }
        DOMResult domResult = new DOMResult();
        SchemaImpl[] schemas = new SchemaImpl[sources.length];
        int i = 0;
        while (i < sources.length) {
            Source schemaSource = sources[i];
            if (schemaSource instanceof StreamSource && ((StreamSource)schemaSource).getInputStream() == null && ((StreamSource)schemaSource).getReader() == null) {
                if (((StreamSource)schemaSource).getSystemId() == null) {
                    throw new SchemaComponentException("ERROR : Empty stream source. Stream source without system id, input stream and reader detected.");
                }
                schemas[i] = this.produceSchema_Location(null, schemaSource.getSystemId(), includingNamespace, requiredNamespace);
            } else {
                String location = schemaSource.getSystemId();
                String canonicalizedLocation = this.canonicalizeLocation(location);
                domResult.setNode(null);
                SchemaImpl schema = this.getRegisteredSchema(canonicalizedLocation, includingNamespace);
                if (schema == null) {
                    Node node = null;
                    if (schemaSource instanceof DOMSource) {
                        node = ((DOMSource)schemaSource).getNode();
                    } else {
                        try {
                            this.determineTransformer().transform(schemaSource, domResult);
                        }
                        catch (TransformerException transformerExc) {
                            throw new SchemaComponentException("[location : '" + canonicalizedLocation + "'] ERROR : " + transformerExc.getMessage(), transformerExc);
                        }
                        node = domResult.getNode();
                    }
                    schema = this.createSchema(this.retriveElement(node), canonicalizedLocation, includingNamespace, requiredNamespace, fromWSDLDocument);
                }
                schemas[i] = schema;
            }
            ++i;
        }
        return schemas;
    }

    private SchemaImpl produceSchema_Node(Node node, String requiredNamespace) throws SchemaComponentException {
        try {
            URL nodeURL = DOM.getLocation(node);
            String location = nodeURL == null ? null : nodeURL.toExternalForm();
            String canonicalizedLocation = this.canonicalizeLocation(location);
            SchemaImpl schema = this.getRegisteredSchema(canonicalizedLocation, null);
            if (schema == null) {
                Element schemaElement = this.retriveElement(node);
                schema = this.createSchema(schemaElement, canonicalizedLocation, null, requiredNamespace, false);
            }
            return schema;
        }
        catch (Exception exc) {
            if (exc instanceof SchemaComponentException) {
                throw (SchemaComponentException)exc;
            }
            throw new SchemaComponentException(exc);
        }
    }

    public SchemaImpl[] produceSchemas_Namespace(String namespace) throws SchemaComponentException {
        try {
            Vector schemasCollector;
            Object[] schemas = this.produceSchemas_Namespace_UriResolver(namespace);
            if (schemas == null && (schemasCollector = (Vector)this.nsToSchemasMapping.get(namespace)) != null) {
                schemas = new SchemaImpl[schemasCollector.size()];
                schemasCollector.copyInto(schemas);
            }
            return schemas;
        }
        catch (Exception exc) {
            if (exc instanceof SchemaComponentException) {
                throw (SchemaComponentException)exc;
            }
            throw new SchemaComponentException(exc);
        }
    }

    public SchemaImpl[] produceSchemas_Namespace_UriResolver(String namespace) throws SchemaComponentException {
        try {
            Source source;
            if (this.uriResolver != null && (source = this.uriResolver.resolve(namespace, "xsd://")) != null) {
                return this.produceSchemas_Source(source, null, namespace, false);
            }
            return null;
        }
        catch (Exception exc) {
            if (exc instanceof SchemaComponentException) {
                throw (SchemaComponentException)exc;
            }
            throw new SchemaComponentException(exc);
        }
    }

    private DOMParser determineParser() throws SchemaComponentException {
        if (this.parser == null) {
            try {
                this.parser = new DOMParser();
                this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
                this.parser.setFeature("http://xml.org/sax/features/validation", this.validateXSDDoc);
                this.parser.setFeature("http://inqmy.org/sax/features/read-dtd", false);
                if (this.validateXSDDoc) {
                    this.parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    this.parser.setProperty("http://apache.org/xml/properties/schema/schemaObject", this.determineXSDForXSDDoc());
                }
            }
            catch (Exception exc) {
                throw new SchemaComponentException(exc);
            }
        }
        return this.parser;
    }

    private SchemaImpl determineXSDForXSDDoc() throws SchemaComponentException {
        if (xmlSDForXSDDoc == null) {
            LoaderImpl loader = new LoaderImpl();
            loader.setValidateXSDDoc(false);
            loader.setEntityResolver(new SchemaForSchemaEntityResolver());
            xmlSDForXSDDoc = (SchemaImpl)loader.load("XMLSchema.xsd");
        }
        return xmlSDForXSDDoc;
    }

    private Element retriveElement(InputSource inputSource) throws SchemaComponentException {
        try {
            DOMParser parser = this.determineParser();
            return parser.parse(inputSource).getDocumentElement();
        }
        catch (Exception exc) {
            if (exc instanceof SchemaComponentException) {
                throw (SchemaComponentException)exc;
            }
            throw new SchemaComponentException(exc);
        }
    }

    private Element retriveElement(Node node) {
        Element result = null;
        if (node instanceof Element) {
            result = (Element)node;
        } else if (node instanceof Document) {
            Document doc = (Document)node;
            result = doc.getDocumentElement();
        }
        return result;
    }
}

