/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.ffacets;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.impl.ffacets.ValueSpace;
import com.sap.engine.lib.schema.util.Duration;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Calendar;

public final class Value
implements Constants {
    private ValueSpace valueSpace = new ValueSpace();
    private int length = -1;
    private int usersCount = 0;

    protected void addValue(String valueSpaceId, Object value) {
        this.valueSpace.addValue(valueSpaceId, value);
    }

    protected void setLengthDeterminigValue(Object lengthDeterminigObj) {
        if (lengthDeterminigObj.getClass().isArray()) {
            this.length = Array.getLength(lengthDeterminigObj);
        } else if (lengthDeterminigObj instanceof String) {
            this.length = ((String)lengthDeterminigObj).length();
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        if (this.length == -1) {
            throw new IllegalArgumentException("Length is not supported as a contraning facet.");
        }
        return this.length;
    }

    public int compare(Value value) {
        int restrictionLevel = this.valueSpace.intersect(value.valueSpace);
        if (restrictionLevel == -1) {
            return 4;
        }
        return this.compare(this.valueSpace.getValue(restrictionLevel), value.valueSpace.getValue(restrictionLevel));
    }

    private int compare(Object obj1, Object obj2) {
        if (obj1 instanceof Duration) {
            Duration duration1 = (Duration)obj1;
            Duration duration2 = (Duration)obj2;
            int compareResult = duration1.compare(duration2);
            if (compareResult == 0) {
                return 1;
            }
            if (compareResult == -1) {
                return 2;
            }
            if (compareResult == 1) {
                return 3;
            }
            return 4;
        }
        if (obj1 instanceof Calendar) {
            Calendar calendar1 = (Calendar)obj1;
            Calendar calendar2 = (Calendar)obj2;
            if (calendar1.before(calendar2)) {
                return 2;
            }
            if (calendar1.after(calendar2)) {
                return 3;
            }
            return 1;
        }
        if (obj1 instanceof Boolean) {
            Boolean boolean1 = (Boolean)obj1;
            Boolean boolean2 = (Boolean)obj2;
            if (boolean1.equals(boolean2)) {
                return 1;
            }
            if (boolean1.booleanValue()) {
                return 3;
            }
            return 2;
        }
        if (obj1 instanceof String) {
            if (obj1.equals(obj2)) {
                return 1;
            }
            return 4;
        }
        if (obj1 instanceof BigDecimal) {
            BigDecimal bigDecimal1 = (BigDecimal)obj1;
            BigDecimal bigDecimal2 = (BigDecimal)obj2;
            int compareResult = bigDecimal1.compareTo(bigDecimal2);
            if (compareResult < 0) {
                return 2;
            }
            if (compareResult == 0) {
                return 1;
            }
            return 3;
        }
        if (obj1 instanceof byte[]) {
            byte[] byteArray1 = (byte[])obj1;
            byte[] byteArray2 = (byte[])obj2;
            if (byteArray1.length != byteArray2.length) {
                return 4;
            }
            int i = 0;
            while (i < byteArray1.length) {
                if (byteArray1[i] != byteArray2[i]) {
                    return 4;
                }
                ++i;
            }
            return 1;
        }
        return 4;
    }

    public String getValue() {
        return this.valueSpace.getValue();
    }

    public void use() {
        ++this.usersCount;
    }

    public void reuse() {
        if (this.usersCount > 0) {
            --this.usersCount;
        }
        if (this.usersCount == 0) {
            this.valueSpace.reuse();
            this.length = -1;
        }
    }

    public boolean isReusable() {
        return this.usersCount == 0;
    }
}

