/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Annotation;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AnnotationImpl
extends BaseImpl
implements Annotation {
    protected Vector attribs = new Vector();
    protected Vector appInfos = new Vector();
    protected Vector usrInfos = new Vector();

    public AnnotationImpl() {
        this(null, null);
    }

    public AnnotationImpl(Node associatedNode, SchemaImpl schema) {
        super(associatedNode, schema);
    }

    @Override
    public int getTypeOfComponent() {
        return 15;
    }

    @Override
    public Vector getAttributes() {
        return this.attribs;
    }

    @Override
    public Vector getAppInformations() {
        return this.appInfos;
    }

    @Override
    public Vector getUserInformations() {
        return this.usrInfos;
    }

    @Override
    public void getAttributes(Vector collector) {
        Tools.removeFromVectorToVector(this.attribs, collector);
    }

    @Override
    public void getAppInformations(Vector collector) {
        Tools.removeFromVectorToVector(this.appInfos, collector);
    }

    @Override
    public void getUserInformations(Vector collector) {
        Tools.removeFromVectorToVector(this.usrInfos, collector);
    }

    @Override
    public Node[] getAttributesArray() {
        return this.createArray(this.attribs);
    }

    @Override
    public Node[] getAppInformationsArray() {
        return this.createArray(this.appInfos);
    }

    @Override
    public Node[] getUserInformationsArray() {
        return this.createArray(this.usrInfos);
    }

    private Node[] createArray(Vector collector) {
        Object[] result = new Node[collector.size()];
        collector.copyInto(result);
        return result;
    }

    @Override
    public boolean match(Base annotation) {
        if (!super.match(annotation)) {
            return false;
        }
        AnnotationImpl annotImpl = (AnnotationImpl)annotation;
        Vector attribsOfTheTargetAnnot = annotImpl.attribs;
        if (this.attribs.size() != attribsOfTheTargetAnnot.size()) {
            return false;
        }
        boolean[] checked = new boolean[attribsOfTheTargetAnnot.size()];
        int i = 0;
        while (i < this.attribs.size()) {
            Attr attr = (Attr)this.attribs.get(i);
            boolean found = false;
            int j = 0;
            while (j < attribsOfTheTargetAnnot.size()) {
                Attr targetAttr;
                if (!checked[j] && DOM.areEquivalent(attr, targetAttr = (Attr)attribsOfTheTargetAnnot.get(i))) {
                    checked[j] = true;
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            NamedNodeMap namedNodeMap = this.associatedNode.getAttributes();
            int i = 0;
            while (i < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String attribUri = attr.getNamespaceURI();
                if (attribUri != null && !attribUri.equals("") || !attr.getLocalName().equals("id")) {
                    this.attribs.add(attr);
                }
                ++i;
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i2 = 0;
            while (i2 < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i2);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("appinfo")) {
                        this.appInfos.add(node);
                    } else if (nodeLocalName.equals("documentation")) {
                        this.usrInfos.add(node);
                    }
                }
                ++i2;
            }
        }
    }

    @Override
    public BaseImpl clone(Hashtable typesCollector) {
        return this;
    }
}

