/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.InfoItemDeclarationBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.components.impl.structures.TypeDefinitionBaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AttributeDeclarationImpl
extends InfoItemDeclarationBaseImpl
implements AttributeDeclaration {
    public AttributeDeclarationImpl() {
        this(null, null, false);
    }

    public AttributeDeclarationImpl(Node associatedNode, SchemaImpl schema, boolean isTopLevel) {
        super(associatedNode, schema, isTopLevel);
    }

    @Override
    public int getTypeOfComponent() {
        return 4;
    }

    @Override
    public boolean match(Base attribDeclr) {
        return super.match(attribDeclr);
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.defaultValueConstr = this.loadAttribsCollector.getProperty("default");
            this.fixedValueConstr = this.loadAttribsCollector.getProperty("fixed");
            this.id = this.loadAttribsCollector.getProperty("id");
            String typeDefAttribValue = this.loadAttribsCollector.getProperty("type");
            if (typeDefAttribValue != null) {
                this.typeDefinition = (TypeDefinitionBaseImpl)Tools.getTopLevelComponent(this.schema, this.associatedNode, typeDefAttribValue, "TD");
                SchemaStructuresLoader.loadBase(this.typeDefinition);
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("simpleType")) {
                        if (this.typeDefinition != null) {
                            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of attribute declaration " + DOM.toXPath(this.associatedNode) + " is not correct. 'type' and <simpleType> are exclusive.");
                        }
                        this.typeDefinition = SchemaStructuresLoader.createSimpleTypeDefinition(node, this.schema, false, false);
                        SchemaStructuresLoader.loadBase(this.typeDefinition);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresLoader.createAnnotation(node, this.schema);
                        SchemaStructuresLoader.loadBase(this.annotation);
                    }
                }
                ++i;
            }
            if (this.name.equals("xmlns")) {
                throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of attribute declaration '" + DOM.toXPath(this.associatedNode) + "' is not correct. The {name} of an attribute declaration must not match 'xmlns'.");
            }
            if (this.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema-instance")) {
                throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of attribute declaration '" + DOM.toXPath(this.associatedNode) + "' is not correct. The {target namespace} of an attribute declaration, whether local or top-level, must not match http://www.w3.org/2001/XMLSchema-instance.");
            }
            if (this.typeDefinition == null) {
                this.typeDefinition = (TypeDefinitionBaseImpl)this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anySimpleType");
            }
            this.processValueConstraint();
            this.schema.addComponent(this);
        }
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable typesCollector) {
        AttributeDeclarationImpl result = (AttributeDeclarationImpl)super.initializeBase(base, typesCollector);
        return result;
    }
}

