/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.AttributeGroupDefinition;
import com.sap.engine.lib.schema.components.AttributeUse;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.components.impl.structures.AttributeDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeUseImpl;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.RedefineableQualifiedBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.components.impl.structures.WildcardImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AttributeGroupDefinitionImpl
extends RedefineableQualifiedBaseImpl
implements AttributeGroupDefinition {
    protected WildcardImpl attributeWildcard;
    protected Vector attribUses = new Vector();

    public AttributeGroupDefinitionImpl() {
        this(null, null, false, false);
    }

    public AttributeGroupDefinitionImpl(Node associatedNode, SchemaImpl schema, boolean isTopLevel, boolean isRedefined) {
        super(associatedNode, schema, isTopLevel, isRedefined);
    }

    @Override
    public Wildcard getAttributeWildcard() {
        return this.attributeWildcard;
    }

    @Override
    public int getTypeOfComponent() {
        return 5;
    }

    @Override
    public Vector getAttributeUses() {
        return this.attribUses;
    }

    @Override
    public void getAttributeUses(Vector attribUsesCollector) {
        Tools.removeFromVectorToVector(this.attribUses, attribUsesCollector);
    }

    @Override
    public AttributeUse[] getAttributeUsesArray() {
        Object[] result = new AttributeUse[this.attribUses.size()];
        this.attribUses.copyInto(result);
        return result;
    }

    @Override
    public boolean match(Base attribGroupDef) {
        if (!super.match(attribGroupDef)) {
            return false;
        }
        AttributeGroupDefinitionImpl targetAttribGroupDef = (AttributeGroupDefinitionImpl)attribGroupDef;
        if (!Tools.compareUnorderedBases(this.attribUses, targetAttribGroupDef.attribUses)) {
            return false;
        }
        return Tools.compareBases(this.attributeWildcard, targetAttribGroupDef.attributeWildcard);
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            boolean[] hasAlreadyIdAttribute = new boolean[1];
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("anyAttribute")) {
                        WildcardImpl wildcard = SchemaStructuresLoader.createWildcard(node, this.schema);
                        SchemaStructuresLoader.loadBase(wildcard);
                        if (this.attributeWildcard != null) {
                            this.attributeWildcard.intersect(wildcard);
                        } else {
                            this.attributeWildcard = wildcard;
                        }
                    } else if (nodeLocalName.equals("attribute")) {
                        AttributeUseImpl attribUse = SchemaStructuresLoader.createAttributeUse(node, this.schema);
                        SchemaStructuresLoader.loadBase(attribUse);
                        this.addAttributeUse(attribUse, hasAlreadyIdAttribute);
                    } else if (nodeLocalName.equals("attributeGroup")) {
                        AttributeGroupDefinitionImpl attribGroup = SchemaStructuresLoader.createAttributeGroupDefinition(node, this.schema, false, false);
                        SchemaStructuresLoader.loadBase(attribGroup);
                        int j = 0;
                        while (j < attribGroup.attribUses.size()) {
                            AttributeUseImpl attribUse = (AttributeUseImpl)attribGroup.attribUses.get(j);
                            this.addAttributeUse(attribUse, hasAlreadyIdAttribute);
                            ++j;
                        }
                        this.initWildcard(attribGroup.attributeWildcard);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresLoader.createAnnotation(node, this.schema);
                        SchemaStructuresLoader.loadBase(this.annotation);
                    }
                }
                ++i;
            }
            this.schema.addComponent(this);
        }
    }

    private void addAttributeUse(AttributeUseImpl attribUse, boolean[] hasAlreadyIdAttribute) throws SchemaComponentException {
        AttributeDeclarationImpl attribDeclr = attribUse.attribDeclr;
        if (attribDeclr.typeDefinition.isDerivedFrom(this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "ID"), false, false)) {
            if (hasAlreadyIdAttribute[0]) {
                throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of attribute group " + DOM.toXPath(this.associatedNode) + " is not correct. Two members of the {attribute uses} must not have {attribute declaration}s whose {type definition}s are or are derived from ID.");
            }
            hasAlreadyIdAttribute[0] = true;
        }
        int i = 0;
        while (i < this.attribUses.size()) {
            AttributeUseImpl addedAttribUse = (AttributeUseImpl)this.attribUses.get(i);
            if (attribDeclr.getQualifiedKey().equals(addedAttribUse.attribDeclr.getQualifiedKey())) {
                throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of attribute group " + DOM.toXPath(this.associatedNode) + " is not correct. Two members of the {attribute uses} must not have {attribute declaration}s whose {name}s and {target namespace}s are identical.");
            }
            ++i;
        }
        this.attribUses.add(attribUse);
    }

    private void initWildcard(WildcardImpl wildcard) throws SchemaComponentException {
        if (wildcard != null) {
            if (this.attributeWildcard == null) {
                this.attributeWildcard = (WildcardImpl)wildcard.clone(new Hashtable());
            } else {
                this.attributeWildcard.intersect(wildcard);
            }
        }
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        AttributeGroupDefinitionImpl result = (AttributeGroupDefinitionImpl)super.initializeBase(base, clonedCollector);
        if (this.attributeWildcard != null) {
            result.attributeWildcard = (WildcardImpl)this.attributeWildcard.clone(clonedCollector);
        }
        Tools.cloneVectorWithBases(this.attribUses, result.attribUses, clonedCollector);
        return result;
    }
}

