/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.AttributeUse;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.FundamentalFacets;
import com.sap.engine.lib.schema.components.impl.ffacets.Value;
import com.sap.engine.lib.schema.components.impl.ffacets.ValueComparator;
import com.sap.engine.lib.schema.components.impl.structures.AttributeDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.components.impl.structures.SimpleTypeDefinitionImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Node;

public final class AttributeUseImpl
extends BaseImpl
implements AttributeUse {
    protected boolean isRequired;
    protected boolean isProhibited;
    protected AttributeDeclarationImpl attribDeclr;
    protected String valueConstrDefault;
    protected String valueConstrFixed;

    public AttributeUseImpl() {
        this(null, null);
    }

    public AttributeUseImpl(Node associatedNode, SchemaImpl schema) {
        super(associatedNode, schema);
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public boolean isProhibited() {
        return this.isProhibited;
    }

    @Override
    public AttributeDeclaration getAttributeDeclaration() {
        return this.attribDeclr;
    }

    @Override
    public String getValueConstraintDefault() {
        return this.valueConstrDefault;
    }

    @Override
    public String getValueConstraintFixed() {
        return this.valueConstrFixed;
    }

    @Override
    public int getTypeOfComponent() {
        return 6;
    }

    @Override
    public boolean match(Base attribUse) {
        if (!super.match(attribUse)) {
            return false;
        }
        AttributeUseImpl attribUseTarget = (AttributeUseImpl)attribUse;
        return this.isRequired == attribUseTarget.isRequired && this.isProhibited == attribUseTarget.isProhibited && this.attribDeclr.match(attribUseTarget.attribDeclr) && this.equalValueConstraints(attribUseTarget);
    }

    private boolean equalValueConstraints(AttributeUseImpl attribUse) {
        return Tools.compareObjects(this.valueConstrDefault, attribUse.valueConstrDefault) && Tools.compareObjects(this.valueConstrFixed, attribUse.valueConstrFixed);
    }

    @Override
    public void load() throws SchemaComponentException {
        Value attribDeclrFFacetsFixedValue;
        Value fFacetsFixedValue;
        this.valueConstrDefault = this.loadAttribsCollector.getProperty("default");
        this.valueConstrFixed = this.loadAttribsCollector.getProperty("fixed");
        if (this.valueConstrDefault != null && this.valueConstrFixed != null) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of attribute use " + DOM.toXPath(this.associatedNode) + " is not correct. 'Default' and 'fixed' must not both be present.");
        }
        String value = this.loadAttribsCollector.getProperty("use");
        if (value != null) {
            if (value.equals("prohibited")) {
                this.isProhibited = true;
            } else if (value.equals("required")) {
                this.isRequired = true;
            }
        }
        this.attribDeclr = SchemaStructuresLoader.createAttributeDeclaration(this.associatedNode, this.schema, false);
        SchemaStructuresLoader.loadBase(this.attribDeclr);
        FundamentalFacets ffacets = ((SimpleTypeDefinitionImpl)this.attribDeclr.typeDefinition).fundamentalFacets;
        if (ffacets != null && this.valueConstrFixed != null && this.attribDeclr.fixedValueConstr != null && ValueComparator.compare(fFacetsFixedValue = ffacets.parse(this.valueConstrFixed), attribDeclrFFacetsFixedValue = ffacets.parse(this.attribDeclr.fixedValueConstr)) != 1) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : If the {attribute declaration} has a fixed {value constraint}, then if the attribute use has a {value constraint}, it must also be fixed and its value must match that of the {attribute declaration}'s {value constraint}.");
        }
        if (this.valueConstrDefault != null && (this.isProhibited || this.isRequired)) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of attribute use '" + DOM.toXPath(this.associatedNode) + "' is not correct. If {default} and {use} are both present, {use} must have the actual value 'optional'.");
        }
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        AttributeUseImpl result = (AttributeUseImpl)super.initializeBase(new AttributeUseImpl(), clonedCollector);
        result.isRequired = this.isRequired;
        result.isProhibited = this.isProhibited;
        result.attribDeclr = (AttributeDeclarationImpl)this.attribDeclr.clone(clonedCollector);
        result.valueConstrDefault = this.valueConstrDefault;
        result.valueConstrFixed = this.valueConstrFixed;
        return result;
    }
}

