/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.AttributeUse;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.components.impl.structures.AnnotationImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeUseImpl;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.FacetImpl;
import com.sap.engine.lib.schema.components.impl.structures.ModelGroupImpl;
import com.sap.engine.lib.schema.components.impl.structures.ParticleImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.components.impl.structures.SimpleTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.TypeDefinitionBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.WildcardImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ComplexTypeDefinitionImpl
extends TypeDefinitionBaseImpl
implements ComplexTypeDefinition {
    protected boolean isDerivationMethodExtension;
    protected boolean isDerivationMethodRestriction;
    protected boolean isProhibitedSubstitutionExtension;
    protected boolean isProhibitedSubstitutionRestriction;
    protected boolean isAbstract;
    protected WildcardImpl attributeWildcard;
    protected Vector attribUses = new Vector();
    protected SimpleTypeDefinitionImpl contentTypeSimpleTypeDefinition;
    protected ParticleImpl contentTypeContentModel;
    protected boolean isMixed;
    protected Vector annotations = new Vector();
    protected boolean isPreloaded;
    protected boolean isPreloading;
    private boolean hasSimpleContent;
    private boolean hasComplexContent;
    private Vector attribGroups = new Vector();

    public ComplexTypeDefinitionImpl() {
        this(null, null, false, false);
    }

    public ComplexTypeDefinitionImpl(Node associatedNode, SchemaImpl schema, boolean isTopLevel, boolean isRedefined) {
        super(associatedNode, schema, isTopLevel, isRedefined);
    }

    protected boolean isPreloading() {
        return this.isPreloading;
    }

    protected void setPreloading(boolean isPreloading) {
        this.isPreloading = isPreloading;
    }

    protected boolean isPreloaded() {
        return this.isPreloaded;
    }

    protected void setPreloaded(boolean isPreloaded) {
        this.isPreloaded = isPreloaded;
    }

    @Override
    public boolean isDerivationMethodExtension() {
        return this.isDerivationMethodExtension;
    }

    @Override
    public boolean isDerivationMethodRestriction() {
        return this.isDerivationMethodRestriction;
    }

    @Override
    public boolean isProhibitedSubstitutionExtension() {
        return this.isProhibitedSubstitutionExtension;
    }

    @Override
    public boolean isProhibitedSubstitutionRestriction() {
        return this.isProhibitedSubstitutionRestriction;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public Wildcard getAttributeWildcard() {
        return this.attributeWildcard;
    }

    @Override
    public Vector getAttributeUses() {
        return this.attribUses;
    }

    @Override
    public void getAttributeUses(Vector collector) {
        Tools.removeFromVectorToVector(this.attribUses, collector);
    }

    @Override
    public AttributeUse[] getAttributeUsesArray() {
        Object[] result = new AttributeUse[this.attribUses.size()];
        this.attribUses.copyInto(result);
        return result;
    }

    @Override
    public SimpleTypeDefinition getContentTypeSimpleTypeDefinition() {
        return this.contentTypeSimpleTypeDefinition;
    }

    @Override
    public Particle getContentTypeContentModel() {
        return this.contentTypeContentModel;
    }

    @Override
    public boolean isContentTypeEmpty() {
        return this.contentTypeContentModel == null && this.contentTypeSimpleTypeDefinition == null;
    }

    @Override
    public boolean isMixed() {
        return this.isMixed;
    }

    @Override
    public int getTypeOfComponent() {
        return 1;
    }

    @Override
    public boolean match(Base complexTypeDef) {
        if (!super.match(complexTypeDef)) {
            return false;
        }
        ComplexTypeDefinitionImpl targetComplTypeDef = (ComplexTypeDefinitionImpl)complexTypeDef;
        return this.isDerivationMethodExtension == targetComplTypeDef.isDerivationMethodExtension && this.isFinalExtension == targetComplTypeDef.isFinalExtension && this.isFinalRestriction == targetComplTypeDef.isFinalRestriction && this.isProhibitedSubstitutionExtension == targetComplTypeDef.isProhibitedSubstitutionExtension && this.isProhibitedSubstitutionRestriction == targetComplTypeDef.isProhibitedSubstitutionRestriction && this.isAbstract == targetComplTypeDef.isAbstract && this.isMixed == targetComplTypeDef.isMixed && Tools.compareUnorderedBases(this.attribUses, targetComplTypeDef.attribUses) && Tools.compareBases(this.attributeWildcard, targetComplTypeDef.attributeWildcard) && Tools.compareBases(this.contentTypeContentModel, targetComplTypeDef.contentTypeContentModel) && Tools.compareBases(this.contentTypeSimpleTypeDefinition, targetComplTypeDef.contentTypeSimpleTypeDefinition);
    }

    protected void preload() throws SchemaComponentException {
        if (this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl) {
            SchemaStructuresLoader.preloadComplexType((ComplexTypeDefinitionImpl)this.baseTypeDefinition);
        }
        this.loadAttributeUses();
        this.loadAttributeWildcard();
        this.loadContentTypeContentModel();
        this.validateContentModelOfBaseTypeDefinition();
    }

    private void validateContentModelOfBaseTypeDefinition() throws SchemaComponentException {
        if (this.hasSimpleContent && this.isDerivationMethodRestriction) {
            ComplexTypeDefinitionImpl baseComplTypeDefinition = (ComplexTypeDefinitionImpl)this.baseTypeDefinition;
            if (baseComplTypeDefinition.isMixed()) {
                ParticleImpl baseTypeContentModel = (ParticleImpl)baseComplTypeDefinition.getContentTypeContentModel();
                if (baseTypeContentModel != null && !baseTypeContentModel.isEmptiable()) {
                    throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <simpleContent> alternative is chosen and the base type defintion is a complex type with mixed content, the content particle of the base type must be \u00b7emptiable\u00b7.");
                }
                if (this.contentTypeSimpleTypeDefinition == null) {
                    throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <simpleContent> alternative is chosen and the base type definition is a complex type with mixed content, there must be a <simpleType> among the [children] of <restriction>.");
                }
            } else if (baseComplTypeDefinition.contentTypeSimpleTypeDefinition == null) {
                throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <simpleContent> alternative is chosen and the base type definition is a complex type, the content of the base type must be simple.");
            }
        }
    }

    private void loadContentTypeContentModel() throws SchemaComponentException {
        ParticleImpl baseContentTypeContentModel;
        if (this.hasComplexContent && this.isDerivationMethodExtension && (baseContentTypeContentModel = ((ComplexTypeDefinitionImpl)this.baseTypeDefinition).contentTypeContentModel) != null) {
            if (this.contentTypeContentModel == null) {
                this.contentTypeContentModel = baseContentTypeContentModel;
            } else {
                ParticleImpl explicitContentTypeContentModel = this.contentTypeContentModel;
                this.contentTypeContentModel = new ParticleImpl(this.schema);
                this.contentTypeContentModel.minOccurs = 1;
                this.contentTypeContentModel.maxOccurs = 1;
                ModelGroupImpl modelGroup = new ModelGroupImpl(this.schema);
                modelGroup.compositor = 3;
                modelGroup.addParticle(baseContentTypeContentModel);
                modelGroup.addParticle(explicitContentTypeContentModel);
                modelGroup.calculateEffectiveTotalRange();
                this.contentTypeContentModel.term = modelGroup;
            }
        }
    }

    private void loadAttributeUses() throws SchemaComponentException {
        this.collectAttributeUsesFromAttributeGroups();
        this.collectAttributeUsesFromTheBase();
    }

    private void collectAttributeUsesFromTheBase() throws SchemaComponentException {
        if (this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl) {
            if (this.isDerivationMethodRestriction) {
                this.collectRestrictedAttributeUses(((ComplexTypeDefinitionImpl)this.baseTypeDefinition).attribUses);
            } else if (this.isDerivationMethodExtension) {
                this.collectExtendedAttributeUses(((ComplexTypeDefinitionImpl)this.baseTypeDefinition).attribUses);
            }
        }
    }

    private void collectRestrictedAttributeUses(Vector restrictedAttribUses) throws SchemaComponentException {
        int i = 0;
        while (i < restrictedAttribUses.size()) {
            AttributeUseImpl restrictedAttribUse = (AttributeUseImpl)restrictedAttribUses.get(i);
            this.collectRestrictedAttributeUse(restrictedAttribUse);
            ++i;
        }
    }

    private void collectRestrictedAttributeUse(AttributeUseImpl restrictedAttribUse) throws SchemaComponentException {
        String restrictedAttribUseAttriDeclrNs = restrictedAttribUse.attribDeclr.getTargetNamespace();
        String restrictedAttribUseAttriDeclrName = restrictedAttribUse.attribDeclr.getName();
        TypeDefinitionBase idTypeDefinition = this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "ID");
        boolean attribUseAttribDeclrTypeIsDrvFromID = restrictedAttribUse.attribDeclr.typeDefinition.isDerivedFrom(idTypeDefinition, false, false);
        boolean collect = true;
        int i = 0;
        while (i < this.attribUses.size()) {
            AttributeUseImpl collectedAttribUse = (AttributeUseImpl)this.attribUses.get(i);
            if (collectedAttribUse.attribDeclr.getTargetNamespace().equals(restrictedAttribUseAttriDeclrNs) && collectedAttribUse.attribDeclr.getName().equals(restrictedAttribUseAttriDeclrName)) {
                collect = false;
            }
            if (!collect) break;
            this.validateAttribUsesForMultipleIDDerivation(collectedAttribUse, restrictedAttribUse, attribUseAttribDeclrTypeIsDrvFromID, idTypeDefinition);
            ++i;
        }
        if (collect) {
            this.attribUses.add(restrictedAttribUse);
        }
    }

    private void collectAttributeUsesFromAttributeGroups() throws SchemaComponentException {
        int i = 0;
        while (i < this.attribGroups.size()) {
            AttributeGroupDefinitionImpl attribGroup = (AttributeGroupDefinitionImpl)this.attribGroups.get(i);
            this.collectAttributeUsesFromAttributeGroup(attribGroup);
            ++i;
        }
    }

    private void collectAttributeUsesFromAttributeGroup(AttributeGroupDefinitionImpl attribGroup) throws SchemaComponentException {
        this.collectExtendedAttributeUses(attribGroup.attribUses);
    }

    private void collectExtendedAttributeUses(Vector extendedAttribUses) throws SchemaComponentException {
        int i = 0;
        while (i < extendedAttribUses.size()) {
            AttributeUseImpl attribUse = (AttributeUseImpl)extendedAttribUses.get(i);
            this.collectExtendedAttributeUse(attribUse);
            ++i;
        }
    }

    private void collectExtendedAttributeUse(AttributeUseImpl attribUse) throws SchemaComponentException {
        String attribUseAttribDeclrNs = attribUse.attribDeclr.getTargetNamespace();
        String attribUseAttribDeclrName = attribUse.attribDeclr.getName();
        TypeDefinitionBase idTypeDefinition = this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "ID");
        boolean attribUseAttribDeclrTypeIsDrvFromID = attribUse.attribDeclr.typeDefinition.isDerivedFrom(idTypeDefinition, false, false);
        int i = 0;
        while (i < this.attribUses.size()) {
            AttributeUseImpl collectedAttribUse = (AttributeUseImpl)this.attribUses.get(i);
            if (collectedAttribUse.attribDeclr.getTargetNamespace().equals(attribUseAttribDeclrNs) && collectedAttribUse.attribDeclr.getName().equals(attribUseAttribDeclrName)) {
                throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. Two of the attibute uses are associated with attribute declarations with the same namespaces and names (namespase : " + attribUse.attribDeclr.getTargetNamespace() + "; name : " + attribUse.attribDeclr.getName() + ").");
            }
            this.validateAttribUsesForMultipleIDDerivation(collectedAttribUse, attribUse, attribUseAttribDeclrTypeIsDrvFromID, idTypeDefinition);
            ++i;
        }
        this.attribUses.add(attribUse);
    }

    private void validateAttribUsesForMultipleIDDerivation(AttributeUseImpl collectedAttribUse, AttributeUseImpl newAttribUse, boolean newAttribUseAttribDeclrTypeIsDrvFromID, TypeDefinitionBase idTypeDefinition) throws SchemaComponentException {
        if (collectedAttribUse.attribDeclr.typeDefinition.isDerivedFrom(idTypeDefinition, false, false) && newAttribUseAttribDeclrTypeIsDrvFromID) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. Two of the attibute uses are associated with attribute declarations which types are derived from " + idTypeDefinition.toString() + ". (" + collectedAttribUse.attribDeclr.toString() + "; " + newAttribUse.attribDeclr.toString() + ").");
        }
    }

    private void loadAttributeWildcard() throws SchemaComponentException {
        if (this.isDerivationMethodRestriction) {
            this.attributeWildcard = this.determineCompleteAttributeWildcard();
        } else if (this.isDerivationMethodExtension) {
            WildcardImpl baseAttribWildcard = this.determineBaseAttributeWildcard();
            WildcardImpl completeAttribWildcard = this.determineCompleteAttributeWildcard();
            if (baseAttribWildcard == null) {
                this.attributeWildcard = completeAttribWildcard;
            } else if (completeAttribWildcard == null) {
                this.attributeWildcard = baseAttribWildcard;
            } else {
                this.attributeWildcard = baseAttribWildcard;
                this.attributeWildcard.unite(completeAttribWildcard);
            }
        } else {
            this.attributeWildcard = this.determineCompleteAttributeWildcard();
        }
    }

    private WildcardImpl determineLocalAttributeWildcard() {
        return this.attributeWildcard;
    }

    private WildcardImpl determineCompleteAttributeWildcard() throws SchemaComponentException {
        WildcardImpl localAttribWildcard;
        WildcardImpl completeAttribWildcard = localAttribWildcard = this.determineLocalAttributeWildcard();
        int i = 0;
        while (i < this.attribGroups.size()) {
            AttributeGroupDefinitionImpl attribGroupDef = (AttributeGroupDefinitionImpl)this.attribGroups.get(i);
            WildcardImpl attribGroupDefWildcard = (WildcardImpl)attribGroupDef.getAttributeWildcard();
            if (attribGroupDefWildcard != null) {
                if (completeAttribWildcard == null) {
                    completeAttribWildcard = (WildcardImpl)attribGroupDefWildcard.clone(new Hashtable());
                } else {
                    completeAttribWildcard.intersect(attribGroupDefWildcard);
                }
            }
            ++i;
        }
        return completeAttribWildcard;
    }

    private WildcardImpl determineBaseAttributeWildcard() {
        WildcardImpl baseAttribWildcard;
        if (this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl && (baseAttribWildcard = (WildcardImpl)((ComplexTypeDefinitionImpl)this.baseTypeDefinition).getAttributeWildcard()) != null) {
            return (WildcardImpl)baseAttribWildcard.clone(new Hashtable());
        }
        return null;
    }

    private WildcardImpl createWildcard(Node node) throws SchemaComponentException {
        WildcardImpl wildcard = SchemaStructuresLoader.createWildcard(node, this.schema);
        SchemaStructuresLoader.loadBase(wildcard);
        return wildcard;
    }

    private AttributeUseImpl createAttributeUse(Node node) throws SchemaComponentException {
        AttributeUseImpl attribUse = SchemaStructuresLoader.createAttributeUse(node, this.schema);
        SchemaStructuresLoader.loadBase(attribUse);
        return attribUse;
    }

    private AttributeGroupDefinitionImpl createAttributeGroupDefinition(Node node) throws SchemaComponentException {
        AttributeGroupDefinitionImpl attribGroup = SchemaStructuresLoader.createAttributeGroupDefinition(node, this.schema, false, false);
        SchemaStructuresLoader.loadBase(attribGroup);
        return attribGroup;
    }

    private SimpleTypeDefinitionImpl createSimpleTypeDefinition(Node node) throws SchemaComponentException {
        SimpleTypeDefinitionImpl simpleTypeDef = SchemaStructuresLoader.createSimpleTypeDefinition(node, this.schema, false, false);
        SchemaStructuresLoader.loadBase(simpleTypeDef);
        return simpleTypeDef;
    }

    private AnnotationImpl createAnnotation(Node node) throws SchemaComponentException {
        AnnotationImpl annotation = SchemaStructuresLoader.createAnnotation(node, this.schema);
        SchemaStructuresLoader.loadBase(annotation);
        return annotation;
    }

    private ParticleImpl createParticle(Node node) throws SchemaComponentException {
        ParticleImpl particle = SchemaStructuresLoader.createParticle(node, this.schema);
        SchemaStructuresLoader.loadBase(particle);
        return particle;
    }

    private FacetImpl createFacet(Node node) throws SchemaComponentException {
        FacetImpl facet = SchemaStructuresLoader.createFacet(node, this.schema);
        SchemaStructuresLoader.loadBase(facet);
        return facet;
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            String blockAttribValue;
            this.id = this.loadAttribsCollector.getProperty("id");
            String abstractAttribValue = this.loadAttribsCollector.getProperty("abstract");
            if (abstractAttribValue != null) {
                this.isAbstract = abstractAttribValue.equals("true");
            }
            if ((blockAttribValue = this.loadAttribsCollector.getProperty("block")) != null) {
                if (blockAttribValue.equals("#all")) {
                    this.isProhibitedSubstitutionExtension = true;
                    this.isProhibitedSubstitutionRestriction = true;
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(blockAttribValue);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("extension")) {
                            this.isProhibitedSubstitutionExtension = true;
                            continue;
                        }
                        if (!token.equals("restriction")) continue;
                        this.isProhibitedSubstitutionRestriction = true;
                    }
                }
            } else {
                this.isProhibitedSubstitutionExtension = this.schema.isProhibitedExtension();
                this.isProhibitedSubstitutionRestriction = this.schema.isProhibitedRestriction();
            }
            String finalAttribValue = this.loadAttribsCollector.getProperty("final");
            if (finalAttribValue != null) {
                if (finalAttribValue.equals("#all")) {
                    this.isFinalExtension = true;
                    this.isFinalRestriction = true;
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(finalAttribValue);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("extension")) {
                            this.isFinalExtension = true;
                            continue;
                        }
                        if (!token.equals("restriction")) continue;
                        this.isFinalRestriction = true;
                    }
                }
            } else {
                this.isFinalExtension = this.schema.isFinalExtension();
                this.isFinalRestriction = this.schema.isFinalRestriction();
            }
            String mixedAttribValue = this.loadAttribsCollector.getProperty("mixed");
            if (mixedAttribValue != null) {
                this.isMixed = mixedAttribValue.equals("true");
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("group") || nodeLocalName.equals("all") || nodeLocalName.equals("choice") || nodeLocalName.equals("sequence")) {
                        this.baseTypeDefinition = (TypeDefinitionBaseImpl)this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anyType");
                        this.contentTypeContentModel = this.createParticle(node);
                    } else if (nodeLocalName.equals("anyAttribute")) {
                        this.attributeWildcard = this.createWildcard(node);
                    } else if (nodeLocalName.equals("simpleContent")) {
                        this.loadSimpleContent(node);
                    } else if (nodeLocalName.equals("complexContent")) {
                        this.loadComplexContent(node);
                    } else if (nodeLocalName.equals("attribute")) {
                        this.collectExtendedAttributeUse(this.createAttributeUse(node));
                    } else if (nodeLocalName.equals("attributeGroup")) {
                        this.attribGroups.add(this.createAttributeGroupDefinition(node));
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = this.createAnnotation(node);
                    }
                }
                ++i;
            }
            if (this.baseTypeDefinition != null) {
                if (this.isDerivationMethodExtension) {
                    if (this.baseTypeDefinition.isFinalExtension) {
                        throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the {derivation method} is extension The {final} of the base type definition must not contain extension.");
                    }
                } else if (this.isDerivationMethodRestriction && this.baseTypeDefinition.isFinalRestriction) {
                    throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the {derivation method} is restriction The {final} of the base type definition must not contain restriction.");
                }
            } else {
                this.baseTypeDefinition = (TypeDefinitionBaseImpl)this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anyType");
            }
            this.schema.addComponent(this);
            this.schema.addComplexTypeDefinition_All(this);
        }
    }

    private void loadSimpleContent(Node node) throws SchemaComponentException {
        this.hasSimpleContent = true;
        NodeList childNodes = node.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            if (childNode.getNodeType() == 1) {
                String uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                    if (elemName.equals("annotation")) {
                        this.annotations.add(this.createAnnotation(childNode));
                    } else if (elemName.equals("restriction")) {
                        this.loadSimpleContentRestriction(childNode);
                    } else if (elemName.equals("extension")) {
                        this.loadSimpleContentExtension(childNode);
                    }
                }
            }
            ++j;
        }
    }

    private void loadSimpleContentRestriction(Node node) throws SchemaComponentException {
        NamedNodeMap attribsMap = node.getAttributes();
        int i = 0;
        while (i < attribsMap.getLength()) {
            Node attrib = attribsMap.item(i);
            String attribName = attrib.getLocalName();
            String uri = attrib.getNamespaceURI();
            String value = attrib.getNodeValue();
            if ((uri == null || uri.equals("")) && attribName.equals("base")) {
                this.baseTypeDefinition = (TypeDefinitionBaseImpl)Tools.getTopLevelComponent(this.schema, node, value, "TD");
                this.validateForCircularDefinitions();
                SchemaStructuresLoader.loadBase(this.baseTypeDefinition);
                if (!(this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl)) {
                    throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <simpleContent> alternative is chosen, the base type definition must be a complex type.");
                }
                ComplexTypeDefinitionImpl complBaseTypeDef = (ComplexTypeDefinitionImpl)this.baseTypeDefinition;
                if (complBaseTypeDef.contentTypeSimpleTypeDefinition != null) {
                    this.contentTypeSimpleTypeDefinition = (SimpleTypeDefinitionImpl)complBaseTypeDef.contentTypeSimpleTypeDefinition.clone(new Hashtable());
                }
            }
            ++i;
        }
        NodeList childNodes = node.getChildNodes();
        boolean removeEnumerationFacets = true;
        boolean removePatternFacets = true;
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            Node childNode = childNodes.item(i2);
            if (childNode.getNodeType() == 1) {
                String uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                    if (elemName.equals("simpleType")) {
                        this.contentTypeSimpleTypeDefinition = this.createSimpleTypeDefinition(childNode);
                    } else if (this.contentTypeSimpleTypeDefinition != null && (elemName.equals("minExclusive") || elemName.equals("minInclusive") || elemName.equals("maxExclusive") || elemName.equals("minInclusive") || elemName.equals("totalDigits") || elemName.equals("fractionDigits") || elemName.equals("length") || elemName.equals("minLength") || elemName.equals("maxLength") || elemName.equals("enumeration") || elemName.equals("whiteSpace") || elemName.equals("pattern"))) {
                        FacetImpl restrictedFacet = this.createFacet(childNode);
                        this.contentTypeSimpleTypeDefinition.addRestrictedFacet(restrictedFacet, removeEnumerationFacets, removePatternFacets);
                        removeEnumerationFacets = !elemName.equals("enumeration");
                        removePatternFacets = !elemName.equals("pattern");
                    } else if (elemName.equals("attribute")) {
                        this.collectExtendedAttributeUse(this.createAttributeUse(childNode));
                    } else if (elemName.equals("attributeGroup")) {
                        this.attribGroups.add(this.createAttributeGroupDefinition(childNode));
                    } else if (elemName.equals("anyAttribute")) {
                        this.attributeWildcard = this.createWildcard(childNode);
                    }
                }
            }
            ++i2;
        }
        this.isDerivationMethodRestriction = true;
    }

    private void loadSimpleContentExtension(Node node) throws SchemaComponentException {
        String uri;
        NamedNodeMap attribsMap = node.getAttributes();
        int i = 0;
        while (i < attribsMap.getLength()) {
            Node attrib = attribsMap.item(i);
            String attribName = attrib.getLocalName();
            uri = attrib.getNamespaceURI();
            String value = attrib.getNodeValue();
            if ((uri == null || uri.equals("")) && attribName.equals("base")) {
                this.baseTypeDefinition = (TypeDefinitionBaseImpl)Tools.getTopLevelComponent(this.schema, node, value, "TD");
                this.validateForCircularDefinitions();
                SchemaStructuresLoader.loadBase(this.baseTypeDefinition);
                if (this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl) {
                    ComplexTypeDefinitionImpl complBaseTypeDef = (ComplexTypeDefinitionImpl)this.baseTypeDefinition;
                    if (complBaseTypeDef.contentTypeSimpleTypeDefinition == null) {
                        throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <simpleContent> and <extension> alternatives are chosen, and the base type definition is a complex type, the content model of base type must be simple.");
                    }
                    this.contentTypeSimpleTypeDefinition = complBaseTypeDef.contentTypeSimpleTypeDefinition;
                } else {
                    this.contentTypeSimpleTypeDefinition = (SimpleTypeDefinitionImpl)this.baseTypeDefinition;
                }
            }
            ++i;
        }
        NodeList childNodes = node.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            Node childNode = childNodes.item(i2);
            if (childNode.getNodeType() == 1) {
                uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                    if (elemName.equals("attribute")) {
                        this.collectExtendedAttributeUse(this.createAttributeUse(childNode));
                    } else if (elemName.equals("attributeGroup")) {
                        this.attribGroups.add(this.createAttributeGroupDefinition(childNode));
                    } else if (elemName.equals("anyAttribute")) {
                        this.attributeWildcard = this.createWildcard(childNode);
                    }
                }
            }
            ++i2;
        }
        this.isDerivationMethodExtension = true;
    }

    private void loadComplexContent(Node node) throws SchemaComponentException {
        this.hasComplexContent = true;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attrib = namedNodeMap.item(i);
            String uri = attrib.getNamespaceURI();
            if (uri == null || uri.equals("")) {
                String attribName = attrib.getLocalName();
                String value = attrib.getNodeValue();
                if (attribName.equals("mixed")) {
                    if (value.equals("true")) {
                        this.isMixed = true;
                    } else if (value.equals("false")) {
                        this.isMixed = false;
                    }
                }
            }
            ++i;
        }
        NodeList nodeList = node.getChildNodes();
        int i2 = 0;
        while (i2 < nodeList.getLength()) {
            String uri;
            Node childNode = nodeList.item(i2);
            if (childNode.getNodeType() == 1 && (uri = childNode.getNamespaceURI()).equals("http://www.w3.org/2001/XMLSchema")) {
                String elemName = childNode.getLocalName();
                if (elemName.equals("restriction")) {
                    this.loadComplexContentRestriction(childNode);
                } else if (elemName.equals("extension")) {
                    this.loadComplexContentExtension(childNode);
                }
            }
            ++i2;
        }
    }

    private void loadComplexContentRestriction(Node node) throws SchemaComponentException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attrib = namedNodeMap.item(i);
            String uri = attrib.getNamespaceURI();
            if (uri == null || uri.equals("")) {
                String attribName = attrib.getLocalName();
                String value = attrib.getNodeValue();
                if (attribName.equals("base")) {
                    this.baseTypeDefinition = (TypeDefinitionBaseImpl)Tools.getTopLevelComponent(this.schema, node, value, "TD");
                    this.validateForCircularDefinitions();
                    SchemaStructuresLoader.loadBase(this.baseTypeDefinition);
                    if (!(this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl)) {
                        throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <complexContent> alternative is chosen, the base type definition must be a complex type.");
                    }
                }
            }
            ++i;
        }
        NodeList nodeList = node.getChildNodes();
        int i2 = 0;
        while (i2 < nodeList.getLength()) {
            String uri;
            Node childNode = nodeList.item(i2);
            if (childNode.getNodeType() == 1 && (uri = childNode.getNamespaceURI()).equals("http://www.w3.org/2001/XMLSchema")) {
                String elemName = childNode.getLocalName();
                if (elemName.equals("attribute")) {
                    this.collectExtendedAttributeUse(this.createAttributeUse(childNode));
                } else if (elemName.equals("attributeGroup")) {
                    this.attribGroups.add(this.createAttributeGroupDefinition(childNode));
                } else if (elemName.equals("anyAttribute")) {
                    this.attributeWildcard = this.createWildcard(childNode);
                } else if (elemName.equals("group") || elemName.equals("all") || elemName.equals("choice") || elemName.equals("sequence")) {
                    this.contentTypeContentModel = this.createParticle(childNode);
                }
            }
            ++i2;
        }
        this.isDerivationMethodRestriction = true;
    }

    private void loadComplexContentExtension(Node node) throws SchemaComponentException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attrib = namedNodeMap.item(i);
            String uri = attrib.getNamespaceURI();
            if (uri == null || uri.equals("")) {
                String attribName = attrib.getLocalName();
                String value = attrib.getNodeValue();
                if (attribName.equals("base")) {
                    this.baseTypeDefinition = (TypeDefinitionBaseImpl)Tools.getTopLevelComponent(this.schema, node, value, "TD");
                    this.validateForCircularDefinitions();
                    SchemaStructuresLoader.loadBase(this.baseTypeDefinition);
                    if (!(this.baseTypeDefinition instanceof ComplexTypeDefinitionImpl)) {
                        throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <complexContent> alternative is chosen, the base type definition must be a complex type.");
                    }
                }
            }
            ++i;
        }
        NodeList nodeList = node.getChildNodes();
        int i2 = 0;
        while (i2 < nodeList.getLength()) {
            String uri;
            Node childNode = nodeList.item(i2);
            if (childNode.getNodeType() == 1 && (uri = childNode.getNamespaceURI()).equals("http://www.w3.org/2001/XMLSchema")) {
                String elemName = childNode.getLocalName();
                if (elemName.equals("attribute")) {
                    this.collectExtendedAttributeUse(this.createAttributeUse(childNode));
                } else if (elemName.equals("attributeGroup")) {
                    this.attribGroups.add(this.createAttributeGroupDefinition(childNode));
                } else if (elemName.equals("anyAttribute")) {
                    this.attributeWildcard = this.createWildcard(childNode);
                } else if (elemName.equals("group") || elemName.equals("all") || elemName.equals("choice") || elemName.equals("sequence")) {
                    this.contentTypeContentModel = this.createParticle(childNode);
                }
            }
            ++i2;
        }
        this.isDerivationMethodExtension = true;
    }

    private void validateForCircularDefinitions() throws SchemaComponentException {
        if (this.baseTypeDefinition.isLoading() && this.baseTypeDefinition.isDerivedFrom(this, false, false) && !this.baseTypeDefinition.isRedefined) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of complex type " + DOM.toXPath(this.associatedNode) + " is not correct. Circular definitions detected.");
        }
    }

    @Override
    public boolean isDerivedFrom(TypeDefinitionBase typeDefinition, boolean disallowedRestriction, boolean disallowedExtension) {
        TypeDefinitionBaseImpl typeDefBase = (TypeDefinitionBaseImpl)typeDefinition;
        if (typeDefBase == null) {
            return false;
        }
        if (typeDefBase.isUrType && typeDefBase.name.equals("anyType")) {
            return true;
        }
        if (this.isUrType && this.name.equals("anyType")) {
            return false;
        }
        if (this.isDerivationMethodExtension && disallowedExtension || this.isDerivationMethodRestriction && disallowedRestriction) {
            return false;
        }
        if (this == typeDefBase) {
            return true;
        }
        if (!this.baseTypeDefinition.isUrType) {
            return this.baseTypeDefinition.isDerivedFrom(typeDefinition, disallowedRestriction, disallowedExtension);
        }
        return false;
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        ComplexTypeDefinitionImpl result = (ComplexTypeDefinitionImpl)super.initializeBase(base, clonedCollector);
        result.isDerivationMethodExtension = this.isDerivationMethodExtension;
        result.isDerivationMethodRestriction = this.isDerivationMethodRestriction;
        result.isProhibitedSubstitutionExtension = this.isProhibitedSubstitutionExtension;
        result.isProhibitedSubstitutionRestriction = this.isProhibitedSubstitutionRestriction;
        result.isAbstract = this.isAbstract;
        if (this.attributeWildcard != null) {
            result.attributeWildcard = (WildcardImpl)this.attributeWildcard.clone(clonedCollector);
        }
        Tools.cloneVectorWithBases(this.attribUses, result.attribUses, clonedCollector);
        if (this.contentTypeSimpleTypeDefinition != null) {
            result.contentTypeSimpleTypeDefinition = (SimpleTypeDefinitionImpl)this.contentTypeSimpleTypeDefinition.clone(clonedCollector);
        }
        if (this.contentTypeContentModel != null) {
            result.contentTypeContentModel = (ParticleImpl)this.contentTypeContentModel.clone(clonedCollector);
        }
        result.isMixed = this.isMixed;
        Tools.cloneVectorWithBases(this.annotations, result.annotations, clonedCollector);
        return result;
    }
}

