/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ComplexTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.IdentityConstraintDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.InfoItemDeclarationBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.components.impl.structures.TypeDefinitionBaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ElementDeclarationImpl
extends InfoItemDeclarationBaseImpl
implements ElementDeclaration {
    protected boolean isNillable;
    protected ElementDeclarationImpl substitutionGroupAffiliation;
    protected boolean isAbstract;
    protected Vector identityConstrDefs = new Vector();
    protected Hashtable substitutableElemDeclrs = new Hashtable();
    protected boolean isSubstitutionGroupExclusionExtension;
    protected boolean isSubstitutionGroupExclusionRestriction;
    protected boolean isDisallowedSubstitutionSubstitution;
    protected boolean isDisallowedSubstitutionExtension;
    protected boolean isDisallowedSubstitutionRestriction;

    public ElementDeclarationImpl() {
        this(null, null, false);
    }

    public ElementDeclarationImpl(Node associatedNode, SchemaImpl schema, boolean isTopLevel) {
        super(associatedNode, schema, isTopLevel);
    }

    @Override
    public boolean isNillable() {
        return this.isNillable;
    }

    @Override
    public Vector getIdentityConstraintDefinitions() {
        return this.identityConstrDefs;
    }

    @Override
    public void getIdentityConstraintDefinitions(Vector collector) {
        Tools.removeFromVectorToVector(this.identityConstrDefs, collector);
    }

    @Override
    public IdentityConstraintDefinition[] getIdentityConstraintDefinitionsArray() {
        Object[] result = new IdentityConstraintDefinition[this.identityConstrDefs.size()];
        this.identityConstrDefs.copyInto(result);
        return result;
    }

    @Override
    public void getSubstitutableElementDeclarations(Vector collector) {
        Tools.removeFromHashtableToVector(this.substitutableElemDeclrs, collector);
    }

    @Override
    public ElementDeclaration[] getSubstitutableElementDeclarationsArray() {
        Vector substitutableElemDeclrsCollectorVector = new Vector();
        this.getSubstitutableElementDeclarations(substitutableElemDeclrsCollectorVector);
        Object[] result = new ElementDeclaration[substitutableElemDeclrsCollectorVector.size()];
        substitutableElemDeclrsCollectorVector.copyInto(result);
        return result;
    }

    @Override
    public ElementDeclaration getSubstitutableElementDeclaration(String targetNamespace, String name) {
        return (ElementDeclaration)this.substitutableElemDeclrs.get(Tools.generateKey(targetNamespace, name));
    }

    @Override
    public ElementDeclaration getSubstitutionGroupAffiliation() {
        return this.substitutionGroupAffiliation;
    }

    @Override
    public boolean isSubstitutionGroupExclusionExtension() {
        return this.isSubstitutionGroupExclusionExtension;
    }

    @Override
    public boolean isSubstitutionGroupExclusionRestriction() {
        return this.isSubstitutionGroupExclusionRestriction;
    }

    @Override
    public boolean isDisallowedSubstitutionSubstitution() {
        return this.isDisallowedSubstitutionSubstitution;
    }

    @Override
    public boolean isDisallowedSubstitutionExtension() {
        return this.isDisallowedSubstitutionExtension;
    }

    @Override
    public boolean isDisallowedSubstitutionRestriction() {
        return this.isDisallowedSubstitutionRestriction;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public int getTypeOfComponent() {
        return 3;
    }

    @Override
    public boolean match(Base elementDeclr) {
        if (!super.match(elementDeclr)) {
            return false;
        }
        ElementDeclarationImpl targetElemDeclr = (ElementDeclarationImpl)elementDeclr;
        return this.isNillable == targetElemDeclr.isNillable && this.isAbstract == targetElemDeclr.isAbstract && Tools.compareUnorderedBases(this.identityConstrDefs, targetElemDeclr.identityConstrDefs) && Tools.compareBases(this.substitutionGroupAffiliation, targetElemDeclr.substitutionGroupAffiliation) && this.isSubstitutionGroupExclusionExtension == targetElemDeclr.isSubstitutionGroupExclusionExtension && this.isSubstitutionGroupExclusionRestriction == targetElemDeclr.isSubstitutionGroupExclusionRestriction && this.isDisallowedSubstitutionSubstitution == targetElemDeclr.isDisallowedSubstitutionSubstitution && this.isDisallowedSubstitutionExtension == targetElemDeclr.isDisallowedSubstitutionExtension && this.isDisallowedSubstitutionRestriction == targetElemDeclr.isDisallowedSubstitutionRestriction;
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            String blockAttribValue;
            String abstractAttribValue;
            String typeDefAttribValue = this.loadAttribsCollector.getProperty("type");
            if (typeDefAttribValue != null) {
                this.typeDefinition = (TypeDefinitionBaseImpl)Tools.getTopLevelComponent(this.schema, this.associatedNode, typeDefAttribValue, "TD");
                SchemaStructuresLoader.loadBase(this.typeDefinition);
            }
            this.defaultValueConstr = this.loadAttribsCollector.getProperty("default");
            this.fixedValueConstr = this.loadAttribsCollector.getProperty("fixed");
            this.id = this.loadAttribsCollector.getProperty("id");
            String nillableAttribValue = this.loadAttribsCollector.getProperty("nillable");
            if (nillableAttribValue != null) {
                this.isNillable = nillableAttribValue.equals("true");
                if (this.isNillable && this.fixedValueConstr != null) {
                    throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Defintion of element declaration " + DOM.toXPath(this.associatedNode) + " is not correct. If the element is declared to be nillable, there must not be fixed {value constraint}.");
                }
            }
            if ((abstractAttribValue = this.loadAttribsCollector.getProperty("abstract")) != null) {
                this.isAbstract = abstractAttribValue.equals("true");
            }
            if ((blockAttribValue = this.loadAttribsCollector.getProperty("block")) != null) {
                if (blockAttribValue.equals("#all")) {
                    this.isDisallowedSubstitutionSubstitution = true;
                    this.isDisallowedSubstitutionExtension = true;
                    this.isDisallowedSubstitutionRestriction = true;
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(blockAttribValue);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("substitution")) {
                            this.isDisallowedSubstitutionSubstitution = true;
                            continue;
                        }
                        if (token.equals("extension")) {
                            this.isDisallowedSubstitutionExtension = true;
                            continue;
                        }
                        if (!token.equals("restriction")) continue;
                        this.isDisallowedSubstitutionRestriction = true;
                    }
                }
            } else {
                this.isDisallowedSubstitutionSubstitution = this.schema.isProhibitedSubstitution();
                this.isDisallowedSubstitutionRestriction = this.schema.isProhibitedRestriction();
                this.isDisallowedSubstitutionExtension = this.schema.isProhibitedExtension();
            }
            String finalAttribValue = this.loadAttribsCollector.getProperty("final");
            if (finalAttribValue != null) {
                if (finalAttribValue.equals("#all")) {
                    this.isSubstitutionGroupExclusionExtension = true;
                    this.isSubstitutionGroupExclusionRestriction = true;
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(finalAttribValue);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("extension")) {
                            this.isSubstitutionGroupExclusionExtension = true;
                            continue;
                        }
                        if (!token.equals("restriction")) continue;
                        this.isSubstitutionGroupExclusionRestriction = true;
                    }
                }
            } else {
                this.isSubstitutionGroupExclusionExtension = this.schema.isFinalExtension();
                this.isSubstitutionGroupExclusionRestriction = this.schema.isFinalRestriction();
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("simpleType")) {
                        if (this.typeDefinition != null) {
                            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of element declaration " + DOM.toXPath(this.associatedNode) + " is not correct. 'Type', <simpleType> and <complexType> are exclusive.");
                        }
                        this.typeDefinition = SchemaStructuresLoader.createSimpleTypeDefinition(node, this.schema, false, false);
                        SchemaStructuresLoader.loadBase(this.typeDefinition);
                    } else if (nodeLocalName.equals("complexType")) {
                        if (this.typeDefinition != null) {
                            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of element declaration " + DOM.toXPath(this.associatedNode) + " is not correct. 'Type', <simpleType> and <complexType> are exclusive.");
                        }
                        this.typeDefinition = SchemaStructuresLoader.createComplexTypeDefinition(node, this.schema, false, false);
                        SchemaStructuresLoader.loadBase(this.typeDefinition);
                    } else if (nodeLocalName.equals("key") || nodeLocalName.equals("keyref") || nodeLocalName.equals("unique")) {
                        IdentityConstraintDefinitionImpl identConstrDef = new IdentityConstraintDefinitionImpl(node, this.schema);
                        identConstrDef.owner = this;
                        this.identityConstrDefs.add(identConstrDef);
                        this.schema.addIdentityConstraintDefinition(identConstrDef);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresLoader.createAnnotation(node, this.schema);
                        SchemaStructuresLoader.loadBase(this.annotation);
                    }
                }
                ++i;
            }
            String substGroupAffilAttribValue = this.loadAttribsCollector.getProperty("substitutionGroup");
            if (substGroupAffilAttribValue != null) {
                this.substitutionGroupAffiliation = (ElementDeclarationImpl)Tools.getTopLevelComponent(this.schema, this.associatedNode, substGroupAffilAttribValue, "ED");
                SchemaStructuresLoader.loadBase(this.substitutionGroupAffiliation);
                if (this.typeDefinition != null) {
                    boolean disallowedRestriction = this.substitutionGroupAffiliation.isSubstitutionGroupExclusionRestriction;
                    boolean disallowedExtension = this.substitutionGroupAffiliation.isSubstitutionGroupExclusionExtension;
                    if (this.substitutionGroupAffiliation.typeDefinition instanceof ComplexTypeDefinitionImpl) {
                        disallowedRestriction = disallowedRestriction || ((ComplexTypeDefinitionImpl)this.substitutionGroupAffiliation.typeDefinition).isFinalRestriction;
                        boolean bl = disallowedExtension = disallowedExtension || ((ComplexTypeDefinitionImpl)this.substitutionGroupAffiliation.typeDefinition).isFinalExtension;
                    }
                    if (!this.typeDefinition.isDerivedFrom(this.substitutionGroupAffiliation.typeDefinition, disallowedRestriction, disallowedExtension)) {
                        throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Defintion of element declaration " + DOM.toXPath(this.associatedNode) + " is not correct. If there is an {substitution group affiliation}, the {type definition} of the element declaration must be validly derived from the {type definition} of the {substitution group affiliation}.");
                    }
                } else {
                    this.typeDefinition = this.substitutionGroupAffiliation.typeDefinition;
                }
                this.substitutionGroupAffiliation.substitutableElemDeclrs.put(this.getQualifiedKey(), this);
            }
            if (this.typeDefinition == null) {
                this.typeDefinition = (TypeDefinitionBaseImpl)this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anyType");
            }
            this.processValueConstraint();
            this.schema.addComponent(this);
        }
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        ElementDeclarationImpl result = (ElementDeclarationImpl)super.initializeBase(base, clonedCollector);
        result.isNillable = this.isNillable;
        if (this.substitutionGroupAffiliation != null) {
            result.substitutionGroupAffiliation = (ElementDeclarationImpl)this.substitutionGroupAffiliation.clone(clonedCollector);
        }
        result.isAbstract = this.isAbstract;
        Tools.cloneVectorWithBases(this.identityConstrDefs, result.identityConstrDefs, clonedCollector);
        Tools.cloneHashtableWithBases(this.substitutableElemDeclrs, result.substitutableElemDeclrs, clonedCollector);
        result.isSubstitutionGroupExclusionExtension = this.isSubstitutionGroupExclusionExtension;
        result.isSubstitutionGroupExclusionRestriction = this.isSubstitutionGroupExclusionRestriction;
        result.isDisallowedSubstitutionSubstitution = this.isDisallowedSubstitutionSubstitution;
        result.isDisallowedSubstitutionExtension = this.isDisallowedSubstitutionExtension;
        result.isDisallowedSubstitutionRestriction = this.isDisallowedSubstitutionRestriction;
        return result;
    }
}

