/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Facet;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.validator.regexp.RegularExpression;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Node;

public final class FacetImpl
extends BaseImpl
implements Facet {
    protected String facetName;
    protected String valueString;
    protected boolean isFixed;
    private RegularExpression regularExpression;

    public FacetImpl(String facetName, String valueString) {
        super(null, null);
        this.facetName = facetName;
        this.valueString = valueString;
    }

    public FacetImpl(Node associatedNode, SchemaImpl schema) {
        super(associatedNode, schema);
    }

    @Override
    public int getTypeOfComponent() {
        return 11;
    }

    @Override
    public String getName() {
        return this.facetName;
    }

    @Override
    public String getValue() {
        return this.valueString;
    }

    @Override
    public boolean isFixed() {
        return this.isFixed;
    }

    @Override
    public RegularExpression getRegularExpression() {
        return this.regularExpression;
    }

    @Override
    public boolean match(Facet facet) {
        FacetImpl targetFacet = (FacetImpl)facet;
        return this.facetName.equals(targetFacet.facetName) && this.valueString.equals(targetFacet.valueString) && this.isFixed == targetFacet.isFixed;
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.facetName = this.associatedNode.getLocalName();
            String value = this.loadAttribsCollector.getProperty("fixed");
            if (value != null) {
                this.isFixed = value.equals("true");
            }
            this.valueString = this.loadAttribsCollector.getProperty("value");
            if ((this.facetName.equals("length") || this.facetName.equals("minLength") || this.facetName.equals("maxLength") || this.facetName.equals("fractionDigits")) && !this.isValueNonNeagtiveInteger()) {
                throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of facet " + DOM.toXPath(this.associatedNode) + " is not correct. Number format error occured or the value is not a non negative integer.");
            }
            if (this.facetName.equals("totalDigits") && !this.isValuePositiveInteger()) {
                throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of facet " + DOM.toXPath(this.associatedNode) + " is not correct. Number format error occured or the value is not a positive integer.");
            }
            if (this.facetName.equals("pattern") && this.schema.getLoader().getLoadPatternRegularExpressions()) {
                try {
                    this.regularExpression = new RegularExpression(this.valueString);
                }
                catch (Exception exc) {
                    throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of facet " + DOM.toXPath(this.associatedNode) + " is not correct.", exc);
                }
            }
        }
    }

    private boolean isValueNonNeagtiveInteger() {
        int intValue = -1;
        try {
            intValue = Integer.parseInt(this.valueString);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return intValue >= 0;
    }

    private boolean isValuePositiveInteger() {
        int intValue = -1;
        try {
            intValue = Integer.parseInt(this.valueString);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return intValue > 0;
    }

    public String toString() {
        return String.valueOf(this.facetName) + " : " + this.valueString;
    }

    @Override
    public BaseImpl clone(Hashtable clonedCollector) {
        return this;
    }
}

