/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.LexicalParser;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class IdentityConstraintDefinitionImpl
extends QualifiedBaseImpl
implements IdentityConstraintDefinition {
    public static final int KEY = 1;
    public static final int KEYREF = 2;
    public static final int UNIQUE = 3;
    protected int category;
    protected String selector;
    protected Vector fields = new Vector();
    protected IdentityConstraintDefinitionImpl referencedKey;
    protected ElementDeclaration owner;

    public IdentityConstraintDefinitionImpl() {
        this(null, null);
    }

    public IdentityConstraintDefinitionImpl(Node associatedNode, SchemaImpl schema) {
        super(associatedNode, schema, true);
    }

    @Override
    public boolean isIdentityConstraintCategoryKey() {
        return this.category == 1;
    }

    @Override
    public boolean isIdentityConstraintCategoryKeyref() {
        return this.category == 2;
    }

    @Override
    public boolean isIdentityConstraintCategoryUnique() {
        return this.category == 3;
    }

    @Override
    public String getSelector() {
        return this.selector;
    }

    @Override
    public Vector getFields() {
        return this.fields;
    }

    @Override
    public void getFields(Vector collector) {
        Tools.removeFromVectorToVector(this.fields, collector);
    }

    @Override
    public IdentityConstraintDefinition getReferencedKey() {
        return this.referencedKey;
    }

    @Override
    public int getTypeOfComponent() {
        return 13;
    }

    @Override
    public ElementDeclaration getOwner() {
        return this.owner;
    }

    @Override
    public boolean match(Base identityConstrDef) {
        Hashtable srcPrefixesMapping;
        if (!super.match(identityConstrDef)) {
            return false;
        }
        IdentityConstraintDefinitionImpl targetIdentConstrDef = (IdentityConstraintDefinitionImpl)identityConstrDef;
        if (this.category != targetIdentConstrDef.category) {
            return false;
        }
        Hashtable dstPrefixesMapping = DOM.getNamespaceMappingsInScope(this.associatedNode);
        if (!this.equalXPaths(this.selector, dstPrefixesMapping, targetIdentConstrDef.selector, srcPrefixesMapping = DOM.getNamespaceMappingsInScope(targetIdentConstrDef.associatedNode))) {
            return false;
        }
        if (this.fields.size() != targetIdentConstrDef.fields.size()) {
            return false;
        }
        int i = 0;
        while (i < this.fields.size()) {
            if (!this.equalXPaths((String)this.fields.get(i), dstPrefixesMapping, (String)targetIdentConstrDef.fields.get(i), srcPrefixesMapping)) {
                return false;
            }
            ++i;
        }
        return Tools.compareBases(this.referencedKey, targetIdentConstrDef.referencedKey);
    }

    /*
     * Unable to fully structure code
     */
    private boolean equalXPaths(String dstXPath, Hashtable dstPrefixesMapping, String srcXPath, Hashtable srcPrefixesMapping) {
        dstTokenizer = new StringTokenizer(dstXPath, "/");
        srcTokenizer = new StringTokenizer(srcXPath, "/");
        if (dstTokenizer.countTokens() == srcTokenizer.countTokens()) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            dstStep = dstTokenizer.nextToken();
            dstIsAttribute = dstStep.startsWith("@") != false || dstStep.startsWith("attribute:") != false;
            dstUriAndName = Tools.parseQName(dstStep, dstPrefixesMapping);
            srcStep = srcTokenizer.nextToken();
            srcIsAttribute = srcStep.startsWith("@") != false || srcStep.startsWith("attribute:") != false;
            srcUriAndName = Tools.parseQName(srcStep, srcPrefixesMapping);
            if (!(dstIsAttribute ^ srcIsAttribute) && Tools.compareObjects(dstUriAndName[0], srcUriAndName[0]) && dstUriAndName[1].equals(srcUriAndName[1])) continue;
            return false;
lbl13:
            // 2 sources

            ** while (dstTokenizer.hasMoreTokens())
        }
lbl14:
        // 1 sources

        return true;
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            String localName = this.associatedNode.getLocalName();
            if (localName.equals("unique")) {
                this.category = 3;
            } else if (localName.equals("key")) {
                this.category = 1;
            } else if (localName.equals("keyref")) {
                this.category = 2;
                String qName = this.loadAttribsCollector.getProperty("refer");
                this.referencedKey = (IdentityConstraintDefinitionImpl)Tools.getTopLevelComponent(this.schema, this.associatedNode, qName, "ICD");
                SchemaStructuresLoader.loadBase(this.referencedKey);
                if (this.referencedKey.isIdentityConstraintCategoryKeyref()) {
                    throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of qualified base " + DOM.toXPath(this.associatedNode) + " is not correct. A keyref identity constraint definition should refer to a key or unique identity constraint definition.");
                }
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("selector")) {
                        this.selector = ((Element)node).getAttribute("xpath");
                        if (!LexicalParser.parseXPathSelector(this.selector)) {
                            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : XPath expression " + this.selector + " is not supported.");
                        }
                    } else if (nodeLocalName.equals("field")) {
                        String field = ((Element)node).getAttribute("xpath");
                        if (!LexicalParser.parseXPathField(field)) {
                            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : XPath expression '" + field + "' is not supported.");
                        }
                        this.fields.add(field);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresLoader.createAnnotation(node, this.schema);
                        SchemaStructuresLoader.loadBase(this.annotation);
                    }
                }
                ++i;
            }
        }
        if (this.category == 2 && this.fields.size() != this.referencedKey.fields.size()) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of qualified base " + DOM.toXPath(this.associatedNode) + " is not correct. The count of the specified fields should be equal to the count of the refered identity constraint definition fileds.");
        }
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        IdentityConstraintDefinitionImpl result = (IdentityConstraintDefinitionImpl)super.initializeBase(base, clonedCollector);
        if (result.category == 1) {
            clonedCollector.put(this, result);
        }
        result.category = this.category;
        result.selector = this.selector;
        result.fields = this.fields;
        if (this.referencedKey != null) {
            result.referencedKey = (IdentityConstraintDefinitionImpl)this.referencedKey.clone(clonedCollector);
        }
        return result;
    }
}

