/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.FundamentalFacets;
import com.sap.engine.lib.schema.components.InfoItemDeclarationBase;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.impl.ffacets.Value;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ComplexTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.TypeDefinitionBaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.SimpleTypeValidator;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class InfoItemDeclarationBaseImpl
extends QualifiedBaseImpl
implements InfoItemDeclarationBase {
    protected TypeDefinitionBaseImpl typeDefinition;
    protected ComplexTypeDefinitionImpl scope;
    protected String defaultValueConstr;
    protected String fixedValueConstr;

    public InfoItemDeclarationBaseImpl() {
        this(null, null, false);
    }

    public InfoItemDeclarationBaseImpl(Node associatedNode, SchemaImpl schema, boolean isTopLevel) {
        super(associatedNode, schema, isTopLevel);
        if (!isTopLevel) {
            String form = this.loadAttribsCollector.getProperty("form");
            this.isQualified = form != null ? form.equals("qualified") : (this.getTypeOfComponent() == 3 ? schema.isElemsFormDefaultQualified() : (this.getTypeOfComponent() == 4 ? schema.isAttribsFormDefaultQualified() : false));
        }
    }

    @Override
    public final TypeDefinitionBase getTypeDefinition() {
        return this.typeDefinition;
    }

    @Override
    public final ComplexTypeDefinition getScope() {
        return this.scope;
    }

    @Override
    public final String getValueConstraintDefault() {
        return this.defaultValueConstr;
    }

    @Override
    public final String getValueConstraintFixed() {
        return this.fixedValueConstr;
    }

    @Override
    public boolean match(Base infoItemDeclarationBase) {
        if (!super.match(infoItemDeclarationBase)) {
            return false;
        }
        InfoItemDeclarationBaseImpl targetInfoItemDeclrBase = (InfoItemDeclarationBaseImpl)infoItemDeclarationBase;
        return Tools.compareBases(this.typeDefinition, targetInfoItemDeclrBase.typeDefinition) && Tools.compareObjects(this.defaultValueConstr, targetInfoItemDeclrBase.defaultValueConstr) && Tools.compareObjects(this.fixedValueConstr, targetInfoItemDeclrBase.fixedValueConstr);
    }

    protected void processValueConstraint() throws SchemaComponentException {
        SimpleTypeDefinition simpleTypeDef;
        if (this.defaultValueConstr != null && this.fixedValueConstr != null) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of info item declaration base " + DOM.toXPath(this.associatedNode) + " is not correct. 'Default' and 'fixed' must not both be present.");
        }
        if (this.typeDefinition.isDerivedFrom(this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "ID"), false, false) && (this.defaultValueConstr != null || this.fixedValueConstr != null)) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of info item declaration base '" + DOM.toXPath(this.associatedNode) + "' is not correct. If the {type definition} is or is derived from ID then there must not be a {value constraint}.");
        }
        SimpleTypeDefinition simpleTypeDefinition = simpleTypeDef = this.typeDefinition instanceof SimpleTypeDefinition ? (SimpleTypeDefinition)((Object)this.typeDefinition) : ((ComplexTypeDefinition)((Object)this.typeDefinition)).getContentTypeSimpleTypeDefinition();
        if (simpleTypeDef != null) {
            FundamentalFacets fFacets = simpleTypeDef.getFundamentalFacets();
            String valueConstr = null;
            Value fFactesConstrValue = null;
            if (this.fixedValueConstr != null) {
                valueConstr = this.fixedValueConstr;
                if (fFacets != null) {
                    fFactesConstrValue = fFacets.parse(this.fixedValueConstr);
                }
            } else if (this.defaultValueConstr != null) {
                valueConstr = this.defaultValueConstr;
                if (fFacets != null) {
                    fFactesConstrValue = fFacets.parse(this.defaultValueConstr);
                }
            }
            try {
                if (valueConstr != null && !SimpleTypeValidator.validateSimpleTypeDefinition(simpleTypeDef, null, fFactesConstrValue, valueConstr, null, null)) {
                    throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of info item declaration base " + DOM.toXPath(this.associatedNode) + " is not correct. If {value constraint} is present, it's value must be valid with respect to the corresponding simple content.");
                }
            }
            catch (SAXException sAXException) {}
        }
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        InfoItemDeclarationBaseImpl result = (InfoItemDeclarationBaseImpl)super.initializeBase(base, clonedCollector);
        result.typeDefinition = this.typeDefinition.isBuiltIn ? this.typeDefinition : (TypeDefinitionBaseImpl)this.typeDefinition.clone(clonedCollector);
        result.defaultValueConstr = this.defaultValueConstr;
        result.fixedValueConstr = this.fixedValueConstr;
        return result;
    }
}

