/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ModelGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.ParticleImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ModelGroupImpl
extends BaseImpl
implements ModelGroup {
    protected static final int ALL = 1;
    protected static final int CHOICE = 2;
    protected static final int SEQUENCE = 3;
    protected int compositor;
    protected Vector particles = new Vector();
    protected int minimumEffectiveTotalRange;
    protected int maximumEffectiveTotalRange;
    protected boolean unboundedMaximumEffectiveTotalRange;
    private int productOfParticleMinOccurs = 1;
    private int sumOfMinimumEffectiveTotalRanges = 0;
    private int minimumOfMinimumEffectiveTotalRanges = -1;
    private int productOfParticleMaxOccurs = 1;
    private int sumOfMaximumEffectiveTotalRanges = 0;
    private int maximumOfMaximumEffectiveTotalRanges = -1;

    @Override
    public boolean isUnboundedMaximumEffectiveTotalRange() {
        return this.unboundedMaximumEffectiveTotalRange;
    }

    @Override
    public int getMinimumEffectiveTotalRange() {
        return this.minimumEffectiveTotalRange;
    }

    @Override
    public int getMaximumEffectiveTotalRange() {
        return this.maximumEffectiveTotalRange;
    }

    public ModelGroupImpl() {
        this(null);
    }

    public ModelGroupImpl(SchemaImpl schema) {
        this(null, schema);
    }

    public ModelGroupImpl(Node associatedNode, SchemaImpl schema) {
        super(associatedNode, schema);
    }

    @Override
    public boolean isCompositorAll() {
        return this.compositor == 1;
    }

    @Override
    public boolean isCompositorChoice() {
        return this.compositor == 2;
    }

    @Override
    public boolean isCompositorSequence() {
        return this.compositor == 3;
    }

    @Override
    public Vector getParticles() {
        return this.particles;
    }

    @Override
    public void getParticles(Vector collector) {
        Tools.removeFromVectorToVector(this.particles, collector);
    }

    @Override
    public Particle[] getParticlesArray() {
        Object[] result = new Particle[this.particles.size()];
        this.particles.copyInto(result);
        return result;
    }

    @Override
    public int getTypeOfComponent() {
        return 7;
    }

    @Override
    public boolean match(Base modelGroup) {
        if (!super.match(modelGroup)) {
            return false;
        }
        ModelGroupImpl targetModelGroup = (ModelGroupImpl)modelGroup;
        if (this.compositor != targetModelGroup.compositor) {
            return false;
        }
        if (this.compositor == 3) {
            return Tools.compareOrderedBases(this.particles, targetModelGroup.particles);
        }
        return Tools.compareUnorderedBases(this.particles, targetModelGroup.particles);
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            String associatedNodeLocalName = this.associatedNode.getLocalName();
            if (associatedNodeLocalName.equals("all")) {
                this.compositor = 1;
            } else if (associatedNodeLocalName.equals("choice")) {
                this.compositor = 2;
            } else if (associatedNodeLocalName.equals("sequence")) {
                this.compositor = 3;
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("element") || nodeLocalName.equals("choice") || nodeLocalName.equals("sequence") || nodeLocalName.equals("group") || nodeLocalName.equals("any")) {
                        ParticleImpl particle = SchemaStructuresLoader.createParticle(node, this.schema);
                        SchemaStructuresLoader.loadBase(particle);
                        this.addParticle(particle);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresLoader.createAnnotation(node, this.schema);
                        SchemaStructuresLoader.loadBase(this.annotation);
                    }
                }
                ++i;
            }
            this.calculateEffectiveTotalRange();
        }
    }

    protected void calculateEffectiveTotalRange() {
        if (this.compositor == 2) {
            this.calculateEffectiveTotalRange_Choice();
        } else {
            this.calculateEffectiveTotalRange_SequenceAndAll();
        }
    }

    private void calculateEffectiveTotalRange_Choice() {
        this.minimumEffectiveTotalRange = this.productOfParticleMinOccurs * this.minimumOfMinimumEffectiveTotalRanges;
        if (!this.unboundedMaximumEffectiveTotalRange) {
            this.maximumEffectiveTotalRange = this.productOfParticleMaxOccurs * this.maximumOfMaximumEffectiveTotalRanges;
        }
    }

    private void calculateEffectiveTotalRange_SequenceAndAll() {
        this.minimumEffectiveTotalRange = this.productOfParticleMinOccurs * this.sumOfMinimumEffectiveTotalRanges;
        if (!this.unboundedMaximumEffectiveTotalRange) {
            this.maximumEffectiveTotalRange = this.productOfParticleMaxOccurs * this.sumOfMaximumEffectiveTotalRanges;
        }
    }

    protected void addParticle(ParticleImpl particle) {
        this.particles.add(particle);
        if (this.compositor == 2) {
            this.calculateComponentsForEffectiveTotalRange_Choice(particle);
        } else {
            this.calculateComponentsForEffectiveTotalRange_SequenceAndAll(particle);
        }
    }

    private void calculateComponentsForEffectiveTotalRange_Choice(ParticleImpl particle) {
        this.calculateComponentsForMinimumEffectiveTotalRange_Choice(particle);
        this.calculateComponentsForMaximumEffectiveTotalRange_Choice(particle);
    }

    private void calculateComponentsForEffectiveTotalRange_SequenceAndAll(ParticleImpl particle) {
        this.calculateComponentsForMinimumEffectiveTotalRange_SequenceAndAll(particle);
        this.calculateComponentsForMaximumEffectiveTotalRange_SequenceAndAll(particle);
    }

    private void calculateComponentsForMinimumEffectiveTotalRange_Choice(ParticleImpl particle) {
        this.productOfParticleMinOccurs *= particle.minOccurs;
        int minEffectiveTotalRange = this.determineMinEffectiveTotalRange(particle);
        if (this.minimumOfMinimumEffectiveTotalRanges > minEffectiveTotalRange) {
            this.minimumOfMinimumEffectiveTotalRanges = minEffectiveTotalRange;
        }
    }

    private int determineMinEffectiveTotalRange(ParticleImpl particle) {
        if (particle.term instanceof ModelGroupDefinitionImpl) {
            return ((ModelGroupDefinitionImpl)particle.term).modelGroup.getMinimumEffectiveTotalRange();
        }
        if (particle.term instanceof ModelGroupImpl) {
            return ((ModelGroupImpl)particle.term).getMinimumEffectiveTotalRange();
        }
        return particle.minOccurs;
    }

    private int determineMaxEffectiveTotalRange(ParticleImpl particle) {
        if (particle.term instanceof ModelGroupDefinitionImpl) {
            return ((ModelGroupDefinitionImpl)particle.term).modelGroup.getMaximumEffectiveTotalRange();
        }
        if (particle.term instanceof ModelGroupImpl) {
            return ((ModelGroupImpl)particle.term).getMaximumEffectiveTotalRange();
        }
        return particle.maxOccurs;
    }

    private boolean isUnboundedMaximumEffectiveTotalRange(ParticleImpl particle) {
        if (particle.term instanceof ModelGroupDefinitionImpl) {
            return ((ModelGroupDefinitionImpl)particle.term).modelGroup.isUnboundedMaximumEffectiveTotalRange();
        }
        if (particle.term instanceof ModelGroupImpl) {
            return ((ModelGroupImpl)particle.term).isUnboundedMaximumEffectiveTotalRange();
        }
        return particle.isMaxOccursUnbounded();
    }

    private void calculateComponentsForMaximumEffectiveTotalRange_Choice(ParticleImpl particle) {
        if (this.isUnboundedMaximumEffectiveTotalRange(particle)) {
            this.unboundedMaximumEffectiveTotalRange = true;
        }
        if (!this.unboundedMaximumEffectiveTotalRange) {
            this.productOfParticleMaxOccurs *= particle.maxOccurs;
            int maxEffectiveTotalRange = this.determineMaxEffectiveTotalRange(particle);
            if (this.maximumOfMaximumEffectiveTotalRanges < maxEffectiveTotalRange) {
                this.maximumOfMaximumEffectiveTotalRanges = maxEffectiveTotalRange;
            }
        }
    }

    private void calculateComponentsForMinimumEffectiveTotalRange_SequenceAndAll(ParticleImpl particle) {
        this.productOfParticleMinOccurs *= particle.minOccurs;
        this.sumOfMinimumEffectiveTotalRanges += this.determineMinEffectiveTotalRange(particle);
    }

    private void calculateComponentsForMaximumEffectiveTotalRange_SequenceAndAll(ParticleImpl particle) {
        if (this.isUnboundedMaximumEffectiveTotalRange(particle)) {
            this.unboundedMaximumEffectiveTotalRange = true;
        }
        if (!this.unboundedMaximumEffectiveTotalRange) {
            this.productOfParticleMaxOccurs *= particle.maxOccurs;
            this.sumOfMaximumEffectiveTotalRanges += this.determineMaxEffectiveTotalRange(particle);
        }
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        ModelGroupImpl result = (ModelGroupImpl)super.initializeBase(base, clonedCollector);
        result.compositor = this.compositor;
        result.minimumEffectiveTotalRange = this.minimumEffectiveTotalRange;
        result.maximumEffectiveTotalRange = this.maximumEffectiveTotalRange;
        result.unboundedMaximumEffectiveTotalRange = this.unboundedMaximumEffectiveTotalRange;
        Tools.cloneVectorWithBases(this.particles, result.particles, clonedCollector);
        return result;
    }
}

