/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.NotationDeclaration;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class NotationDeclarationImpl
extends QualifiedBaseImpl
implements NotationDeclaration {
    protected String systemIdentifier;
    protected String publicIdentifier;

    public NotationDeclarationImpl() {
        this(null, null);
    }

    public NotationDeclarationImpl(Node associatedNode, SchemaImpl schema) {
        super(associatedNode, schema, true);
    }

    @Override
    public String getSystemIdentifier() {
        return this.systemIdentifier;
    }

    @Override
    public String getPublicIdentifier() {
        return this.publicIdentifier;
    }

    @Override
    public int getTypeOfComponent() {
        return 14;
    }

    @Override
    public boolean match(Base notationDeclr) {
        if (!super.match(notationDeclr)) {
            return false;
        }
        NotationDeclarationImpl targetNotaionDeclr = (NotationDeclarationImpl)notationDeclr;
        return Tools.compareObjects(this.systemIdentifier, targetNotaionDeclr.systemIdentifier) && Tools.compareObjects(this.publicIdentifier, targetNotaionDeclr.publicIdentifier);
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            this.publicIdentifier = this.loadAttribsCollector.getProperty("public");
            this.systemIdentifier = this.loadAttribsCollector.getProperty("system");
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeLocalName;
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema") && (nodeLocalName = node.getLocalName()).equals("annotation")) {
                    this.annotation = SchemaStructuresLoader.createAnnotation(node, this.schema);
                    SchemaStructuresLoader.loadBase(this.annotation);
                }
                ++i;
            }
        }
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        NotationDeclarationImpl result = (NotationDeclarationImpl)super.initializeBase(base, clonedCollector);
        result.systemIdentifier = this.systemIdentifier;
        result.publicIdentifier = this.publicIdentifier;
        return result;
    }
}

