/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ModelGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Node;

public final class ParticleImpl
extends BaseImpl
implements Particle {
    protected int minOccurs;
    protected int maxOccurs;
    protected BaseImpl term;
    protected boolean isEmptiable;

    public ParticleImpl() {
        this(null);
    }

    public ParticleImpl(SchemaImpl schema) {
        this(null, schema);
    }

    public ParticleImpl(Node associatedNode, SchemaImpl schema) {
        super(associatedNode, schema);
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public boolean isMaxOccursUnbounded() {
        return this.maxOccurs == Integer.MAX_VALUE;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public Base getTerm() {
        return this.term;
    }

    @Override
    public int getTypeOfComponent() {
        return 9;
    }

    @Override
    public boolean match(Base particle) {
        if (!super.match(particle)) {
            return false;
        }
        ParticleImpl targetParticle = (ParticleImpl)particle;
        return this.minOccurs == targetParticle.minOccurs && this.maxOccurs == targetParticle.maxOccurs && this.term.match(targetParticle.term);
    }

    @Override
    public boolean isEmptiable() {
        return this.isEmptiable;
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            String minOccursAttribValue;
            this.id = this.loadAttribsCollector.getProperty("id");
            String maxOccursAttribValue = this.loadAttribsCollector.getProperty("maxOccurs");
            if (maxOccursAttribValue != null) {
                int n = this.maxOccurs = maxOccursAttribValue.equals("unbounded") ? Integer.MAX_VALUE : this.processNumber(maxOccursAttribValue);
                if (this.maxOccurs < 0) {
                    throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of particle " + DOM.toXPath(this.associatedNode) + " is not correct. {max occurs} must be greater than or equal to 0.");
                }
            } else {
                this.maxOccurs = 1;
            }
            if ((minOccursAttribValue = this.loadAttribsCollector.getProperty("minOccurs")) != null) {
                this.minOccurs = this.processNumber(minOccursAttribValue);
                if (this.minOccurs < 0) {
                    throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of particle " + DOM.toXPath(this.associatedNode) + " is not correct. {min occurs} must have a non negative value.");
                }
            } else {
                this.minOccurs = 1;
            }
            if (this.minOccurs > this.maxOccurs) {
                throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of particle " + DOM.toXPath(this.associatedNode) + " is not correct. {min occurs} must not be greater than {max occurs}.");
            }
            String localName = this.associatedNode.getLocalName();
            if (localName.equals("element")) {
                this.term = SchemaStructuresLoader.createElementDeclaration(this.associatedNode, this.schema, false);
            } else if (localName.equals("any") || localName.equals("anyAttribute")) {
                this.term = SchemaStructuresLoader.createWildcard(this.associatedNode, this.schema);
            } else if (localName.equals("all") || localName.equals("sequence") || localName.equals("choice")) {
                this.term = SchemaStructuresLoader.createModelGroup(this.associatedNode, this.schema);
            } else if (localName.equals("group")) {
                this.term = SchemaStructuresLoader.createModelGroupDefinition(this.associatedNode, this.schema, false, false);
            }
            SchemaStructuresLoader.loadBase(this.term);
            this.loadIsEmptiable();
        }
    }

    private void loadIsEmptiable() {
        this.isEmptiable = this.minOccurs == 0 || this.term instanceof ModelGroup && ((ModelGroup)((Object)this.term)).getMinimumEffectiveTotalRange() == 0 || this.term instanceof ModelGroupDefinitionImpl && ((ModelGroupDefinitionImpl)this.term).getModelGroup().getMinimumEffectiveTotalRange() == 0;
    }

    private int processNumber(String value) throws SchemaComponentException {
        int result = -1;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormExc) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of particle " + DOM.toXPath(this.associatedNode) + " is not correct.A number format error occurs while processing {minOccurs} or {maxOccurs} value.", numberFormExc);
        }
        return result;
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        ParticleImpl result = (ParticleImpl)super.initializeBase(base, clonedCollector);
        result.minOccurs = this.minOccurs;
        result.maxOccurs = this.maxOccurs;
        result.isEmptiable = this.isEmptiable;
        result.term = this.term.clone(clonedCollector);
        return result;
    }
}

