/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.QualifiedBase;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.exception.SchemaRuntimeException;
import com.sap.engine.lib.schema.util.LexicalParser;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Node;

public abstract class QualifiedBaseImpl
extends BaseImpl
implements QualifiedBase {
    protected String name;
    protected boolean isTopLevel;
    protected boolean isQualified;

    public QualifiedBaseImpl() {
        this(null, null, false);
    }

    public QualifiedBaseImpl(boolean isTopLevel) {
        this(null, null, isTopLevel);
    }

    public QualifiedBaseImpl(Node associatedNode, SchemaImpl schema, boolean isTopLevel) {
        super(associatedNode, schema);
        this.isTopLevel = isTopLevel;
        this.isQualified = true;
        if (schema != null) {
            this.name = this.loadAttribsCollector.getProperty("name");
            if (this.name == null) {
                if (isTopLevel) {
                    throw new SchemaRuntimeException("[location : '" + schema.getLocation() + "'] ERROR : Definition of qualified base " + DOM.toXPath(associatedNode) + " is not correct. The value of {name} property must not be absent.");
                }
                this.name = "";
            } else if (LexicalParser.parseNCName(this.name) == null) {
                throw new SchemaRuntimeException("The {name} property is {" + this.name + "} which is not a valid NCName. [location : '" + schema.getLocation() + "'] ERROR : Definition of qualified base " + DOM.toXPath(associatedNode) + " is not correct.");
            }
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTargetNamespace() {
        return this.isQualified ? this.schema.getTargetNamespace() : "";
    }

    @Override
    public boolean isAnonymous() {
        return this.name.equals("");
    }

    @Override
    public boolean match(Base qualifiedBase) {
        if (!super.match(qualifiedBase)) {
            return false;
        }
        QualifiedBaseImpl targetQualifiedBase = (QualifiedBaseImpl)qualifiedBase;
        return Tools.compareObjects(this.name, targetQualifiedBase.name) && this.getTargetNamespace().equals(targetQualifiedBase.getTargetNamespace());
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        QualifiedBaseImpl result = (QualifiedBaseImpl)super.initializeBase(base, clonedCollector);
        result.name = this.name;
        result.isTopLevel = this.isTopLevel;
        result.isQualified = this.isQualified;
        return result;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public String getQualifiedKey() {
        return Tools.generateKey(this.getTargetNamespace(), this.name);
    }

    public String toString() {
        return "{type : " + this.getNameOfComponent() + "; uri : " + this.getTargetNamespace() + "; name : " + this.name + "}";
    }
}

