/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.AttributeGroupDefinition;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.ModelGroupDefinition;
import com.sap.engine.lib.schema.components.NotationDeclaration;
import com.sap.engine.lib.schema.components.QualifiedBase;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.impl.LoaderImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.BuiltInTypesCollector;
import com.sap.engine.lib.schema.components.impl.structures.ComplexTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.ElementDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.IdentityConstraintDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.ModelGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.NotationDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.RedefineableQualifiedBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.components.impl.structures.SimpleTypeDefinitionImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SchemaImpl
extends BaseImpl
implements Schema {
    protected static BuiltInTypesCollector builtInTypesCollector;
    private Vector allComponentsCollector;
    private LoaderImpl loader;
    private boolean elemsFormDefaultIsQualified;
    private boolean attribsFormDefaultIsQualified;
    private String targetNamespace;
    private boolean isFinalExtension;
    private boolean isFinalRestriction;
    private boolean isProhibitedSubstitution;
    private boolean isProhibitedExtension;
    private boolean isProhibitedRestriction;
    private boolean isProhibitedList;
    private boolean isProhibitedUnion;
    private String location;
    private Hashtable idToTopLevelComponentsMapping;
    private Vector importedSchemasCollector;
    private Vector includedSchemasCollector;
    private Element schemaElement;
    private Vector importedNamespacesCollector;
    private String includingNamespace;
    private Vector allComplexTypeDefinitions;

    static {
        if (builtInTypesCollector == null) {
            builtInTypesCollector = new BuiltInTypesCollector();
        }
    }

    public SchemaImpl(SchemaImpl[] schemas) {
        this(new SchemaImpl[][]{schemas});
    }

    public SchemaImpl(SchemaImpl[][] schemas) {
        this.init();
        int i = 0;
        while (i < schemas.length) {
            this.augmentWithReferenceableSchemas(schemas[i]);
            ++i;
        }
    }

    public SchemaImpl(Element schemaElement, LoaderImpl loader, String location, String includingNamespace) throws SchemaComponentException {
        this.init();
        this.loader = loader;
        this.location = location;
        this.schemaElement = schemaElement;
        this.includingNamespace = includingNamespace;
        this.initSchemaInfo();
    }

    public void augmentWithReferenceableSchemas(SchemaImpl[] schemas) {
        int i = 0;
        while (i < schemas.length) {
            this.augmentWithReferenceableSchema(schemas[i]);
            ++i;
        }
    }

    public void augmentWithReferenceableSchema(SchemaImpl schema) {
        try {
            if (schema != this) {
                if (schema.getTargetNamespace().equals(this.targetNamespace)) {
                    this.includeSchema(schema, false);
                } else {
                    this.importSchema(schema.getTargetNamespace(), schema);
                }
            }
        }
        catch (SchemaComponentException schemaComponentException) {}
    }

    private void init() {
        this.initIdToNSQBasesStorageMapping();
        this.allComponentsCollector = new Vector();
        this.importedSchemasCollector = new Vector();
        this.includedSchemasCollector = new Vector();
        this.importedNamespacesCollector = new Vector();
        this.allComplexTypeDefinitions = new Vector();
        this.targetNamespace = "";
        this.isLoaded = false;
    }

    private void initIdToNSQBasesStorageMapping() {
        this.idToTopLevelComponentsMapping = new Hashtable();
        this.idToTopLevelComponentsMapping.put("TD", new Hashtable());
        this.idToTopLevelComponentsMapping.put("ED", new Hashtable());
        this.idToTopLevelComponentsMapping.put("AD", new Hashtable());
        this.idToTopLevelComponentsMapping.put("AGD", new Hashtable());
        this.idToTopLevelComponentsMapping.put("MGD", new Hashtable());
        this.idToTopLevelComponentsMapping.put("ICD", new Hashtable());
        this.idToTopLevelComponentsMapping.put("ND", new Hashtable());
    }

    private void initSchemaInfo() throws SchemaComponentException {
        NamedNodeMap namedNodeMap = this.schemaElement.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attrib = namedNodeMap.item(i);
            String attribUri = attrib.getNamespaceURI();
            String localName = attrib.getLocalName();
            String attribValue = attrib.getNodeValue();
            if (attribUri == null || attribUri.equals("")) {
                StringTokenizer tokenizer;
                if (localName.equals("attributeFormDefault")) {
                    this.attribsFormDefaultIsQualified = attribValue.equals("qualified");
                } else if (localName.equals("elementFormDefault")) {
                    this.elemsFormDefaultIsQualified = attribValue.equals("qualified");
                } else if (localName.equals("targetNamespace")) {
                    this.targetNamespace = attribValue == null ? "" : attribValue;
                } else if (localName.equals("blockDefault")) {
                    if (attribValue.equals("#all")) {
                        this.isProhibitedSubstitution = true;
                        this.isProhibitedExtension = true;
                        this.isProhibitedRestriction = true;
                        this.isProhibitedList = true;
                        this.isProhibitedUnion = true;
                    } else {
                        tokenizer = new StringTokenizer(attribValue);
                        while (tokenizer.hasMoreTokens()) {
                            attribValue = tokenizer.nextToken();
                            if (attribValue.equals("substitution")) {
                                this.isProhibitedSubstitution = true;
                                continue;
                            }
                            if (attribValue.equals("extension")) {
                                this.isProhibitedExtension = true;
                                continue;
                            }
                            if (attribValue.equals("restriction")) {
                                this.isProhibitedRestriction = true;
                                continue;
                            }
                            if (attribValue.equals("list")) {
                                this.isProhibitedList = true;
                                continue;
                            }
                            if (!attribValue.equals("union")) continue;
                            this.isProhibitedUnion = true;
                        }
                    }
                } else if (localName.equals("finalDefault")) {
                    if (attribValue.equals("#all")) {
                        this.isFinalExtension = true;
                        this.isFinalRestriction = true;
                    } else {
                        tokenizer = new StringTokenizer(attribValue);
                        while (tokenizer.hasMoreTokens()) {
                            attribValue = tokenizer.nextToken();
                            if (attribValue.equals("extension")) {
                                this.isFinalExtension = true;
                                continue;
                            }
                            if (!attribValue.equals("restriction")) continue;
                            this.isFinalRestriction = true;
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void collectComponents() throws SchemaComponentException {
        NodeList nodeList = this.schemaElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                String nodeUri = node.getNamespaceURI();
                String nodeLocalName = node.getLocalName();
                if (nodeUri != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    if (nodeLocalName.equals("import")) {
                        this.importSchemas((Element)node);
                    } else if (nodeLocalName.equals("include")) {
                        this.includeSchemas((Element)node);
                    } else if (nodeLocalName.equals("redefine")) {
                        RedefineSpecificMethods.redefineSchemas(this, (Element)node);
                    } else if (nodeLocalName.equals("simpleType")) {
                        this.addSimpleTypeDefinition(SchemaStructuresLoader.createSimpleTypeDefinition(node, this, true, false));
                    } else if (nodeLocalName.equals("complexType")) {
                        this.addComplexTypeDefinition(SchemaStructuresLoader.createComplexTypeDefinition(node, this, true, false));
                    } else if (nodeLocalName.equals("group")) {
                        this.addModelGroupDefinition(SchemaStructuresLoader.createModelGroupDefinition(node, this, true, false));
                    } else if (nodeLocalName.equals("attributeGroup")) {
                        this.addAttributeGroupDefinition(SchemaStructuresLoader.createAttributeGroupDefinition(node, this, true, false));
                    } else if (nodeLocalName.equals("element")) {
                        this.addElementDeclaration(SchemaStructuresLoader.createElementDeclaration(node, this, true));
                    } else if (nodeLocalName.equals("attribute")) {
                        this.addAttributeDeclaration(SchemaStructuresLoader.createAttributeDeclaration(node, this, true));
                    } else if (nodeLocalName.equals("notation")) {
                        this.addNotationDeclaration(SchemaStructuresLoader.createNotationDeclaration(node, this));
                    }
                }
            }
            ++i;
        }
    }

    private void importSchemas(Element importElement) throws SchemaComponentException {
        String importedLocation;
        Attr targetNsAttrib = importElement.getAttributeNode("namespace");
        String importedNamespace = targetNsAttrib == null ? "" : targetNsAttrib.getValue();
        Attr locationAttrib = importElement.getAttributeNode("schemaLocation");
        String string = importedLocation = locationAttrib == null ? null : locationAttrib.getValue();
        if (importedLocation == null) {
            this.importedNamespacesCollector.add(importedNamespace);
        } else {
            this.importSchemas(this.loader.produceSchemas_Location(this.location, importedLocation, null, null), importedNamespace);
        }
    }

    private void importSchemas(SchemaImpl[] importedSchemas, String importedNamespace) throws SchemaComponentException {
        int i = 0;
        while (i < importedSchemas.length) {
            this.importSchema(importedNamespace, importedSchemas[i]);
            ++i;
        }
    }

    private void importSchema(String importedNamespace, SchemaImpl importedSchema) throws SchemaComponentException {
        String namespace = importedSchema.getTargetNamespace();
        if (!namespace.equals(importedNamespace) || importedNamespace.equals(this.targetNamespace)) {
            throw new SchemaComponentException("[location : '" + this.location + "'] ERROR : Can not import '" + importedSchema.getLocation() + "' schema document. " + "The imported schema document must not have the targetNamespace as the <import>ing schema document, or its targetNamespace must be with value '" + importedNamespace + "'.");
        }
        if (!this.importedSchemasCollector.contains(importedSchema)) {
            this.importedSchemasCollector.add(importedSchema);
        }
    }

    private void importSchema(String importedNamespace, SchemaImpl importedSchema, boolean runtimeLoadingImport) throws SchemaComponentException {
        this.importSchema(importedNamespace, importedSchema);
        if (runtimeLoadingImport) {
            SchemaStructuresLoader.loadBase(importedSchema);
        }
    }

    public Vector getImportedSchemas() {
        return this.importedSchemasCollector;
    }

    private void includeSchemas(Element includeElement) throws SchemaComponentException {
        String includedLocation;
        Attr locationAttrib = includeElement.getAttributeNode("schemaLocation");
        String string = includedLocation = locationAttrib == null ? null : locationAttrib.getValue();
        if (includedLocation != null) {
            String namespace = this.includingNamespace == null ? this.targetNamespace : this.includingNamespace;
            this.includeSchemas(this.loader.produceSchemas_Location(this.location, includedLocation, namespace, null), false);
        }
    }

    private void includeSchemas(SchemaImpl[] includedSchemas, boolean runtimeLoadingInclude) throws SchemaComponentException {
        int j = 0;
        while (j < includedSchemas.length) {
            this.includeSchema(includedSchemas[j], runtimeLoadingInclude);
            ++j;
        }
    }

    private void includeSchema(SchemaImpl includedSchema, boolean runtimeLoadingInclude) throws SchemaComponentException {
        boolean isIncludedSchemaTheSameSchema = includedSchema == this;
        boolean isIncludedSchemaAlreadyIncluded = this.includedSchemasCollector.contains(includedSchema);
        if (!isIncludedSchemaTheSameSchema && !isIncludedSchemaAlreadyIncluded) {
            boolean isIncludedSchemaWithEmptyTargetNamespace = includedSchema.getTargetNamespace().equals("");
            boolean isIncludedSchemaWithSameTargetNamespace = includedSchema.getTargetNamespace().equals(this.targetNamespace);
            if (!isIncludedSchemaWithEmptyTargetNamespace && !isIncludedSchemaWithSameTargetNamespace) {
                throw new SchemaComponentException("[location : '" + this.location + "'] ERROR : Can not include '" + includedSchema.getLocation() + "' schema document. The included schema documents must have the same" + " targetNamespace as the <include>ing schema document, or no targetNamespace at all.");
            }
            if (!this.includedSchemasCollector.contains(includedSchema)) {
                this.includedSchemasCollector.add(includedSchema);
            }
            if (runtimeLoadingInclude) {
                SchemaStructuresLoader.loadBase(includedSchema);
            }
        }
    }

    public Vector getIncludedSchemas() {
        return this.includedSchemasCollector;
    }

    public LoaderImpl getLoader() {
        return this.loader;
    }

    public boolean isElemsFormDefaultQualified() {
        return this.elemsFormDefaultIsQualified;
    }

    public boolean isAttribsFormDefaultQualified() {
        return this.attribsFormDefaultIsQualified;
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.setTargetNamespace(targetNamespace, new Vector());
    }

    private void setTargetNamespace(String targetNamespace, Vector processedSchemasCollector) {
        if (!processedSchemasCollector.contains(this)) {
            processedSchemasCollector.add(this);
            this.targetNamespace = targetNamespace;
            int i = 0;
            while (i < this.includedSchemasCollector.size()) {
                SchemaImpl includedSchema = (SchemaImpl)this.includedSchemasCollector.get(i);
                includedSchema.setTargetNamespace(targetNamespace, processedSchemasCollector);
                ++i;
            }
        }
    }

    public boolean isFinalExtension() {
        return this.isFinalExtension;
    }

    public boolean isFinalRestriction() {
        return this.isFinalRestriction;
    }

    public boolean isProhibitedSubstitution() {
        return this.isProhibitedSubstitution;
    }

    public boolean isProhibitedExtension() {
        return this.isProhibitedExtension;
    }

    public boolean isProhibitedRestriction() {
        return this.isProhibitedRestriction;
    }

    public boolean isProhibitedList() {
        return this.isProhibitedList;
    }

    public boolean isProhibitedUnion() {
        return this.isProhibitedUnion;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public void addComponent(BaseImpl base) {
        this.allComponentsCollector.add(base);
    }

    @Override
    public void getTopLevelComponents(Vector collector) {
        this.getTopLevelComponents(collector, "");
    }

    public void getTopLevelComponents(Vector collector, String componentsId) {
        Vector<SchemaImpl> referenceableSchemas = new Vector<SchemaImpl>();
        referenceableSchemas.add(this);
        this.getTopLevelComponents(collector, componentsId, referenceableSchemas);
        referenceableSchemas.clear();
    }

    private void getTopLevelComponents(Vector collector, String componentsId, Vector processedSchemasCollector) {
        this.getOwnTopLevelComponents(collector, componentsId);
        this.getReferenceableTopLevelComponents(collector, componentsId, processedSchemasCollector, this.importedSchemasCollector);
        this.getReferenceableTopLevelComponents(collector, componentsId, processedSchemasCollector, this.includedSchemasCollector);
    }

    private void getOwnTopLevelComponents(Vector collector, String componentID) {
        if (componentID.isEmpty()) {
            this.addAllFromHashtableToVector(collector, (Hashtable)this.idToTopLevelComponentsMapping.get("TD"));
            this.addAllFromHashtableToVector(collector, (Hashtable)this.idToTopLevelComponentsMapping.get("ED"));
            this.addAllFromHashtableToVector(collector, (Hashtable)this.idToTopLevelComponentsMapping.get("AD"));
            this.addAllFromHashtableToVector(collector, (Hashtable)this.idToTopLevelComponentsMapping.get("AGD"));
            this.addAllFromHashtableToVector(collector, (Hashtable)this.idToTopLevelComponentsMapping.get("MGD"));
            this.addAllFromHashtableToVector(collector, (Hashtable)this.idToTopLevelComponentsMapping.get("ICD"));
            this.addAllFromHashtableToVector(collector, (Hashtable)this.idToTopLevelComponentsMapping.get("ND"));
        } else {
            this.addAllFromHashtableToVector(collector, (Hashtable)this.idToTopLevelComponentsMapping.get(componentID));
        }
    }

    private void addAllFromHashtableToVector(Vector vectorCollector, Hashtable hashCollector) {
        Enumeration enum1 = hashCollector.elements();
        while (enum1.hasMoreElements()) {
            vectorCollector.add(enum1.nextElement());
        }
    }

    private void getReferenceableTopLevelComponents(Vector collector, String componentsId, Vector processedSchemasCollector, Vector referenceableSchemasCollector) {
        int i = 0;
        while (i < referenceableSchemasCollector.size()) {
            SchemaImpl referenceableSchema = (SchemaImpl)referenceableSchemasCollector.get(i);
            this.getReferenceableTopLevelComponents(collector, componentsId, processedSchemasCollector, referenceableSchema);
            ++i;
        }
    }

    private void getReferenceableTopLevelComponents(Vector collector, String componentsId, Vector processedSchemasCollector, SchemaImpl referenceableSchema) {
        if (!processedSchemasCollector.contains(referenceableSchema)) {
            processedSchemasCollector.add(referenceableSchema);
            referenceableSchema.getTopLevelComponents(collector, componentsId, processedSchemasCollector);
        }
    }

    @Override
    public void getIdentityConstraintDefinitions(Vector collector) {
        this.getTopLevelComponents(collector, "ICD");
    }

    @Override
    public void getTopLevelTypeDefinitions(Vector collector) {
        this.getTopLevelComponents(collector, "TD");
    }

    @Override
    public void getTopLevelAttributeDeclarations(Vector collector) {
        this.getTopLevelComponents(collector, "AD");
    }

    @Override
    public void getTopLevelElementDeclarations(Vector collector) {
        this.getTopLevelComponents(collector, "ED");
    }

    @Override
    public void getTopLevelAttributeGroupDefinitions(Vector collector) {
        this.getTopLevelComponents(collector, "AGD");
    }

    @Override
    public void getTopLevelModelGroupDefinitions(Vector collector) {
        this.getTopLevelComponents(collector, "MGD");
    }

    @Override
    public void getTopLevelNotationDeclarations(Vector collector) {
        this.getTopLevelComponents(collector, "ND");
    }

    @Override
    public IdentityConstraintDefinition[] getIdentityConstraintDefinitionsArray() {
        Vector collector = new Vector();
        this.getTopLevelComponents(collector, "ICD");
        Object[] components = new IdentityConstraintDefinition[collector.size()];
        collector.copyInto(components);
        return components;
    }

    @Override
    public TypeDefinitionBase[] getTopLevelTypeDefinitionsArray() {
        Vector collector = new Vector();
        this.getTopLevelComponents(collector, "TD");
        Object[] components = new TypeDefinitionBase[collector.size()];
        collector.copyInto(components);
        return components;
    }

    @Override
    public AttributeDeclaration[] getTopLevelAttributeDeclarationsArray() {
        Vector collector = new Vector();
        this.getTopLevelComponents(collector, "AD");
        Object[] components = new AttributeDeclaration[collector.size()];
        collector.copyInto(components);
        return components;
    }

    @Override
    public ElementDeclaration[] getTopLevelElementDeclarationsArray() {
        Vector collector = new Vector();
        this.getTopLevelComponents(collector, "ED");
        Object[] components = new ElementDeclaration[collector.size()];
        collector.copyInto(components);
        return components;
    }

    @Override
    public AttributeGroupDefinition[] getTopLevelAttributeGroupDefinitionsArray() {
        Vector collector = new Vector();
        this.getTopLevelComponents(collector, "AGD");
        Object[] components = new AttributeGroupDefinition[collector.size()];
        collector.copyInto(components);
        return components;
    }

    @Override
    public ModelGroupDefinition[] getTopLevelModelGroupDefinitionsArray() {
        Vector collector = new Vector();
        this.getTopLevelComponents(collector, "MGD");
        Object[] components = new ModelGroupDefinition[collector.size()];
        collector.copyInto(components);
        return components;
    }

    @Override
    public NotationDeclaration[] getTopLevelNotationDeclarationsArray() {
        Vector collector = new Vector();
        this.getTopLevelComponents(collector, "ND");
        Object[] components = new NotationDeclaration[collector.size()];
        collector.copyInto(components);
        return components;
    }

    @Override
    public QualifiedBase[] getTopLevelComponentsArray() {
        Vector collector = new Vector();
        this.getTopLevelComponents(collector);
        Object[] components = new QualifiedBase[collector.size()];
        collector.copyInto(components);
        return components;
    }

    @Override
    public Base[] getAllComponentsAsArray() {
        Vector collector = new Vector();
        this.getAllComponents(collector);
        Object[] result = new Base[collector.size()];
        collector.copyInto(result);
        return result;
    }

    @Override
    public void getAllComponents(Vector collector) {
        Vector<SchemaImpl> referenceableSchemas = new Vector<SchemaImpl>();
        referenceableSchemas.add(this);
        this.getAllComponents(collector, referenceableSchemas);
        referenceableSchemas.clear();
    }

    private void getAllComponents(Vector collector, Vector processedSchemasCollector) {
        this.getAllOwnComponents(collector);
        this.getAllReferenceableComponents(collector, processedSchemasCollector, this.importedSchemasCollector);
        this.getAllReferenceableComponents(collector, processedSchemasCollector, this.includedSchemasCollector);
    }

    private void getAllOwnComponents(Vector collector) {
        collector.addAll(this.allComponentsCollector);
    }

    private void getAllReferenceableComponents(Vector collector, Vector processedSchemasCollector, Vector referenceableSchemasCollector) {
        int i = 0;
        while (i < referenceableSchemasCollector.size()) {
            SchemaImpl referenceableSchema = (SchemaImpl)referenceableSchemasCollector.get(i);
            this.getAllReferenceableComponents(collector, processedSchemasCollector, referenceableSchema);
            ++i;
        }
    }

    private void getAllReferenceableComponents(Vector collector, Vector processedSchemasCollector, SchemaImpl referenceableSchema) {
        if (!processedSchemasCollector.contains(referenceableSchema)) {
            processedSchemasCollector.add(referenceableSchema);
            referenceableSchema.getAllComponents(collector, processedSchemasCollector);
        }
    }

    @Override
    public int getTypeOfComponent() {
        return 0;
    }

    @Override
    public QualifiedBase getTopLevelComponent(String uri, String name, int type) {
        switch (type) {
            case 4: {
                return this.getTopLevelAttributeDeclaration(uri, name);
            }
            case 5: {
                return this.getTopLevelAttributeGroupDefinition(uri, name);
            }
            case 3: {
                return this.getTopLevelElementDeclaration(uri, name);
            }
            case 8: {
                return this.getTopLevelModelGroupDefinition(uri, name);
            }
            case 14: {
                return this.getTopLevelNotationDeclaration(uri, name);
            }
            case 16: {
                return this.getTopLevelTypeDefinition(uri, name);
            }
            case 1: {
                return this.getTopLevelTypeDefinition(uri, name);
            }
            case 2: {
                return this.getTopLevelTypeDefinition(uri, name);
            }
            case 13: {
                return this.getIdentityConstraintDefinition(uri, name);
            }
        }
        throw new IllegalArgumentException("Type with id " + type + " is unknown.");
    }

    @Override
    public QualifiedBase getTopLevelComponent(String uri, String name, String componentsId) {
        QualifiedBase qBase = null;
        if (uri.equals("http://www.w3.org/2001/XMLSchema") && componentsId.equals("TD")) {
            qBase = SchemaImpl.getBuiltInTypeDefnition(name);
        }
        if (qBase == null) {
            qBase = this.getSpecifiedTopLevelComponent(uri, name, componentsId);
        }
        return qBase;
    }

    private QualifiedBase getSpecifiedTopLevelComponent(String uri, String name, String componentsId) {
        Vector<SchemaImpl> referenceableSchemas = new Vector<SchemaImpl>();
        referenceableSchemas.add(this);
        QualifiedBase qBase = this.getSpecifiedTopLevelComponent(uri, name, componentsId, referenceableSchemas);
        referenceableSchemas.clear();
        return qBase;
    }

    private QualifiedBase getSpecifiedTopLevelComponent(String uri, String name, String componentsId, Vector processedSchemasCollector) {
        QualifiedBase qBase = null;
        if (uri.equals(this.targetNamespace)) {
            qBase = this.getOwnTopLevelComponent(name, componentsId);
        }
        if (qBase == null && (qBase = this.getReferenceableTopLevelComponent(uri, name, componentsId, processedSchemasCollector, this.includedSchemasCollector)) == null) {
            qBase = this.getReferenceableTopLevelComponent(uri, name, componentsId, processedSchemasCollector, this.importedSchemasCollector);
        }
        return qBase;
    }

    private QualifiedBase getOwnTopLevelComponent(String name, String componentsId) {
        Hashtable nameToTopLevelComponentsMapping = (Hashtable)this.idToTopLevelComponentsMapping.get(componentsId);
        return (QualifiedBase)nameToTopLevelComponentsMapping.get(name);
    }

    private QualifiedBase getReferenceableTopLevelComponent(String uri, String name, String componentsId, Vector processedSchemasCollector, Vector referenceableSchemasCollector) {
        int i = 0;
        while (i < referenceableSchemasCollector.size()) {
            SchemaImpl referenceableSchema = (SchemaImpl)referenceableSchemasCollector.get(i);
            if (!processedSchemasCollector.contains(referenceableSchema)) {
                processedSchemasCollector.add(referenceableSchema);
                QualifiedBase qBase = referenceableSchema.getSpecifiedTopLevelComponent(uri, name, componentsId, processedSchemasCollector);
                if (qBase != null) {
                    return qBase;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public IdentityConstraintDefinition getIdentityConstraintDefinition(String uri, String name) {
        return (IdentityConstraintDefinition)this.getTopLevelComponent(uri, name, "ICD");
    }

    @Override
    public TypeDefinitionBase getTopLevelTypeDefinition(String uri, String name) {
        return (TypeDefinitionBase)this.getTopLevelComponent(uri, name, "TD");
    }

    @Override
    public AttributeDeclaration getTopLevelAttributeDeclaration(String uri, String name) {
        return (AttributeDeclaration)this.getTopLevelComponent(uri, name, "AD");
    }

    @Override
    public ElementDeclaration getTopLevelElementDeclaration(String uri, String name) {
        return (ElementDeclaration)this.getTopLevelComponent(uri, name, "ED");
    }

    @Override
    public AttributeGroupDefinition getTopLevelAttributeGroupDefinition(String uri, String name) {
        return (AttributeGroupDefinition)this.getTopLevelComponent(uri, name, "AGD");
    }

    @Override
    public ModelGroupDefinition getTopLevelModelGroupDefinition(String uri, String name) {
        return (ModelGroupDefinition)this.getTopLevelComponent(uri, name, "MGD");
    }

    @Override
    public NotationDeclaration getTopLevelNotationDeclaration(String uri, String name) {
        return (NotationDeclaration)this.getTopLevelComponent(uri, name, "ND");
    }

    private void addTopLevelComponent(QualifiedBaseImpl qualifiedBase, String componentId) throws SchemaComponentException {
        boolean isSameTargetNameSpaceAsSchema = qualifiedBase.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema");
        boolean isComponentTypeDefinition = componentId.equals("TD");
        boolean isQnameContainedInBuiltInTypesCollector = builtInTypesCollector.containsKey(qualifiedBase.getName());
        if (!(isSameTargetNameSpaceAsSchema && isComponentTypeDefinition && isQnameContainedInBuiltInTypesCollector)) {
            Hashtable storage = (Hashtable)this.idToTopLevelComponentsMapping.get(componentId);
            boolean isRedefinableQBase = qualifiedBase instanceof RedefineableQualifiedBaseImpl && ((RedefineableQualifiedBaseImpl)qualifiedBase).isRedefined();
            boolean alreadyContainsQBase = storage.containsKey(qualifiedBase.getName());
            if (!isRedefinableQBase && alreadyContainsQBase) {
                throw new SchemaComponentException("[location : '" + this.location + "'] ERROR : Top level component " + qualifiedBase.toString() + " is already defined.");
            }
            storage.put(qualifiedBase.getName(), qualifiedBase);
        }
    }

    private void addAttributeDeclaration(AttributeDeclarationImpl attributeDeclaration) throws SchemaComponentException {
        this.addTopLevelComponent(attributeDeclaration, "AD");
    }

    private void addAttributeGroupDefinition(AttributeGroupDefinitionImpl attributeGroupDefinition) throws SchemaComponentException {
        this.addTopLevelComponent(attributeGroupDefinition, "AGD");
    }

    private void addElementDeclaration(ElementDeclarationImpl elementDeclaration) throws SchemaComponentException {
        this.addTopLevelComponent(elementDeclaration, "ED");
    }

    private void addModelGroupDefinition(ModelGroupDefinitionImpl modelGroupDefinition) throws SchemaComponentException {
        this.addTopLevelComponent(modelGroupDefinition, "MGD");
    }

    private void addNotationDeclaration(NotationDeclarationImpl notationDeclaration) throws SchemaComponentException {
        this.addTopLevelComponent(notationDeclaration, "ND");
    }

    private void addComplexTypeDefinition(ComplexTypeDefinitionImpl complexTypeDefinition) throws SchemaComponentException {
        this.addTopLevelComponent(complexTypeDefinition, "TD");
    }

    private void addSimpleTypeDefinition(SimpleTypeDefinitionImpl simpleTypeDefinition) throws SchemaComponentException {
        this.addTopLevelComponent(simpleTypeDefinition, "TD");
    }

    protected void addIdentityConstraintDefinition(IdentityConstraintDefinitionImpl identConstrDefinition) throws SchemaComponentException {
        this.addTopLevelComponent(identConstrDefinition, "ICD");
    }

    @Override
    public boolean match(Base schemaImpl) {
        return false;
    }

    @Override
    public void load() throws SchemaComponentException {
        super.load();
        this.importNamespaces();
        this.loadImportedSchemas();
        this.loadIncludedSchemas();
        this.loadTopLevelComponents("TD");
        this.loadTopLevelComponents("ED");
        this.loadTopLevelComponents("AD");
        this.loadTopLevelComponents("AGD");
        this.loadTopLevelComponents("MGD");
        this.loadTopLevelComponents("ND");
        this.loadTopLevelComponents("ICD");
        this.preloadComplexTypeDefinitions();
    }

    private void importNamespaces() throws SchemaComponentException {
        int i = 0;
        while (i < this.importedNamespacesCollector.size()) {
            String namespace = (String)this.importedNamespacesCollector.get(i);
            this.importNamespace(namespace, false);
            ++i;
        }
    }

    public void importNamespace(String namespace, boolean runtimeLoadingImport) throws SchemaComponentException {
        SchemaImpl[] schemas;
        SchemaImpl[] schemaImplArray = schemas = runtimeLoadingImport ? this.loader.produceSchemas_Namespace_UriResolver(namespace) : this.loader.produceSchemas_Namespace(namespace);
        if (schemas != null) {
            int importedSchemaIndex = 0;
            while (importedSchemaIndex < schemas.length) {
                SchemaImpl importedSchema = schemas[importedSchemaIndex];
                this.importSchema(namespace, importedSchema, runtimeLoadingImport);
                ++importedSchemaIndex;
            }
        }
    }

    public void includeNamespace() throws SchemaComponentException {
        this.includeSchemas(this.loader.produceSchemas_Namespace(this.targetNamespace), true);
    }

    private void loadImportedSchemas() throws SchemaComponentException {
        int i = 0;
        while (i < this.importedSchemasCollector.size()) {
            SchemaImpl importedSchema = (SchemaImpl)this.importedSchemasCollector.get(i);
            SchemaStructuresLoader.loadBase(importedSchema);
            ++i;
        }
    }

    private void loadIncludedSchemas() throws SchemaComponentException {
        int i = 0;
        while (i < this.includedSchemasCollector.size()) {
            SchemaImpl includedSchema = (SchemaImpl)this.includedSchemasCollector.get(i);
            this.loadIncludedSchema(includedSchema);
            ++i;
        }
    }

    private void loadIncludedSchema(SchemaImpl includedSchema) throws SchemaComponentException {
        boolean isIncludedSchemaTargetNamespaceDifferentFromThisTargetNamespace;
        SchemaStructuresLoader.loadBase(includedSchema);
        boolean bl = isIncludedSchemaTargetNamespaceDifferentFromThisTargetNamespace = !includedSchema.getTargetNamespace().equals(this.targetNamespace);
        if (isIncludedSchemaTargetNamespaceDifferentFromThisTargetNamespace) {
            includedSchema.setTargetNamespace(this.targetNamespace);
        }
    }

    private void loadTopLevelComponents(String componentsId) throws SchemaComponentException {
        Hashtable componentStorage = (Hashtable)this.idToTopLevelComponentsMapping.get(componentsId);
        Enumeration componentElements = componentStorage.elements();
        while (componentElements.hasMoreElements()) {
            this.loadTopLevelComponent(componentsId, (QualifiedBaseImpl)componentElements.nextElement());
        }
    }

    private void loadTopLevelComponent(String componentId, QualifiedBaseImpl topLevelComponent) throws SchemaComponentException {
        SchemaStructuresLoader.loadBase(topLevelComponent);
        this.validateForMultipleTopLevelComponents(topLevelComponent, componentId, this.importedSchemasCollector);
        this.validateForMultipleTopLevelComponents(topLevelComponent, componentId, this.includedSchemasCollector);
    }

    private void validateForMultipleTopLevelComponents(QualifiedBaseImpl ownTopLevelComponent, String componentId, Vector referenceableSchemas) throws SchemaComponentException {
        int refSchemaIndex = 0;
        while (refSchemaIndex < referenceableSchemas.size()) {
            boolean isOwnTopLevelComponentSameAsReferenceableTopLevelComponent;
            SchemaImpl referenceableSchema = (SchemaImpl)referenceableSchemas.get(refSchemaIndex);
            QualifiedBase referenceableTopLevelComponent = referenceableSchema.getTopLevelComponent(ownTopLevelComponent.getTargetNamespace(), ownTopLevelComponent.getName(), componentId);
            boolean notNullReferenceableTopLevelComponent = referenceableTopLevelComponent != null;
            boolean bl = isOwnTopLevelComponentSameAsReferenceableTopLevelComponent = ownTopLevelComponent != referenceableTopLevelComponent;
            if (notNullReferenceableTopLevelComponent && isOwnTopLevelComponentSameAsReferenceableTopLevelComponent) {
                throw new SchemaComponentException("[location : '" + this.location + "'] ERROR : Top level component " + ownTopLevelComponent.toString() + " is already defined by the schema '" + referenceableTopLevelComponent.getOwnerSchema().getLocation() + "'.");
            }
            ++refSchemaIndex;
        }
    }

    private void preloadComplexTypeDefinitions() throws SchemaComponentException {
        int i = 0;
        while (i < this.allComplexTypeDefinitions.size()) {
            ComplexTypeDefinitionImpl complTypeDef = (ComplexTypeDefinitionImpl)this.allComplexTypeDefinitions.get(i);
            SchemaStructuresLoader.preloadComplexType(complTypeDef);
            ++i;
        }
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        return null;
    }

    public static TypeDefinitionBase getBuiltInTypeDefnition(String typeName) {
        return (TypeDefinitionBase)builtInTypesCollector.get(typeName);
    }

    @Override
    public void getBuiltInTypeDefinitions(Vector collector) {
        Enumeration builtInTypes = builtInTypesCollector.elements();
        while (builtInTypes.hasMoreElements()) {
            collector.add(builtInTypes.nextElement());
        }
    }

    @Override
    public TypeDefinitionBase[] getBuiltInTypeDefinitions() {
        Vector collector = new Vector();
        this.getBuiltInTypeDefinitions(collector);
        Object[] result = new TypeDefinitionBase[collector.size()];
        collector.copyInto(result);
        return result;
    }

    protected void addComplexTypeDefinition_All(ComplexTypeDefinition complTypeDef) {
        this.allComplexTypeDefinitions.add(complTypeDef);
    }

    protected Vector getAllComplexTypeDefinition() {
        return this.allComplexTypeDefinitions;
    }

    private static class RedefineSpecificMethods {
        private RedefineSpecificMethods() {
        }

        private static void redefineSchemas(SchemaImpl schemaImpl, Element redefineElement) throws SchemaComponentException {
            String redefinedLocation;
            Attr locationAttrib = redefineElement.getAttributeNode("schemaLocation");
            String string = redefinedLocation = locationAttrib == null ? null : locationAttrib.getValue();
            if (redefinedLocation != null) {
                String namespace = schemaImpl.includingNamespace == null ? schemaImpl.targetNamespace : schemaImpl.includingNamespace;
                RedefineSpecificMethods.redefineSchemas(schemaImpl, schemaImpl.loader.produceSchemas_Location(schemaImpl.location, redefinedLocation, namespace, null), redefineElement);
            }
        }

        private static void redefineSchemas(SchemaImpl schemaImpl, SchemaImpl[] redefinedSchemas, Element redefineElement) throws SchemaComponentException {
            int j = 0;
            while (j < redefinedSchemas.length) {
                RedefineSpecificMethods.redefineSchema(schemaImpl, redefinedSchemas[j], redefineElement);
                ++j;
            }
        }

        private static void redefineSchema(SchemaImpl schemaImpl, SchemaImpl redefinedSchema, Element redefineElement) throws SchemaComponentException {
            schemaImpl.includeSchema(redefinedSchema, false);
            RedefineSpecificMethods.collectRedefinedComponents(schemaImpl, redefineElement, redefinedSchema);
        }

        private static void collectRedefinedComponents(SchemaImpl schemaImpl, Element redefineElement, SchemaImpl redefinedSchema) throws SchemaComponentException {
            NodeList nodeList = redefineElement.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node instanceof Element) {
                    String nodeUri = node.getNamespaceURI();
                    String nodeLocalName = node.getLocalName();
                    if (nodeUri != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                        if (nodeLocalName.equals("simpleType")) {
                            SimpleTypeDefinitionImpl simpleTypeDef = SchemaStructuresLoader.createSimpleTypeDefinition(node, schemaImpl, true, true);
                            RedefineSpecificMethods.addRedefinedSimpleTypeDefinition(schemaImpl, simpleTypeDef, redefinedSchema);
                        } else if (nodeLocalName.equals("complexType")) {
                            ComplexTypeDefinitionImpl complexTypeDef = SchemaStructuresLoader.createComplexTypeDefinition(node, schemaImpl, true, true);
                            RedefineSpecificMethods.addRedefinedComplexTypeDefinition(schemaImpl, complexTypeDef, redefinedSchema);
                        } else if (nodeLocalName.equals("group")) {
                            ModelGroupDefinitionImpl modelGroupDef = SchemaStructuresLoader.createModelGroupDefinition(node, schemaImpl, true, true);
                            RedefineSpecificMethods.addRedefinedModelGroupDefinition(schemaImpl, modelGroupDef, redefinedSchema);
                        } else if (nodeLocalName.equals("attributeGroup")) {
                            AttributeGroupDefinitionImpl attributeGroupDef = SchemaStructuresLoader.createAttributeGroupDefinition(node, schemaImpl, true, true);
                            RedefineSpecificMethods.addRedefinedAttributeGroupDefinition(schemaImpl, attributeGroupDef, redefinedSchema);
                        }
                    }
                }
                ++i;
            }
        }

        private static void addRedefinedSimpleTypeDefinition(SchemaImpl schemaImpl, SimpleTypeDefinitionImpl simpleTypeDefinition, SchemaImpl redefinedSchema) throws SchemaComponentException {
            RedefineSpecificMethods.processTopLevelComponentForRedefinition(schemaImpl, simpleTypeDefinition, "TD", redefinedSchema);
            schemaImpl.addSimpleTypeDefinition(simpleTypeDefinition);
        }

        private static void addRedefinedAttributeGroupDefinition(SchemaImpl schemaImpl, AttributeGroupDefinitionImpl attributeGroupDefinition, SchemaImpl redefinedSchema) throws SchemaComponentException {
            RedefineSpecificMethods.processTopLevelComponentForRedefinition(schemaImpl, attributeGroupDefinition, "AGD", redefinedSchema);
            schemaImpl.addAttributeGroupDefinition(attributeGroupDefinition);
        }

        private static void addRedefinedComplexTypeDefinition(SchemaImpl schemaImpl, ComplexTypeDefinitionImpl complexTypeDefinition, SchemaImpl redefinedSchema) throws SchemaComponentException {
            RedefineSpecificMethods.processTopLevelComponentForRedefinition(schemaImpl, complexTypeDefinition, "TD", redefinedSchema);
            schemaImpl.addComplexTypeDefinition(complexTypeDefinition);
        }

        private static void addRedefinedModelGroupDefinition(SchemaImpl schemaImpl, ModelGroupDefinitionImpl modelGroupDefinition, SchemaImpl redefinedSchema) throws SchemaComponentException {
            RedefineSpecificMethods.processTopLevelComponentForRedefinition(schemaImpl, modelGroupDefinition, "MGD", redefinedSchema);
            schemaImpl.addModelGroupDefinition(modelGroupDefinition);
        }

        private static void processTopLevelComponentForRedefinition(SchemaImpl schemaImpl, QualifiedBaseImpl qualifiedBase, String componentId, SchemaImpl redefinedSchema) throws SchemaComponentException {
            String redefinedSchemaNs = redefinedSchema.getTargetNamespace();
            String qualifiedBaseName = qualifiedBase.getName();
            QualifiedBaseImpl redefinedQualifiedBase = (QualifiedBaseImpl)redefinedSchema.getTopLevelComponent(redefinedSchemaNs, qualifiedBaseName, componentId);
            SchemaImpl redefinedQBaseOwnerSchema = (SchemaImpl)redefinedQualifiedBase.getOwnerSchema();
            redefinedQBaseOwnerSchema.augmentWithReferenceableSchema(schemaImpl);
            RedefineSpecificMethods.removeTopLevelComponent(redefinedQBaseOwnerSchema, qualifiedBaseName, componentId);
        }

        private static void removeTopLevelComponent(SchemaImpl schemaImpl, String quilifiedBaseName, String componentId) {
            Hashtable storage = (Hashtable)schemaImpl.idToTopLevelComponentsMapping.get(componentId);
            storage.remove(quilifiedBaseName);
        }
    }
}

