/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.impl.structures.AnnotationImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.AttributeUseImpl;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ComplexTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.ElementDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.FacetImpl;
import com.sap.engine.lib.schema.components.impl.structures.IdentityConstraintDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.InfoItemDeclarationBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ModelGroupDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.ModelGroupImpl;
import com.sap.engine.lib.schema.components.impl.structures.NotationDeclarationImpl;
import com.sap.engine.lib.schema.components.impl.structures.ParticleImpl;
import com.sap.engine.lib.schema.components.impl.structures.QualifiedBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SimpleTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.TypeDefinitionBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.WildcardImpl;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class SchemaVisualizationFrame
extends JFrame {
    private SchemaImpl schema;
    private Vector processedSchemasCollector;
    private Vector processedIdentConstrDefsCollector;
    private Vector processedTypeDefsCollector;
    private Vector processedModelGroupCollector;
    private Vector processedElemDeclrsCollector;
    private Vector processedAttribDeclrsCollector;
    private Vector processedAttribGropDefsCollector;
    private Vector processedNotationDEclrsCollector;

    public SchemaVisualizationFrame(SchemaImpl schema) {
        this.schema = schema;
        this.setDefaultCloseOperation(3);
        this.processedSchemasCollector = new Vector();
        this.processedIdentConstrDefsCollector = new Vector();
        this.processedTypeDefsCollector = new Vector();
        this.processedModelGroupCollector = new Vector();
        this.processedElemDeclrsCollector = new Vector();
        this.processedAttribDeclrsCollector = new Vector();
        this.processedAttribGropDefsCollector = new Vector();
        this.processedNotationDEclrsCollector = new Vector();
    }

    public void vizualize() throws Exception {
        this.setSize(1000, 700);
        JTree visualizationTree = new JTree(this.createSchemaNode(this.schema));
        JScrollPane treeVisualizationScrollPane = new JScrollPane(visualizationTree);
        visualizationTree.setVisible(true);
        treeVisualizationScrollPane.getViewport().repaint();
        this.getContentPane().add(treeVisualizationScrollPane);
        this.setVisible(true);
    }

    private DefaultMutableTreeNode createSchemaNode(SchemaImpl schema) {
        DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode("{" + schema.getTargetNamespace() + "} : " + schema.getLocation());
        if (!this.processedSchemasCollector.contains(schema)) {
            this.processedSchemasCollector.add(schema);
            this.augmentBaseSpecifics(schemaNode, schema);
            schemaNode.add(new DefaultMutableTreeNode("target namespace : " + schema.getTargetNamespace()));
            schemaNode.add(new DefaultMutableTreeNode("elements form default : " + schema.isElemsFormDefaultQualified()));
            schemaNode.add(new DefaultMutableTreeNode("attributes form default : " + schema.isAttribsFormDefaultQualified()));
            schemaNode.add(new DefaultMutableTreeNode("final extension : " + schema.isFinalExtension()));
            schemaNode.add(new DefaultMutableTreeNode("final restriction : " + schema.isFinalRestriction()));
            schemaNode.add(new DefaultMutableTreeNode("prohibited substitution : " + schema.isProhibitedSubstitution()));
            schemaNode.add(new DefaultMutableTreeNode("prohibited extension : " + schema.isProhibitedExtension()));
            schemaNode.add(new DefaultMutableTreeNode("prohibited restriction : " + schema.isProhibitedRestriction()));
            schemaNode.add(new DefaultMutableTreeNode("prohibited list : " + schema.isProhibitedList()));
            schemaNode.add(new DefaultMutableTreeNode("prohibited union : " + schema.isProhibitedUnion()));
            schemaNode.add(new DefaultMutableTreeNode("location : " + schema.getLocation()));
            schemaNode.add(this.createImportedSchemasNode(schema));
            schemaNode.add(this.createIncludedSchemasNode(schema));
            schemaNode.add(this.createIdentityConstraintsNode(schema));
            schemaNode.add(this.createTypeDefinitionsNode(schema));
            schemaNode.add(this.createAttributeDeclarationsNode(schema));
            schemaNode.add(this.createElementDeclarationsNode(schema));
            schemaNode.add(this.createAttributeGroupDefinitionsNode(schema));
            schemaNode.add(this.createModelGroupDefinitionsNode(schema));
            schemaNode.add(this.createNotationDeclarationsNode(schema));
            schemaNode.add(this.createAllComponentsNode(schema));
        }
        return schemaNode;
    }

    private DefaultMutableTreeNode createIdentityConstraintsNode(SchemaImpl schema) {
        DefaultMutableTreeNode identityConstraintsNode = new DefaultMutableTreeNode("identity constr defs");
        Vector collector = new Vector();
        schema.getIdentityConstraintDefinitions(collector);
        int i = 0;
        while (i < collector.size()) {
            IdentityConstraintDefinitionImpl identityConstrDef = (IdentityConstraintDefinitionImpl)collector.get(i);
            identityConstraintsNode.add(this.createIdentityConstraintNode(identityConstrDef, true));
            ++i;
        }
        return identityConstraintsNode;
    }

    private DefaultMutableTreeNode createIdentityConstraintNode(IdentityConstraintDefinitionImpl identConstrDef, boolean display) {
        DefaultMutableTreeNode identityConstrDefNode = new DefaultMutableTreeNode("ident constr def " + identConstrDef.toString());
        if (this.displayQBase(identConstrDef, this.processedIdentConstrDefsCollector, display)) {
            this.registerQBase(identConstrDef, this.processedIdentConstrDefsCollector);
            this.augmentBaseSpecifics(identityConstrDefNode, identConstrDef);
            this.augmentQualifiedBaseSpecifics(identityConstrDefNode, identConstrDef);
            identityConstrDefNode.add(new DefaultMutableTreeNode("isKey : " + identConstrDef.isIdentityConstraintCategoryKey()));
            identityConstrDefNode.add(new DefaultMutableTreeNode("isKeyref : " + identConstrDef.isIdentityConstraintCategoryKeyref()));
            identityConstrDefNode.add(new DefaultMutableTreeNode("isUnique : " + identConstrDef.isIdentityConstraintCategoryUnique()));
            identityConstrDefNode.add(new DefaultMutableTreeNode("selector : " + identConstrDef.getSelector()));
            identityConstrDefNode.add(this.createIdentityconstrDefFildsNode(identConstrDef));
        }
        return identityConstrDefNode;
    }

    private void registerQBase(QualifiedBaseImpl qBase, Vector collector) {
        if (qBase.isTopLevel()) {
            collector.add(qBase);
        }
    }

    private boolean displayQBase(QualifiedBaseImpl qBase, Vector collector, boolean displayIfTopLevel) {
        return !qBase.isTopLevel() || displayIfTopLevel && !collector.contains(qBase);
    }

    private DefaultMutableTreeNode createIdentityconstrDefFildsNode(IdentityConstraintDefinitionImpl identConstrDef) {
        DefaultMutableTreeNode identityConstrDefNode = new DefaultMutableTreeNode("fields");
        Vector collector = new Vector();
        identConstrDef.getFields(collector);
        int i = 0;
        while (i < collector.size()) {
            identityConstrDefNode.add(new DefaultMutableTreeNode((String)collector.get(i)));
            ++i;
        }
        return identityConstrDefNode;
    }

    private void augmentBaseSpecifics(DefaultMutableTreeNode baseNode, BaseImpl base) {
        baseNode.add(new DefaultMutableTreeNode("isBuitIn : " + base.isBuiltIn()));
        baseNode.add(this.createAnnotationNode((AnnotationImpl)base.getAnnotation()));
        baseNode.add(new DefaultMutableTreeNode("isLoading : " + base.getAnnotation()));
        baseNode.add(new DefaultMutableTreeNode("isLoaded : " + base.isLoaded()));
        baseNode.add(new DefaultMutableTreeNode("isLoaded : " + base.isLoaded()));
    }

    private DefaultMutableTreeNode createAnnotationNode(AnnotationImpl annotation) {
        return new DefaultMutableTreeNode("annotation");
    }

    private void augmentQualifiedBaseSpecifics(DefaultMutableTreeNode baseNode, QualifiedBaseImpl base) {
        baseNode.add(new DefaultMutableTreeNode("name : " + base.getName()));
        baseNode.add(new DefaultMutableTreeNode("namespace : " + base.getTargetNamespace()));
        baseNode.add(new DefaultMutableTreeNode("isAnonimous : " + base.isAnonymous()));
        baseNode.add(new DefaultMutableTreeNode("isTopLevel : " + base.isTopLevel()));
        baseNode.add(new DefaultMutableTreeNode("qualifiedKey : " + base.getQualifiedKey()));
    }

    private DefaultMutableTreeNode createTypeDefinitionsNode(SchemaImpl schema) {
        DefaultMutableTreeNode typeDefsNode = new DefaultMutableTreeNode("type defs");
        Vector collector = new Vector();
        schema.getTopLevelTypeDefinitions(collector);
        int i = 0;
        while (i < collector.size()) {
            TypeDefinitionBaseImpl typeDef = (TypeDefinitionBaseImpl)collector.get(i);
            typeDefsNode.add(this.createTypeDefinitionNode(typeDef, true));
            ++i;
        }
        return typeDefsNode;
    }

    private DefaultMutableTreeNode createTypeDefinitionNode(TypeDefinitionBaseImpl typeDef, boolean displayIfTopLevel) {
        return typeDef instanceof SimpleTypeDefinitionImpl ? this.createSimpleTypeDefinitionNode((SimpleTypeDefinitionImpl)typeDef, displayIfTopLevel) : this.createComplexTypeDefinitionNode((ComplexTypeDefinitionImpl)typeDef, displayIfTopLevel);
    }

    private DefaultMutableTreeNode createComplexTypeDefinitionNode(ComplexTypeDefinitionImpl complexTypeDef, boolean displayIfTopLevel) {
        DefaultMutableTreeNode typeDefNode = new DefaultMutableTreeNode("complex type def " + complexTypeDef.toString());
        if (!complexTypeDef.isBuiltIn() && this.displayQBase(complexTypeDef, this.processedTypeDefsCollector, displayIfTopLevel)) {
            this.registerQBase(complexTypeDef, this.processedTypeDefsCollector);
            this.augmentBaseSpecifics(typeDefNode, complexTypeDef);
            this.augmentQualifiedBaseSpecifics(typeDefNode, complexTypeDef);
            this.augmentTypeDefBaseSpecifics(typeDefNode, complexTypeDef);
            typeDefNode.add(new DefaultMutableTreeNode("isDerivationMethodExtension : " + complexTypeDef.isDerivationMethodExtension()));
            typeDefNode.add(new DefaultMutableTreeNode("isDerivationMethodRestriction : " + complexTypeDef.isDerivationMethodRestriction()));
            typeDefNode.add(new DefaultMutableTreeNode("isProhibitedSubstitutionExtension : " + complexTypeDef.isProhibitedSubstitutionExtension()));
            typeDefNode.add(new DefaultMutableTreeNode("isProhibitedSubstitutionRestriction : " + complexTypeDef.isProhibitedSubstitutionRestriction()));
            typeDefNode.add(new DefaultMutableTreeNode("isAbstract : " + complexTypeDef.isAbstract()));
            typeDefNode.add(this.createAttributeWildcardNode(complexTypeDef));
            typeDefNode.add(this.createAttributeUsesNode(complexTypeDef));
            typeDefNode.add(this.createSimpleContentTypeDefNode(complexTypeDef));
            typeDefNode.add(this.createContentTypeContentModelNode(complexTypeDef));
            typeDefNode.add(new DefaultMutableTreeNode("isContentTypeEmpty : " + complexTypeDef.isContentTypeEmpty()));
            typeDefNode.add(new DefaultMutableTreeNode("isMixed : " + complexTypeDef.isMixed()));
        }
        return typeDefNode;
    }

    private DefaultMutableTreeNode createContentTypeContentModelNode(ComplexTypeDefinitionImpl complTypeDef) {
        DefaultMutableTreeNode contentModelNode = new DefaultMutableTreeNode("content model");
        ParticleImpl particle = (ParticleImpl)complTypeDef.getContentTypeContentModel();
        if (particle != null) {
            contentModelNode.add(this.createParticleNode(particle));
        }
        return contentModelNode;
    }

    private DefaultMutableTreeNode createParticleNode(ParticleImpl particle) {
        DefaultMutableTreeNode particleNode = new DefaultMutableTreeNode("particle");
        this.augmentBaseSpecifics(particleNode, particle);
        particleNode.add(new DefaultMutableTreeNode("min occurs : " + particle.getMinOccurs()));
        particleNode.add(new DefaultMutableTreeNode("isMaxOccursUnbounded : " + particle.isMaxOccursUnbounded()));
        particleNode.add(new DefaultMutableTreeNode("max occurs : " + particle.getMaxOccurs()));
        particleNode.add(new DefaultMutableTreeNode("is emptiable : " + particle.isEmptiable()));
        particleNode.add(this.createTermNode((BaseImpl)particle.getTerm()));
        return particleNode;
    }

    private DefaultMutableTreeNode createTermNode(BaseImpl term) {
        DefaultMutableTreeNode termNode = new DefaultMutableTreeNode("term");
        if (term != null) {
            if (term instanceof ElementDeclarationImpl) {
                termNode.add(this.createElementDeclarationNode((ElementDeclarationImpl)term, false));
            } else if (term instanceof ModelGroupDefinitionImpl) {
                termNode.add(this.createModelGroupDefinitionNode((ModelGroupDefinitionImpl)term, false));
            } else if (term instanceof ModelGroupImpl) {
                termNode.add(this.createModelGroupNode((ModelGroupImpl)term));
            } else {
                termNode.add(this.createWildcardNode((WildcardImpl)term));
            }
        }
        return termNode;
    }

    private DefaultMutableTreeNode createModelGroupDefinitionNode(ModelGroupDefinitionImpl modelGroupDef, boolean displayIfTopLevel) {
        DefaultMutableTreeNode modelGroupDefNode = new DefaultMutableTreeNode("model group def " + modelGroupDef.toString());
        if (this.displayQBase(modelGroupDef, this.processedModelGroupCollector, displayIfTopLevel)) {
            this.registerQBase(modelGroupDef, this.processedModelGroupCollector);
            this.augmentBaseSpecifics(modelGroupDefNode, modelGroupDef);
            this.augmentQualifiedBaseSpecifics(modelGroupDefNode, modelGroupDef);
            ModelGroupImpl modelGroup = (ModelGroupImpl)modelGroupDef.getModelGroup();
            modelGroupDefNode.add(this.createModelGroupNode(modelGroup));
        }
        return modelGroupDefNode;
    }

    private DefaultMutableTreeNode createModelGroupNode(ModelGroupImpl modelGroup) {
        DefaultMutableTreeNode modelGroupNode = new DefaultMutableTreeNode("model group");
        this.augmentBaseSpecifics(modelGroupNode, modelGroup);
        modelGroupNode.add(new DefaultMutableTreeNode("isCompositorAll : " + modelGroup.isCompositorAll()));
        modelGroupNode.add(new DefaultMutableTreeNode("isCompositorChoice : " + modelGroup.isCompositorChoice()));
        modelGroupNode.add(new DefaultMutableTreeNode("isCompositorSequence : " + modelGroup.isCompositorSequence()));
        modelGroupNode.add(new DefaultMutableTreeNode("minimum effective total range : " + modelGroup.getMinimumEffectiveTotalRange()));
        modelGroupNode.add(new DefaultMutableTreeNode("maximum effective total range : " + modelGroup.getMaximumEffectiveTotalRange()));
        modelGroupNode.add(this.createParticlesNode(modelGroup));
        return modelGroupNode;
    }

    private DefaultMutableTreeNode createParticlesNode(ModelGroupImpl modelGroup) {
        DefaultMutableTreeNode particlesNode = new DefaultMutableTreeNode("particles");
        Vector collector = new Vector();
        modelGroup.getParticles(collector);
        int i = 0;
        while (i < collector.size()) {
            particlesNode.add(this.createParticleNode((ParticleImpl)collector.get(i)));
            ++i;
        }
        return particlesNode;
    }

    private DefaultMutableTreeNode createElementDeclarationNode(ElementDeclarationImpl elemDeclr, boolean displayIfTopLevel) {
        DefaultMutableTreeNode elemDeclrNode = new DefaultMutableTreeNode("elem declr " + elemDeclr.toString());
        if (this.displayQBase(elemDeclr, this.processedElemDeclrsCollector, displayIfTopLevel)) {
            this.registerQBase(elemDeclr, this.processedElemDeclrsCollector);
            this.augmentBaseSpecifics(elemDeclrNode, elemDeclr);
            this.augmentQualifiedBaseSpecifics(elemDeclrNode, elemDeclr);
            this.augmentItemDeclrBaseSpecifics(elemDeclrNode, elemDeclr);
            elemDeclrNode.add(new DefaultMutableTreeNode("isNillable : " + elemDeclr.isNillable()));
            elemDeclrNode.add(this.createIdentityConstriantDefinitionsNode(elemDeclr));
            elemDeclrNode.add(this.createSubstElementDeclarationsNode(elemDeclr));
            elemDeclrNode.add(this.createSubstElementDeclarationNode(elemDeclr));
            elemDeclrNode.add(new DefaultMutableTreeNode("isSubstitutionGroupExclusionExtension : " + elemDeclr.isSubstitutionGroupExclusionExtension()));
            elemDeclrNode.add(new DefaultMutableTreeNode("isSubstitutionGroupExclusionRestriction : " + elemDeclr.isSubstitutionGroupExclusionRestriction()));
            elemDeclrNode.add(new DefaultMutableTreeNode("isDisallowedSubstitutionSubstitution : " + elemDeclr.isDisallowedSubstitutionSubstitution()));
            elemDeclrNode.add(new DefaultMutableTreeNode("isDisallowedSubstitutionExtension : " + elemDeclr.isDisallowedSubstitutionExtension()));
            elemDeclrNode.add(new DefaultMutableTreeNode("isDisallowedSubstitutionRestriction : " + elemDeclr.isDisallowedSubstitutionRestriction()));
            elemDeclrNode.add(new DefaultMutableTreeNode("isAbstract : " + elemDeclr.isAbstract()));
        }
        return elemDeclrNode;
    }

    private DefaultMutableTreeNode createIdentityConstriantDefinitionsNode(ElementDeclarationImpl elemDeclr) {
        DefaultMutableTreeNode identCostrDefsNode = new DefaultMutableTreeNode("ident constr defs");
        Vector collector = new Vector();
        elemDeclr.getIdentityConstraintDefinitions(collector);
        int i = 0;
        while (i < collector.size()) {
            identCostrDefsNode.add(new DefaultMutableTreeNode("ident constr def " + collector.get(i).toString()));
            ++i;
        }
        return identCostrDefsNode;
    }

    private DefaultMutableTreeNode createSubstElementDeclarationsNode(ElementDeclarationImpl elemDeclr) {
        DefaultMutableTreeNode substElemDeclrsNode = new DefaultMutableTreeNode("subst elem declrs");
        Vector collector = new Vector();
        elemDeclr.getSubstitutableElementDeclarations(collector);
        int i = 0;
        while (i < collector.size()) {
            ElementDeclarationImpl substElemdEclr = (ElementDeclarationImpl)collector.get(i);
            substElemDeclrsNode.add(this.createElementDeclarationNode(substElemdEclr, false));
            ++i;
        }
        return substElemDeclrsNode;
    }

    private DefaultMutableTreeNode createSubstElementDeclarationNode(ElementDeclarationImpl elemDeclr) {
        DefaultMutableTreeNode substElemAffiliationNode = new DefaultMutableTreeNode("subst elem affiliation");
        ElementDeclarationImpl substElemDeclrAffiliation = (ElementDeclarationImpl)elemDeclr.getSubstitutionGroupAffiliation();
        if (substElemDeclrAffiliation != null) {
            substElemAffiliationNode.add(this.createElementDeclarationNode(substElemDeclrAffiliation, false));
        }
        return substElemAffiliationNode;
    }

    private DefaultMutableTreeNode createSimpleContentTypeDefNode(ComplexTypeDefinitionImpl complTypeDef) {
        DefaultMutableTreeNode simpleContentTypeNode = new DefaultMutableTreeNode("simple content");
        SimpleTypeDefinitionImpl simpleTypeDef = (SimpleTypeDefinitionImpl)complTypeDef.getContentTypeSimpleTypeDefinition();
        if (simpleTypeDef != null) {
            simpleContentTypeNode.add(this.createSimpleTypeDefinitionNode(simpleTypeDef, false));
        }
        return simpleContentTypeNode;
    }

    private DefaultMutableTreeNode createAttributeUsesNode(ComplexTypeDefinitionImpl complexTypeDef) {
        DefaultMutableTreeNode attribUsesNode = new DefaultMutableTreeNode("attrib uses");
        Vector collector = new Vector();
        complexTypeDef.getAttributeUses(collector);
        int i = 0;
        while (i < collector.size()) {
            AttributeUseImpl attribUse = (AttributeUseImpl)collector.get(i);
            attribUsesNode.add(this.createAttributeUseNode(attribUse));
            ++i;
        }
        return attribUsesNode;
    }

    private DefaultMutableTreeNode createAttributeUseNode(AttributeUseImpl attribUse) {
        DefaultMutableTreeNode attribUseNode = new DefaultMutableTreeNode("attrib use");
        this.augmentBaseSpecifics(attribUseNode, attribUse);
        attribUseNode.add(new DefaultMutableTreeNode("isRequired : " + attribUse.isRequired()));
        attribUseNode.add(new DefaultMutableTreeNode("isProhibited : " + attribUse.isProhibited()));
        attribUseNode.add(this.createAttributeDeclarationNode((AttributeDeclarationImpl)attribUse.getAttributeDeclaration(), false));
        attribUseNode.add(new DefaultMutableTreeNode("value constr default : " + attribUse.getValueConstraintDefault()));
        attribUseNode.add(new DefaultMutableTreeNode("value constr fixed : " + attribUse.getValueConstraintFixed()));
        return attribUseNode;
    }

    private DefaultMutableTreeNode createAttributeDeclarationNode(AttributeDeclarationImpl attribDeclr, boolean displayIfTopLevel) {
        DefaultMutableTreeNode attribDeclrNode = new DefaultMutableTreeNode("attrib declr " + attribDeclr.toString());
        if (this.displayQBase(attribDeclr, this.processedAttribDeclrsCollector, displayIfTopLevel)) {
            this.registerQBase(attribDeclr, this.processedAttribDeclrsCollector);
            this.augmentBaseSpecifics(attribDeclrNode, attribDeclr);
            this.augmentQualifiedBaseSpecifics(attribDeclrNode, attribDeclr);
            this.augmentItemDeclrBaseSpecifics(attribDeclrNode, attribDeclr);
        }
        return attribDeclrNode;
    }

    private void augmentItemDeclrBaseSpecifics(DefaultMutableTreeNode node, InfoItemDeclarationBaseImpl declrBase) {
        node.add(this.createInfoItemDeclrBaseTypeNode(declrBase));
        node.add(this.createInfoItemDeclrBaseScopeNode(declrBase));
        node.add(new DefaultMutableTreeNode("value constr default : " + declrBase.getValueConstraintDefault()));
        node.add(new DefaultMutableTreeNode("value constr fixed : " + declrBase.getValueConstraintFixed()));
    }

    private DefaultMutableTreeNode createInfoItemDeclrBaseTypeNode(InfoItemDeclarationBaseImpl declrBase) {
        DefaultMutableTreeNode typeNode = new DefaultMutableTreeNode("type");
        typeNode.add(this.createTypeDefinitionNode((TypeDefinitionBaseImpl)declrBase.getTypeDefinition(), false));
        return typeNode;
    }

    private DefaultMutableTreeNode createInfoItemDeclrBaseScopeNode(InfoItemDeclarationBaseImpl declrBase) {
        DefaultMutableTreeNode scopeNode = new DefaultMutableTreeNode("scope");
        ComplexTypeDefinitionImpl scopeType = (ComplexTypeDefinitionImpl)declrBase.getScope();
        if (scopeType != null) {
            scopeNode.add(this.createComplexTypeDefinitionNode(scopeType, false));
        }
        return scopeNode;
    }

    private DefaultMutableTreeNode createAttributeWildcardNode(ComplexTypeDefinitionImpl complexTypeDef) {
        DefaultMutableTreeNode attribWildcardNode = new DefaultMutableTreeNode("attrib wildcard");
        WildcardImpl attribWildcard = (WildcardImpl)complexTypeDef.getAttributeWildcard();
        if (attribWildcard != null) {
            attribWildcardNode.add(this.createWildcardNode(attribWildcard));
        }
        return attribWildcardNode;
    }

    private DefaultMutableTreeNode createWildcardNode(WildcardImpl wildcard) {
        DefaultMutableTreeNode wildcardNode = new DefaultMutableTreeNode("wildcard");
        this.augmentBaseSpecifics(wildcardNode, wildcard);
        wildcardNode.add(new DefaultMutableTreeNode("isProcessContentsSkip : " + wildcard.isProcessContentsSkip()));
        wildcardNode.add(new DefaultMutableTreeNode("isProcessContentsLax : " + wildcard.isProcessContentsLax()));
        wildcardNode.add(new DefaultMutableTreeNode("isProcessContentsStrict : " + wildcard.isProcessContentsStrict()));
        wildcardNode.add(new DefaultMutableTreeNode("isNamespaceConstraintAny : " + wildcard.isNamespaceConstraintAny()));
        wildcardNode.add(new DefaultMutableTreeNode("negated : " + wildcard.getNamespaceConstraintNegated()));
        wildcardNode.add(new DefaultMutableTreeNode("isAttribWildcard : " + wildcard.isAttribWildcard()));
        wildcardNode.add(this.createNsConstrMemebersNode(wildcard));
        return wildcardNode;
    }

    private DefaultMutableTreeNode createNsConstrMemebersNode(WildcardImpl wildcard) {
        DefaultMutableTreeNode nsConstrMemebersNode = new DefaultMutableTreeNode("ns constr members");
        Vector collector = new Vector();
        wildcard.getNamespaceConstraintMembers(collector);
        int i = 0;
        while (i < collector.size()) {
            nsConstrMemebersNode.add(new DefaultMutableTreeNode("ns : " + (String)collector.get(i)));
            ++i;
        }
        return nsConstrMemebersNode;
    }

    private DefaultMutableTreeNode createSimpleTypeDefinitionNode(SimpleTypeDefinitionImpl simpleTypeDef, boolean displayIfTopLevel) {
        DefaultMutableTreeNode typeDefNode = new DefaultMutableTreeNode("simple type def " + simpleTypeDef.toString());
        if (!simpleTypeDef.isBuiltIn() && this.displayQBase(simpleTypeDef, this.processedTypeDefsCollector, displayIfTopLevel)) {
            this.registerQBase(simpleTypeDef, this.processedTypeDefsCollector);
            this.augmentBaseSpecifics(typeDefNode, simpleTypeDef);
            this.augmentQualifiedBaseSpecifics(typeDefNode, simpleTypeDef);
            this.augmentTypeDefBaseSpecifics(typeDefNode, simpleTypeDef);
            typeDefNode.add(new DefaultMutableTreeNode("whiteSpaceNormal : " + simpleTypeDef.getWhiteSpaceNormalizationValue()));
            typeDefNode.add(new DefaultMutableTreeNode("isFinalList : " + simpleTypeDef.isFinalList()));
            typeDefNode.add(new DefaultMutableTreeNode("isFinalUnion : " + simpleTypeDef.isFinalUnion()));
            typeDefNode.add(new DefaultMutableTreeNode("isVarietyAtomic : " + simpleTypeDef.isVarietyAtomic()));
            typeDefNode.add(new DefaultMutableTreeNode("isVarietyList : " + simpleTypeDef.isVarietyList()));
            typeDefNode.add(new DefaultMutableTreeNode("isVarietyUnion : " + simpleTypeDef.isVarietyUnion()));
            typeDefNode.add(new DefaultMutableTreeNode("isPrimitive : " + simpleTypeDef.isPrimitive()));
            typeDefNode.add(this.createPrimitiveTypeDefNode(simpleTypeDef));
            typeDefNode.add(this.createItemTypeDefNode(simpleTypeDef));
            typeDefNode.add(this.createMemberTypeDefsNode(simpleTypeDef));
            typeDefNode.add(this.createFacetsNode(simpleTypeDef));
        }
        return typeDefNode;
    }

    private DefaultMutableTreeNode createFacetsNode(SimpleTypeDefinitionImpl simpleTypeDef) {
        DefaultMutableTreeNode facetsNode = new DefaultMutableTreeNode("facets");
        Vector collector = new Vector();
        simpleTypeDef.getFacets(collector);
        int i = 0;
        while (i < collector.size()) {
            FacetImpl facet = (FacetImpl)collector.get(i);
            facetsNode.add(this.createFacetNode(facet));
            ++i;
        }
        return facetsNode;
    }

    private DefaultMutableTreeNode createFacetNode(FacetImpl facet) {
        DefaultMutableTreeNode facetNode = new DefaultMutableTreeNode("facet");
        facetNode.add(new DefaultMutableTreeNode("name : " + facet.getName()));
        facetNode.add(new DefaultMutableTreeNode("value : " + facet.getValue()));
        facetNode.add(new DefaultMutableTreeNode("isFixed : " + facet.isFixed()));
        return facetNode;
    }

    private DefaultMutableTreeNode createMemberTypeDefsNode(SimpleTypeDefinitionImpl simpleTypeDef) {
        DefaultMutableTreeNode memberTypeDefsNode = new DefaultMutableTreeNode("member types");
        Vector collector = new Vector();
        simpleTypeDef.getMemberTypeDefinitions(collector);
        int i = 0;
        while (i < collector.size()) {
            SimpleTypeDefinitionImpl memberTypeDef = (SimpleTypeDefinitionImpl)collector.get(i);
            memberTypeDefsNode.add(this.createSimpleTypeDefinitionNode(memberTypeDef, false));
            ++i;
        }
        return memberTypeDefsNode;
    }

    private void augmentTypeDefBaseSpecifics(DefaultMutableTreeNode node, TypeDefinitionBaseImpl typeDef) {
        node.add(this.createBaseTypeNode(typeDef));
        node.add(new DefaultMutableTreeNode("isFinalExtension : " + typeDef.isFinalExtension()));
        node.add(new DefaultMutableTreeNode("isFinalRestriction : " + typeDef.isFinalRestriction()));
    }

    private DefaultMutableTreeNode createBaseTypeNode(TypeDefinitionBaseImpl typeDef) {
        TypeDefinitionBaseImpl baseTypeDef = (TypeDefinitionBaseImpl)typeDef.getBaseTypeDefinition();
        DefaultMutableTreeNode baseTypeDefNode = new DefaultMutableTreeNode("base");
        if (baseTypeDef != null) {
            baseTypeDefNode.add(this.createTypeDefinitionNode(baseTypeDef, false));
        }
        return baseTypeDefNode;
    }

    private DefaultMutableTreeNode createPrimitiveTypeDefNode(SimpleTypeDefinitionImpl typeDef) {
        TypeDefinitionBaseImpl primitiveTypeDef = (TypeDefinitionBaseImpl)((Object)typeDef.getPrimitiveTypeDefinition());
        DefaultMutableTreeNode primitiveTypeDefNode = new DefaultMutableTreeNode("primitive type def");
        if (primitiveTypeDef != null) {
            primitiveTypeDefNode.add(this.createTypeDefinitionNode(primitiveTypeDef, false));
        }
        return primitiveTypeDefNode;
    }

    private DefaultMutableTreeNode createItemTypeDefNode(SimpleTypeDefinitionImpl typeDef) {
        TypeDefinitionBaseImpl itemTypeDef = (TypeDefinitionBaseImpl)((Object)typeDef.getItemTypeDefinition());
        DefaultMutableTreeNode itemTypeDefNode = new DefaultMutableTreeNode("item type def");
        if (itemTypeDef != null) {
            itemTypeDefNode.add(this.createTypeDefinitionNode(itemTypeDef, false));
        }
        return itemTypeDefNode;
    }

    private DefaultMutableTreeNode createAttributeDeclarationsNode(SchemaImpl schema) {
        DefaultMutableTreeNode attributeDeclrsNode = new DefaultMutableTreeNode("attrib declrs");
        Vector collector = new Vector();
        schema.getTopLevelAttributeDeclarations(collector);
        int i = 0;
        while (i < collector.size()) {
            AttributeDeclarationImpl attribDeclr = (AttributeDeclarationImpl)collector.get(i);
            attributeDeclrsNode.add(this.createAttributeDeclarationNode(attribDeclr, true));
            ++i;
        }
        return attributeDeclrsNode;
    }

    private DefaultMutableTreeNode createElementDeclarationsNode(SchemaImpl schema) {
        DefaultMutableTreeNode elemsDeclrsNode = new DefaultMutableTreeNode("elem declrs");
        Vector collector = new Vector();
        schema.getTopLevelElementDeclarations(collector);
        int i = 0;
        while (i < collector.size()) {
            ElementDeclarationImpl elemDeclr = (ElementDeclarationImpl)collector.get(i);
            elemsDeclrsNode.add(this.createElementDeclarationNode(elemDeclr, true));
            ++i;
        }
        return elemsDeclrsNode;
    }

    private DefaultMutableTreeNode createAttributeGroupDefinitionsNode(SchemaImpl schema) {
        DefaultMutableTreeNode attribGroupDefsNode = new DefaultMutableTreeNode("attrib group defs");
        Vector collector = new Vector();
        schema.getTopLevelAttributeGroupDefinitions(collector);
        int i = 0;
        while (i < collector.size()) {
            AttributeGroupDefinitionImpl attribGroupDef = (AttributeGroupDefinitionImpl)collector.get(i);
            attribGroupDefsNode.add(this.createAttributeGroupDefinitionNode(attribGroupDef, true));
            ++i;
        }
        return attribGroupDefsNode;
    }

    private DefaultMutableTreeNode createAttributeGroupDefinitionNode(AttributeGroupDefinitionImpl attribGroupDef, boolean displayIfTopLevel) {
        DefaultMutableTreeNode attribGroupDefsNode = new DefaultMutableTreeNode("attrib group def " + attribGroupDef.toString());
        if (this.displayQBase(attribGroupDef, this.processedAttribGropDefsCollector, displayIfTopLevel)) {
            this.registerQBase(attribGroupDef, this.processedAttribGropDefsCollector);
            this.augmentBaseSpecifics(attribGroupDefsNode, attribGroupDef);
            this.augmentQualifiedBaseSpecifics(attribGroupDefsNode, attribGroupDef);
            attribGroupDefsNode.add(this.createAttributeWildcardNode(attribGroupDef));
            attribGroupDefsNode.add(this.createAttributeUsesNode(attribGroupDef));
        }
        return attribGroupDefsNode;
    }

    private DefaultMutableTreeNode createAttributeWildcardNode(AttributeGroupDefinitionImpl attribGroupDef) {
        DefaultMutableTreeNode attribWildcardNode = new DefaultMutableTreeNode("attrib wildcard");
        WildcardImpl attribWildcard = (WildcardImpl)attribGroupDef.getAttributeWildcard();
        if (attribWildcard != null) {
            attribWildcardNode.add(this.createWildcardNode(attribWildcard));
        }
        return attribWildcardNode;
    }

    private DefaultMutableTreeNode createAttributeUsesNode(AttributeGroupDefinitionImpl attribGroupDef) {
        DefaultMutableTreeNode attribUsesNode = new DefaultMutableTreeNode("attrib uses");
        Vector collector = new Vector();
        attribGroupDef.getAttributeUses(collector);
        int i = 0;
        while (i < collector.size()) {
            AttributeUseImpl attribUse = (AttributeUseImpl)collector.get(i);
            attribUsesNode.add(this.createAttributeUseNode(attribUse));
            ++i;
        }
        return attribUsesNode;
    }

    private DefaultMutableTreeNode createModelGroupDefinitionsNode(SchemaImpl schema) {
        DefaultMutableTreeNode modelGroupDefsNode = new DefaultMutableTreeNode("model group defs");
        Vector collector = new Vector();
        schema.getTopLevelModelGroupDefinitions(collector);
        int i = 0;
        while (i < collector.size()) {
            ModelGroupDefinitionImpl modelGroupDef = (ModelGroupDefinitionImpl)collector.get(i);
            modelGroupDefsNode.add(this.createModelGroupDefinitionNode(modelGroupDef, true));
            ++i;
        }
        return modelGroupDefsNode;
    }

    private DefaultMutableTreeNode createNotationDeclarationsNode(SchemaImpl schema) {
        DefaultMutableTreeNode notationDeclrsNode = new DefaultMutableTreeNode("notation declrs");
        Vector collector = new Vector();
        schema.getTopLevelNotationDeclarations(collector);
        int i = 0;
        while (i < collector.size()) {
            NotationDeclarationImpl notationDeclr = (NotationDeclarationImpl)collector.get(i);
            notationDeclrsNode.add(this.createNotationDeclrationNode(notationDeclr));
            ++i;
        }
        return notationDeclrsNode;
    }

    private DefaultMutableTreeNode createNotationDeclrationNode(NotationDeclarationImpl notationDeclr) {
        DefaultMutableTreeNode notationDeclrNode = new DefaultMutableTreeNode("notation declr " + notationDeclr.toString());
        if (this.displayQBase(notationDeclr, this.processedNotationDEclrsCollector, true)) {
            this.registerQBase(notationDeclr, this.processedNotationDEclrsCollector);
            this.augmentBaseSpecifics(notationDeclrNode, notationDeclr);
            this.augmentQualifiedBaseSpecifics(notationDeclrNode, notationDeclr);
            notationDeclrNode.add(new DefaultMutableTreeNode("system identifier : " + notationDeclr.getSystemIdentifier()));
            notationDeclrNode.add(new DefaultMutableTreeNode("public identifier : " + notationDeclr.getPublicIdentifier()));
        }
        return notationDeclrNode;
    }

    private DefaultMutableTreeNode createAllComponentsNode(SchemaImpl schema) {
        DefaultMutableTreeNode allComponentsNode = new DefaultMutableTreeNode("all components");
        Vector collector = new Vector();
        schema.getAllComponents(collector);
        int i = 0;
        while (i < collector.size()) {
            BaseImpl base = (BaseImpl)collector.get(i);
            allComponentsNode.add(this.createBaseNode(base));
            ++i;
        }
        return allComponentsNode;
    }

    private DefaultMutableTreeNode createBaseNode(BaseImpl base) {
        if (base instanceof NotationDeclarationImpl) {
            return this.createNotationDeclrationNode((NotationDeclarationImpl)base);
        }
        if (base instanceof SimpleTypeDefinitionImpl) {
            return this.createSimpleTypeDefinitionNode((SimpleTypeDefinitionImpl)base, false);
        }
        if (base instanceof ComplexTypeDefinitionImpl) {
            return this.createComplexTypeDefinitionNode((ComplexTypeDefinitionImpl)base, false);
        }
        if (base instanceof ModelGroupDefinitionImpl) {
            return this.createModelGroupDefinitionNode((ModelGroupDefinitionImpl)base, false);
        }
        if (base instanceof AttributeGroupDefinitionImpl) {
            return this.createAttributeGroupDefinitionNode((AttributeGroupDefinitionImpl)base, false);
        }
        if (base instanceof ElementDeclarationImpl) {
            return this.createElementDeclarationNode((ElementDeclarationImpl)base, false);
        }
        return this.createAttributeDeclarationNode((AttributeDeclarationImpl)base, false);
    }

    private DefaultMutableTreeNode createImportedSchemasNode(SchemaImpl schema) {
        DefaultMutableTreeNode importedSchemasNode = new DefaultMutableTreeNode("imported schemas");
        Vector importedSchemasCollector = schema.getImportedSchemas();
        int i = 0;
        while (i < importedSchemasCollector.size()) {
            importedSchemasNode.add(this.createSchemaNode((SchemaImpl)importedSchemasCollector.get(i)));
            ++i;
        }
        return importedSchemasNode;
    }

    private DefaultMutableTreeNode createImportedSchema(SchemaImpl schema) {
        DefaultMutableTreeNode importedSchemaNode = new DefaultMutableTreeNode("{" + schema.getTargetNamespace() + "} : " + schema.getLocation());
        importedSchemaNode.add(this.createSchemaNode(schema));
        return importedSchemaNode;
    }

    private DefaultMutableTreeNode createIncludedSchemasNode(SchemaImpl schema) {
        DefaultMutableTreeNode includedSchemasNode = new DefaultMutableTreeNode("included schemas");
        Vector includedSchemasCollector = schema.getIncludedSchemas();
        int i = 0;
        while (i < includedSchemasCollector.size()) {
            SchemaImpl includedSchema = (SchemaImpl)includedSchemasCollector.get(i);
            includedSchemasNode.add(this.createSchemaNode(includedSchema));
            ++i;
        }
        return includedSchemasNode;
    }
}

