/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.Facet;
import com.sap.engine.lib.schema.components.FundamentalFacets;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.impl.ffacets.FundamentalFacetsList;
import com.sap.engine.lib.schema.components.impl.ffacets.FundamentalFacetsUnion;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.FacetImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.components.impl.structures.TypeDefinitionBaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SimpleTypeDefinitionImpl
extends TypeDefinitionBaseImpl
implements SimpleTypeDefinition {
    protected static final int ATOMIC = 1;
    protected static final int LIST = 2;
    protected static final int UNION = 3;
    protected static final int UNKNOWN = 0;
    protected int variety;
    protected SimpleTypeDefinitionImpl primitiveTypeDefinition;
    protected SimpleTypeDefinitionImpl itemTypeDefinition;
    protected Vector memberTypeDefsCollector = new Vector();
    protected Vector facetsCollector = new Vector();
    protected FundamentalFacets fundamentalFacets;
    protected boolean isPrimitive;
    protected boolean isFinalList;
    protected boolean isFinalUnion;
    protected String whiteSpaceNormalizationValue;

    public SimpleTypeDefinitionImpl() {
        this(null, null, false, false);
    }

    public SimpleTypeDefinitionImpl(Node associatedNode, SchemaImpl schema, boolean isTopLevel, boolean isRedefined) {
        super(associatedNode, schema, isTopLevel, isRedefined);
    }

    @Override
    public String getWhiteSpaceNormalizationValue() {
        return this.whiteSpaceNormalizationValue;
    }

    @Override
    public int getTypeOfComponent() {
        return 2;
    }

    @Override
    public SimpleTypeDefinition getBaseTypeDefinitionSimple() {
        if (this.baseTypeDefinition instanceof SimpleTypeDefinition) {
            return (SimpleTypeDefinition)((Object)this.baseTypeDefinition);
        }
        return null;
    }

    @Override
    public boolean isFinalList() {
        return this.isFinalList;
    }

    @Override
    public boolean isFinalUnion() {
        return this.isFinalUnion;
    }

    @Override
    public boolean isVarietyAtomic() {
        return this.variety == 1;
    }

    @Override
    public boolean isVarietyList() {
        return this.variety == 2;
    }

    @Override
    public boolean isVarietyUnion() {
        return this.variety == 3;
    }

    @Override
    public SimpleTypeDefinition getPrimitiveTypeDefinition() {
        return this.primitiveTypeDefinition;
    }

    @Override
    public SimpleTypeDefinition getItemTypeDefinition() {
        return this.itemTypeDefinition;
    }

    @Override
    public void getMemberTypeDefinitions(Vector collector) {
        Tools.removeFromVectorToVector(this.memberTypeDefsCollector, collector);
    }

    @Override
    public Vector getMemberTypeDefinitions() {
        return this.memberTypeDefsCollector;
    }

    @Override
    public Vector getFacets() {
        return this.facetsCollector;
    }

    @Override
    public void getFacets(Vector collector) {
        Tools.removeFromVectorToVector(this.facetsCollector, collector);
    }

    @Override
    public Facet[] getFacetsArray() {
        Object[] result = new Facet[this.facetsCollector.size()];
        this.facetsCollector.copyInto(result);
        return result;
    }

    @Override
    public FundamentalFacets getFundamentalFacets() {
        return this.fundamentalFacets;
    }

    @Override
    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    @Override
    public boolean match(Base simpleTypeDef) {
        if (!super.match(simpleTypeDef)) {
            return false;
        }
        SimpleTypeDefinitionImpl targetSimpleTypeDef = (SimpleTypeDefinitionImpl)simpleTypeDef;
        if (this.isBuiltIn) {
            return targetSimpleTypeDef.isBuiltIn;
        }
        return Tools.compareUnorderedBases(this.facetsCollector, targetSimpleTypeDef.facetsCollector) && this.isFinalExtension == targetSimpleTypeDef.isFinalExtension && this.isFinalRestriction == targetSimpleTypeDef.isFinalRestriction && this.isFinalList == targetSimpleTypeDef.isFinalList && this.isFinalUnion == targetSimpleTypeDef.isFinalUnion && this.variety == targetSimpleTypeDef.variety && Tools.compareBases(this.primitiveTypeDefinition, targetSimpleTypeDef.primitiveTypeDefinition) && Tools.compareBases(this.itemTypeDefinition, targetSimpleTypeDef.itemTypeDefinition) && Tools.compareUnorderedBases(this.memberTypeDefsCollector, targetSimpleTypeDef.memberTypeDefsCollector);
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            String finalAttribValue = this.loadAttribsCollector.getProperty("final");
            if (finalAttribValue != null) {
                if (finalAttribValue.equals("#all")) {
                    this.isFinalExtension = true;
                    this.isFinalRestriction = true;
                    this.isFinalList = true;
                    this.isFinalUnion = true;
                } else if (finalAttribValue.equals("list")) {
                    this.isFinalList = true;
                } else if (finalAttribValue.equals("union")) {
                    this.isFinalUnion = true;
                } else if (finalAttribValue.equals("restriction")) {
                    this.isFinalRestriction = true;
                }
            } else {
                this.isFinalExtension = this.schema.isFinalExtension();
                this.isFinalRestriction = this.schema.isFinalRestriction();
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("restriction")) {
                        this.loadRestriction(node);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresLoader.createAnnotation(node, this.schema);
                        SchemaStructuresLoader.loadBase(this.annotation);
                    } else if (nodeLocalName.equals("list")) {
                        this.loadList(node);
                    } else if (nodeLocalName.equals("union")) {
                        this.loadUnion(node);
                    }
                }
                ++i;
            }
            this.schema.addComponent(this);
        }
    }

    private void loadRestriction(Node node) throws SchemaComponentException {
        NamedNodeMap attribs = node.getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            Node attrib = attribs.item(i);
            String attribName = attrib.getLocalName();
            String uri = attrib.getNamespaceURI();
            String value = attrib.getNodeValue();
            if ((uri == null || uri.equals("")) && attribName.equals("base")) {
                this.initBase((TypeDefinitionBaseImpl)Tools.getTopLevelComponent(this.schema, node, value, "TD"));
            }
            ++i;
        }
        NodeList childNodes = node.getChildNodes();
        boolean removeEnumerationFacets = true;
        boolean removePatternFacets = true;
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            if (childNode.getNodeType() == 1) {
                String uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                    if (elemName.equals("simpleType")) {
                        if (this.baseTypeDefinition != null) {
                            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of simple type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <restriction> alternative is chosen, it must have a base [attribute] or a <simpleType> among its [children], but not both.");
                        }
                        this.initBase(SchemaStructuresLoader.createSimpleTypeDefinition(childNode, this.schema, false, false));
                    } else if (elemName.equals("minExclusive") || elemName.equals("minInclusive") || elemName.equals("maxExclusive") || elemName.equals("maxInclusive") || elemName.equals("totalDigits") || elemName.equals("fractionDigits") || elemName.equals("length") || elemName.equals("minLength") || elemName.equals("maxLength") || elemName.equals("enumeration") || elemName.equals("whiteSpace") || elemName.equals("pattern")) {
                        FacetImpl restrictedFacet = SchemaStructuresLoader.createFacet(childNode, this.schema);
                        SchemaStructuresLoader.loadBase(restrictedFacet);
                        this.addRestrictedFacet(restrictedFacet, removeEnumerationFacets, removePatternFacets);
                        removeEnumerationFacets = !elemName.equals("enumeration");
                        removePatternFacets = !elemName.equals("pattern");
                    }
                }
            }
            ++j;
        }
    }

    private void initBase(TypeDefinitionBaseImpl typeDefBase) throws SchemaComponentException {
        if (!(typeDefBase instanceof SimpleTypeDefinitionImpl)) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of simple type " + DOM.toXPath(this.associatedNode) + " is not corect. The base type definition must be a simple type.");
        }
        this.baseTypeDefinition = typeDefBase;
        SchemaStructuresLoader.loadBase(this.baseTypeDefinition);
        SimpleTypeDefinitionImpl baseTypeDef = (SimpleTypeDefinitionImpl)this.baseTypeDefinition;
        this.facetsCollector.addAll(baseTypeDef.facetsCollector);
        this.fundamentalFacets = baseTypeDef.fundamentalFacets;
        this.variety = baseTypeDef.variety;
        this.whiteSpaceNormalizationValue = baseTypeDef.whiteSpaceNormalizationValue;
        if (baseTypeDef.isFinalRestriction) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. The {final} of the base type definition must not contain 'restriction'.");
        }
        if (this.variety == 1) {
            this.primitiveTypeDefinition = baseTypeDef.primitiveTypeDefinition;
        } else if (this.variety == 2) {
            if (baseTypeDef.isFinalList) {
                throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is 'list', then the {final} of the base type definition must not contain 'list'.");
            }
            this.itemTypeDefinition = baseTypeDef.itemTypeDefinition;
        } else {
            if (baseTypeDef.isFinalUnion) {
                throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is 'union', then the {final} of the base type definition must not contain 'union'.");
            }
            this.memberTypeDefsCollector.addAll(baseTypeDef.memberTypeDefsCollector);
        }
    }

    private void loadList(Node node) throws SchemaComponentException {
        String uri;
        NamedNodeMap attribs = node.getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            Node attrib = attribs.item(i);
            String attrName = attrib.getLocalName();
            uri = attrib.getNamespaceURI();
            String value = attrib.getNodeValue();
            if ((uri == null || uri.equals("")) && attrName.equals("itemType")) {
                this.initItemTypeDefinition((TypeDefinitionBaseImpl)Tools.getTopLevelComponent(this.schema, node, value, "TD"));
            }
            ++i;
        }
        NodeList childNodes = node.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            if (childNode.getNodeType() == 1) {
                uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema") && elemName.equals("simpleType")) {
                    if (this.itemTypeDefinition != null) {
                        throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of simple type " + DOM.toXPath(this.associatedNode) + " is not correct. If the <list> alternative is chosen, it must have an <itemType> [attribute] or a <simpleType> among its [children], but not both.");
                    }
                    this.initItemTypeDefinition(SchemaStructuresLoader.createSimpleTypeDefinition(childNode, this.schema, false, false));
                }
            }
            ++j;
        }
        this.whiteSpaceNormalizationValue = "collapse";
        this.baseTypeDefinition = (SimpleTypeDefinitionImpl)this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anySimpleType");
        this.variety = 2;
        this.fundamentalFacets = FundamentalFacetsList.newInstance();
    }

    private void loadUnion(Node node) throws SchemaComponentException {
        String uri;
        NamedNodeMap attribs = node.getAttributes();
        int i = 0;
        while (i < attribs.getLength()) {
            Node attrib = attribs.item(i);
            String attribName = attrib.getLocalName();
            uri = attrib.getNamespaceURI();
            String value = attrib.getNodeValue();
            if ((uri == null || uri.equals("")) && attribName.equals("memberTypes")) {
                StringTokenizer tokenizer = new StringTokenizer(value);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    TypeDefinitionBaseImpl typeDefBase = (TypeDefinitionBaseImpl)Tools.getTopLevelComponent(this.schema, node, token, "TD");
                    this.initMemeberTypeDefinition(typeDefBase);
                }
            }
            ++i;
        }
        NodeList childNodes = node.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node childNode = childNodes.item(j);
            if (childNode.getNodeType() == 1) {
                uri = childNode.getNamespaceURI();
                String elemName = childNode.getLocalName();
                if (uri.equals("http://www.w3.org/2001/XMLSchema") && elemName.equals("simpleType")) {
                    this.initMemeberTypeDefinition(SchemaStructuresLoader.createSimpleTypeDefinition(childNode, this.schema, false, false));
                }
            }
            ++j;
        }
        this.baseTypeDefinition = (SimpleTypeDefinitionImpl)this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anySimpleType");
        this.variety = 3;
        this.fundamentalFacets = FundamentalFacetsUnion.newInstance();
    }

    private void initItemTypeDefinition(TypeDefinitionBaseImpl itemTypeDef) throws SchemaComponentException {
        if (!(itemTypeDef instanceof SimpleTypeDefinitionImpl)) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of simple type " + DOM.toXPath(this.associatedNode) + " is not correct. The item type definition must be a simple type definition.");
        }
        this.itemTypeDefinition = (SimpleTypeDefinitionImpl)itemTypeDef;
        SchemaStructuresLoader.loadBase(this.itemTypeDefinition);
        if (this.itemTypeDefinition.isFinalList) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. The item type definition must not have {final} property set to 'list'.");
        }
        if (this.itemTypeDefinition.variety == 2) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. The item type definition must have a {variety} of atomic or 'union'.");
        }
        if (this.itemTypeDefinition.variety == 3) {
            int i = 0;
            while (i < this.itemTypeDefinition.memberTypeDefsCollector.size()) {
                SimpleTypeDefinitionImpl memberTypeDef = (SimpleTypeDefinitionImpl)this.itemTypeDefinition.memberTypeDefsCollector.get(i);
                if (memberTypeDef.variety != 1) {
                    throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. The item type definition must have a {variety} of atomic or union(in which case all the {member type definitions} must be atomic).");
                }
                ++i;
            }
        }
    }

    private void initMemeberTypeDefinition(TypeDefinitionBaseImpl memberTypeDef) throws SchemaComponentException {
        if (!(memberTypeDef instanceof SimpleTypeDefinitionImpl)) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Definition of simple type " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is union, then each member type definition must be a simple type definition.");
        }
        SimpleTypeDefinitionImpl memberSimpleTypeDef = (SimpleTypeDefinitionImpl)memberTypeDef;
        SchemaStructuresLoader.loadBase(memberSimpleTypeDef);
        if (memberSimpleTypeDef.variety == 3) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is union, then the member type definitions must all have {variety} of 'atomic' or 'list'.");
        }
        if (memberSimpleTypeDef.isFinalUnion) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is union, then any of the member type definitions must not have {final} set to 'union'.");
        }
        this.memberTypeDefsCollector.add(memberTypeDef);
    }

    @Override
    public boolean isDerivedFrom(TypeDefinitionBase typeDefinition, boolean disallowedRestriction, boolean disallowedExtension) {
        TypeDefinitionBaseImpl typeDefBase = (TypeDefinitionBaseImpl)typeDefinition;
        if (typeDefBase == null) {
            return false;
        }
        if (typeDefBase.isUrType) {
            return true;
        }
        if (this == typeDefBase || this.match(typeDefBase)) {
            return true;
        }
        if (disallowedRestriction) {
            return false;
        }
        if (!this.baseTypeDefinition.isUrType) {
            return this.baseTypeDefinition.isDerivedFrom(typeDefBase, disallowedRestriction, disallowedExtension);
        }
        if (typeDefBase instanceof SimpleTypeDefinitionImpl) {
            SimpleTypeDefinitionImpl simpleTypeDef = (SimpleTypeDefinitionImpl)typeDefBase;
            if (simpleTypeDef.variety == 3) {
                int i = 0;
                while (i < simpleTypeDef.memberTypeDefsCollector.size()) {
                    SimpleTypeDefinitionImpl memberTypeDef = (SimpleTypeDefinitionImpl)simpleTypeDef.memberTypeDefsCollector.get(i);
                    if (this.isDerivedFrom(memberTypeDef, disallowedRestriction, disallowedExtension)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    protected void addRestrictedFacet(FacetImpl facet, boolean removeEnumerationFactes, boolean removePatternFacets) throws SchemaComponentException {
        if (!(this.variety != 2 || facet.facetName.equals("length") || facet.facetName.equals("minLength") || facet.facetName.equals("maxLength") || facet.facetName.equals("pattern") || facet.facetName.equals("enumeration"))) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is list, then only length, minLength, maxLength, pattern and enumeration facet components are allowed among the {facets}.");
        }
        if (this.variety == 3 && !facet.facetName.equals("pattern") && !facet.facetName.equals("enumeration")) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : Simple type definition " + DOM.toXPath(this.associatedNode) + " is not correct. If the {variety} is union, then only pattern and enumeration facet components are allowed among the {facets}.");
        }
        if (facet.facetName.equals("pattern")) {
            if (removePatternFacets) {
                int i = 0;
                while (i < this.facetsCollector.size()) {
                    FacetImpl includedFacet = (FacetImpl)this.facetsCollector.get(i);
                    if (includedFacet.facetName.equals("pattern")) {
                        this.facetsCollector.remove(i);
                    }
                    ++i;
                }
            }
        } else if (facet.facetName.equals("enumeration")) {
            if (removeEnumerationFactes) {
                int i = 0;
                while (i < this.facetsCollector.size()) {
                    FacetImpl includedFacet = (FacetImpl)this.facetsCollector.get(i);
                    if (includedFacet.facetName.equals("enumeration")) {
                        this.facetsCollector.remove(i);
                    }
                    ++i;
                }
            }
        } else {
            if (facet.facetName.equals("whiteSpace")) {
                this.whiteSpaceNormalizationValue = facet.valueString;
            }
            int i = 0;
            while (i < this.facetsCollector.size()) {
                FacetImpl includedFacet = (FacetImpl)this.facetsCollector.get(i);
                if (includedFacet.facetName.equals(facet.facetName)) {
                    this.facetsCollector.set(i, facet);
                    return;
                }
                ++i;
            }
        }
        if (!this.isBuiltIn && facet.facetName.equals("enumeration") && ((SimpleTypeDefinitionImpl)this.baseTypeDefinition).primitiveTypeDefinition == this.schema.getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "NOTATION")) {
            Tools.getTopLevelComponent(this.schema, facet.getAssociatedDOMNode(), facet.getValue(), "ND");
        }
        this.facetsCollector.add(facet);
    }

    @Override
    public BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        SimpleTypeDefinitionImpl result = (SimpleTypeDefinitionImpl)super.initializeBase(base, clonedCollector);
        result.variety = this.variety;
        result.primitiveTypeDefinition = this.primitiveTypeDefinition;
        if (this.itemTypeDefinition != null) {
            result.itemTypeDefinition = this.itemTypeDefinition.isBuiltIn ? this.itemTypeDefinition : (SimpleTypeDefinitionImpl)this.itemTypeDefinition.clone(clonedCollector);
        }
        Tools.cloneVectorWithBases(this.memberTypeDefsCollector, result.memberTypeDefsCollector, clonedCollector);
        Tools.cloneVectorWithBases(this.facetsCollector, result.facetsCollector, clonedCollector);
        result.fundamentalFacets = this.fundamentalFacets;
        result.isPrimitive = this.isPrimitive;
        result.isFinalList = this.isFinalList;
        result.isFinalUnion = this.isFinalUnion;
        result.whiteSpaceNormalizationValue = this.whiteSpaceNormalizationValue;
        return result;
    }
}

