/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.components.impl.structures.SchemaStructuresLoader;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WildcardImpl
extends BaseImpl
implements Wildcard {
    protected static final int SKIP = 0;
    protected static final int LAX = 1;
    protected static final int STRICT = 2;
    protected int processContents;
    protected boolean anyNamespace = false;
    protected boolean negateTargetNamespace = false;
    protected String negatedNamespace;
    protected Vector constraintNamespaces = new Vector();
    protected boolean isAttribWildcard = false;
    protected boolean negateOther = false;
    private int targetNamespacePosition = -1;

    public WildcardImpl() {
        this(null);
    }

    public WildcardImpl(SchemaImpl schema) {
        this(null, schema);
    }

    public WildcardImpl(Node associatedNode, SchemaImpl schema) {
        super(associatedNode, schema);
    }

    @Override
    public int getTypeOfComponent() {
        return 10;
    }

    @Override
    public boolean isProcessContentsSkip() {
        return this.processContents == 0;
    }

    @Override
    public boolean isProcessContentsLax() {
        return this.processContents == 1;
    }

    @Override
    public boolean isProcessContentsStrict() {
        return this.processContents == 2;
    }

    @Override
    public boolean isNamespaceConstraintAny() {
        return this.anyNamespace;
    }

    @Override
    public String getNamespaceConstraintNegated() {
        if (this.negateTargetNamespace) {
            return this.schema.getTargetNamespace();
        }
        return this.negatedNamespace;
    }

    @Override
    public boolean isAttribWildcard() {
        return this.isAttribWildcard;
    }

    @Override
    public String[] getNamespaceConstraintMembersAsArray() {
        String[] namespaceMemebers = new String[this.constraintNamespaces.size()];
        int i = 0;
        while (i < this.constraintNamespaces.size()) {
            namespaceMemebers[i] = ((Namespace)this.constraintNamespaces.get(i)).getNamespace();
            ++i;
        }
        return namespaceMemebers;
    }

    @Override
    public void getNamespaceConstraintMembers(Vector collector) {
        int i = 0;
        while (i < this.constraintNamespaces.size()) {
            collector.add(((Namespace)this.constraintNamespaces.get(i)).getNamespace());
            ++i;
        }
    }

    @Override
    public boolean match(Base wildcard) {
        if (!super.match(wildcard)) {
            return false;
        }
        WildcardImpl targetWildcard = (WildcardImpl)wildcard;
        boolean result = this.processContents == targetWildcard.processContents && this.equalNamespaceConstraint(targetWildcard);
        return result;
    }

    private boolean equalNamespaceConstraint(WildcardImpl wildcard) {
        if (this.anyNamespace != wildcard.anyNamespace) {
            return false;
        }
        if (!Tools.compareObjects(this.getNamespaceConstraintNegated(), wildcard.getNamespaceConstraintNegated())) {
            return false;
        }
        return Tools.compareUnorderedObjects(this.constraintNamespaces, wildcard.constraintNamespaces);
    }

    @Override
    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.isAttribWildcard = this.associatedNode.getLocalName().equals("anyAttribute");
            this.id = this.loadAttribsCollector.getProperty("id");
            String namespaceAttribValue = this.loadAttribsCollector.getProperty("namespace");
            if (namespaceAttribValue != null) {
                if (namespaceAttribValue.equals("##any")) {
                    this.anyNamespace = true;
                } else if (namespaceAttribValue.equals("##other")) {
                    this.negateTargetNamespace = true;
                    this.negateOther = true;
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(namespaceAttribValue);
                    while (tokenizer.hasMoreElements()) {
                        String token = tokenizer.nextToken();
                        Namespace constraintNamespace = null;
                        if (token.equals("##targetNamespace")) {
                            constraintNamespace = new ConstraintTargetNamespace();
                            this.targetNamespacePosition = this.constraintNamespaces.size();
                        } else if (token.equals("##local")) {
                            constraintNamespace = new ConstraintNamespace("");
                        } else if (token.equals("not")) {
                            this.negatedNamespace = "";
                            while (tokenizer.hasMoreElements()) {
                                this.negatedNamespace = String.valueOf(this.negatedNamespace) + tokenizer.nextToken();
                            }
                        } else {
                            constraintNamespace = new ConstraintNamespace(token);
                        }
                        if (constraintNamespace == null) continue;
                        this.constraintNamespaces.add(constraintNamespace);
                    }
                }
            } else {
                this.anyNamespace = true;
            }
            String processContentsAttribValue = this.loadAttribsCollector.getProperty("processContents");
            if (processContentsAttribValue != null) {
                if (processContentsAttribValue.equals("lax")) {
                    this.processContents = 1;
                } else if (processContentsAttribValue.equals("skip")) {
                    this.processContents = 0;
                } else if (processContentsAttribValue.equals("strict")) {
                    this.processContents = 2;
                }
            } else {
                this.processContents = 2;
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeLocalName;
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema") && (nodeLocalName = node.getLocalName()).equals("annotation")) {
                    this.annotation = SchemaStructuresLoader.createAnnotation(node, this.schema);
                    SchemaStructuresLoader.loadBase(this.annotation);
                }
                ++i;
            }
        }
    }

    protected void intersect(WildcardImpl intersectionWildcard) throws SchemaComponentException {
        String negatedNamespace = this.getNamespaceConstraintNegated();
        String intersectionNegatedNamespace = intersectionWildcard.getNamespaceConstraintNegated();
        if (negatedNamespace != null && intersectionNegatedNamespace != null && !negatedNamespace.equals(intersectionNegatedNamespace)) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : The intersection of wildcard " + DOM.toXPath(this.associatedNode) + " with widcard " + DOM.toXPath(intersectionWildcard.associatedNode) + " is not expressible.");
        }
        if (intersectionWildcard.constraintNamespaces.size() != 0 && this.anyNamespace) {
            this.anyNamespace = false;
            this.constraintNamespaces.addAll(intersectionWildcard.constraintNamespaces);
            return;
        }
        if (intersectionWildcard.constraintNamespaces.size() != 0 && negatedNamespace != null) {
            this.constraintNamespaces.addAll(intersectionWildcard.constraintNamespaces);
            this.constraintNamespaces.remove(new ConstraintNamespace(negatedNamespace));
            this.negateTargetNamespace = false;
            negatedNamespace = null;
            return;
        }
        if (intersectionNegatedNamespace != null && this.constraintNamespaces.size() != 0) {
            this.constraintNamespaces.remove(new ConstraintNamespace(intersectionNegatedNamespace));
            return;
        }
        if (intersectionWildcard.constraintNamespaces.size() != 0 && this.constraintNamespaces.size() != 0) {
            int index = 0;
            while (index != this.constraintNamespaces.size()) {
                Object constraintNamespace = this.constraintNamespaces.get(index);
                if (!intersectionWildcard.constraintNamespaces.contains(constraintNamespace)) {
                    this.constraintNamespaces.remove(index);
                    continue;
                }
                ++index;
            }
        }
    }

    protected void unite(WildcardImpl unitiveWildcard) throws SchemaComponentException {
        String negatedNamespace = this.getNamespaceConstraintNegated();
        String unitiveNegatedNamespace = unitiveWildcard.getNamespaceConstraintNegated();
        if (negatedNamespace != null && unitiveNegatedNamespace != null && !negatedNamespace.equals(unitiveNegatedNamespace)) {
            throw new SchemaComponentException("[location : '" + this.schema.getLocation() + "'] ERROR : The unification of wildcard " + DOM.toXPath(this.associatedNode) + " with wildcard " + DOM.toXPath(unitiveWildcard.associatedNode) + " is not expressible.");
        }
        if (this.constraintNamespaces.size() != 0 && unitiveWildcard.constraintNamespaces.size() != 0) {
            int i = 0;
            while (i < unitiveWildcard.constraintNamespaces.size()) {
                Object constraintNamespace = unitiveWildcard.constraintNamespaces.get(i);
                if (!this.constraintNamespaces.contains(constraintNamespace)) {
                    this.constraintNamespaces.add(constraintNamespace);
                }
                ++i;
            }
            return;
        }
        if (negatedNamespace != null && unitiveWildcard.constraintNamespaces.size() != 0) {
            if (unitiveWildcard.constraintNamespaces.contains(new ConstraintNamespace(negatedNamespace))) {
                this.constraintNamespaces.clear();
                this.negateTargetNamespace = false;
                negatedNamespace = null;
                this.anyNamespace = true;
            }
            return;
        }
        if (this.constraintNamespaces.size() != 0 && unitiveNegatedNamespace != null) {
            this.constraintNamespaces.clear();
            if (this.constraintNamespaces.contains(new ConstraintNamespace(unitiveNegatedNamespace))) {
                this.negateTargetNamespace = false;
                negatedNamespace = null;
                this.anyNamespace = true;
            } else {
                this.negateTargetNamespace = unitiveWildcard.negateTargetNamespace;
                negatedNamespace = unitiveWildcard.negatedNamespace;
            }
            return;
        }
    }

    @Override
    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        WildcardImpl result = (WildcardImpl)super.initializeBase(base, clonedCollector);
        result.processContents = this.processContents;
        result.anyNamespace = this.anyNamespace;
        result.negateTargetNamespace = this.negateTargetNamespace;
        result.negatedNamespace = this.negatedNamespace;
        result.constraintNamespaces.addAll(this.constraintNamespaces);
        result.isAttribWildcard = this.isAttribWildcard;
        result.negateOther = this.negateOther;
        result.targetNamespacePosition = this.targetNamespacePosition;
        return result;
    }

    private class ConstraintNamespace
    extends Namespace {
        public String namespace;

        private ConstraintNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }
    }

    private class ConstraintTargetNamespace
    extends Namespace {
        private ConstraintTargetNamespace() {
        }

        @Override
        public String getNamespace() {
            return WildcardImpl.this.schema.getTargetNamespace();
        }
    }

    private abstract class Namespace {
        private Namespace() {
        }

        abstract String getNamespace();

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Namespace) {
                return ((Namespace)object).getNamespace().equals(this.getNamespace());
            }
            return false;
        }
    }
}

