/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.gui;

import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.gui.SAXValidationHandler;
import com.sap.engine.lib.schema.gui.XMLValidationVisualizationFrame;
import com.sap.engine.lib.xml.parser.NestedSAXParseException;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidationVisualizationPanel
extends JPanel
implements ActionListener {
    private JTextArea textArea_XmlVisual;
    private JTextArea textArea_ErrorsVisual;
    private JLabel errorsIdentificationLabel;
    private JLabel xmlLocationIdentificationLabel;
    private XMLValidationVisualizationFrame frame;
    private SAXParser parser;
    private String xmlLocation;
    private SAXValidationHandler handler;
    private static final String LOAD_XML_FILE_ACTION_COMMAND = "load.xml.file";
    private static final String VALIDATE_XML_FILE_ACTION_COMMAND = "validate.xml.file";
    private static final String RELOAD_XML_FILE_ACTION_COMMAND = "reload.xml.file";

    protected XMLValidationVisualizationPanel(XMLValidationVisualizationFrame frame) {
        this.frame = frame;
        this.initView();
        this.initParser();
        this.handler = new SAXValidationHandler(this);
    }

    private void initParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            this.parser = factory.newSAXParser();
            this.parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void initView() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)this.createPanel_Action(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.createXmlVisualErrorsVisualSplitPane(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        this.errorsIdentificationLabel = new JLabel();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.errorsIdentificationLabel, gridBagConstraints);
    }

    private JPanel createPanel_Action() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout(0));
        controlPanel.setBorder(BorderFactory.createEtchedBorder());
        JButton xmlChooserButton = new JButton("choose xml");
        xmlChooserButton.setActionCommand(LOAD_XML_FILE_ACTION_COMMAND);
        xmlChooserButton.addActionListener(this);
        controlPanel.add(xmlChooserButton);
        JButton xmlValidateButton = new JButton("validate xml");
        xmlValidateButton.setActionCommand(VALIDATE_XML_FILE_ACTION_COMMAND);
        xmlValidateButton.addActionListener(this);
        controlPanel.add(xmlValidateButton);
        JButton xmlReloadButton = new JButton("reload xml");
        xmlReloadButton.setActionCommand(RELOAD_XML_FILE_ACTION_COMMAND);
        xmlReloadButton.addActionListener(this);
        controlPanel.add(xmlReloadButton);
        return controlPanel;
    }

    private JSplitPane createXmlVisualErrorsVisualSplitPane() {
        JSplitPane xmlVizualFromErrorsVizualSplitPane = new JSplitPane(0);
        xmlVizualFromErrorsVizualSplitPane.setResizeWeight(0.7);
        xmlVizualFromErrorsVizualSplitPane.setOneTouchExpandable(true);
        xmlVizualFromErrorsVizualSplitPane.setTopComponent(this.createPanel_XMLVisual());
        xmlVizualFromErrorsVizualSplitPane.setBottomComponent(this.createPanel_ErrorsVisual());
        return xmlVizualFromErrorsVizualSplitPane;
    }

    private JPanel createPanel_XMLVisual() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 0;
        gridBagConstr.gridy = 0;
        gridBagConstr.anchor = 17;
        gridBagConstr.insets = new Insets(3, 3, 3, 3);
        JLabel identificationLabel = new JLabel("XML:");
        panel.add((Component)identificationLabel, gridBagConstr);
        gridBagConstr.gridx = 1;
        this.xmlLocationIdentificationLabel = new JLabel();
        panel.add((Component)this.xmlLocationIdentificationLabel, gridBagConstr);
        gridBagConstr.gridx = 0;
        gridBagConstr.gridy = 1;
        gridBagConstr.weightx = 1.0;
        gridBagConstr.weighty = 1.0;
        gridBagConstr.gridwidth = 2;
        gridBagConstr.fill = 1;
        panel.add((Component)this.createScrollPane_XmlVisual(), gridBagConstr);
        return panel;
    }

    private JPanel createPanel_ErrorsVisual() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 0;
        gridBagConstr.gridy = 0;
        gridBagConstr.anchor = 17;
        gridBagConstr.insets = new Insets(3, 3, 3, 3);
        JLabel identificationLabel = new JLabel("Errors:");
        panel.add((Component)identificationLabel, gridBagConstr);
        gridBagConstr.gridy = 1;
        gridBagConstr.weightx = 1.0;
        gridBagConstr.weighty = 1.0;
        gridBagConstr.fill = 1;
        panel.add((Component)this.createScrollPane_ErrorsVisual(), gridBagConstr);
        return panel;
    }

    private JScrollPane createScrollPane_XmlVisual() {
        this.textArea_XmlVisual = new JTextArea();
        this.textArea_XmlVisual.setEditable(false);
        return new JScrollPane(this.textArea_XmlVisual);
    }

    private JScrollPane createScrollPane_ErrorsVisual() {
        this.textArea_ErrorsVisual = new JTextArea();
        this.textArea_ErrorsVisual.setEditable(false);
        this.textArea_ErrorsVisual.setForeground(Color.RED);
        return new JScrollPane(this.textArea_ErrorsVisual);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (actionCommand.equals(LOAD_XML_FILE_ACTION_COMMAND)) {
            this.showXml_UseFileChooser();
        } else if (actionCommand.equals(VALIDATE_XML_FILE_ACTION_COMMAND)) {
            this.validateXml();
        } else if (actionCommand.equals(RELOAD_XML_FILE_ACTION_COMMAND)) {
            this.showXml();
        }
    }

    private void saveXml(String xmlLocation) {
        block14: {
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(xmlLocation);
                    byte[] textArea_XmlVisualTextBytes = this.textArea_XmlVisual.getText().getBytes();
                    fileOutputStream.write(textArea_XmlVisualTextBytes);
                    fileOutputStream.flush();
                }
                catch (Exception exc) {
                    this.displayError(exc.getMessage());
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void showXml_UseFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        int option = fileChooser.showOpenDialog(this.frame);
        if (option == 0) {
            try {
                File selectedFile = fileChooser.getSelectedFile();
                this.xmlLocation = selectedFile.getCanonicalPath();
                this.xmlLocationIdentificationLabel.setText(this.xmlLocation);
                this.showXml();
            }
            catch (Exception exc) {
                this.displayError(exc.getMessage());
            }
        }
    }

    private void showXml() {
        block15: {
            FileInputStream fileInputStream = null;
            try {
                try {
                    this.reset();
                    fileInputStream = new FileInputStream(this.xmlLocation);
                    this.textArea_XmlVisual.setText("");
                    byte[] buffer = new byte[1024];
                    int readedBytesCount = -1;
                    while ((readedBytesCount = fileInputStream.read(buffer)) > 0) {
                        this.textArea_XmlVisual.append(new String(buffer, 0, readedBytesCount));
                    }
                }
                catch (Exception exc) {
                    this.displayError(exc.getMessage());
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void validateXml() {
        block8: {
            try {
                try {
                    this.reset();
                    Schema schema = this.frame.getXMLSchema();
                    this.parser.setProperty("http://apache.org/xml/properties/schema/schemaObject", schema);
                    this.parser.parse(this.xmlLocation, (DefaultHandler)this.handler);
                }
                catch (Exception exc) {
                    this.displayError(exc instanceof NestedSAXParseException ? ((NestedSAXParseException)exc).getCause().getMessage() : exc.getMessage());
                    if (this.textArea_ErrorsVisual.getText() != null) {
                        this.errorsIdentificationLabel.setForeground(Color.RED);
                        this.errorsIdentificationLabel.setText("Errors");
                        break block8;
                    }
                    this.errorsIdentificationLabel.setForeground(Color.GREEN);
                    this.errorsIdentificationLabel.setText("No errors");
                }
            }
            finally {
                if (this.textArea_ErrorsVisual.getText() != null) {
                    this.errorsIdentificationLabel.setForeground(Color.RED);
                    this.errorsIdentificationLabel.setText("Errors");
                } else {
                    this.errorsIdentificationLabel.setForeground(Color.GREEN);
                    this.errorsIdentificationLabel.setText("No errors");
                }
            }
        }
    }

    private void reset() {
        this.textArea_ErrorsVisual.setText("");
        this.errorsIdentificationLabel.setText("");
    }

    protected void displayError(String errorMessage) {
        this.textArea_ErrorsVisual.append(errorMessage);
    }
}

