/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.util;

import com.sap.engine.lib.schema.util.Tokenizer;
import java.util.Vector;

public final class LexicalCharsTokenizer
extends Tokenizer {
    private static final int CHARS_STORAGE_INCREMENT_LENGTH = 10;
    private static final int CHARS_STORAGE_INIT_LENGTH = 30;
    private char[] charsStorage;
    private int storedCharsCount;
    private Vector stringsStorage;

    public LexicalCharsTokenizer(String target, String[] delimiters) {
        super(target, delimiters);
    }

    @Override
    protected void processTarget(String target, String[] delimiters) {
        this.charsStorage = new char[30];
        this.storedCharsCount = 0;
        this.stringsStorage = new Vector();
        if (delimiters != null) {
            this.processTargetWithDelimiters(target, delimiters);
        } else {
            this.processTargetWithoutDelimiters(target);
        }
    }

    private void processTargetWithDelimiters(String target, String[] delimiters) {
        int i = 0;
        while (i < target.length()) {
            String delimiter = null;
            int j = 0;
            while (j < delimiters.length) {
                if (target.startsWith(delimiters[j], i)) {
                    delimiter = delimiters[j];
                    break;
                }
                ++j;
            }
            if (delimiter != null) {
                i += delimiter.length();
                this.tokensCollector.add(delimiter);
                continue;
            }
            this.tokensCollector.add(this.determineString(target.charAt(i)));
            ++i;
        }
    }

    private void processTargetWithoutDelimiters(String target) {
        int i = 0;
        while (i < target.length()) {
            this.tokensCollector.add(this.determineString(target.charAt(i)));
            ++i;
        }
    }

    private String determineString(char ch) {
        int i = 0;
        while (i < this.storedCharsCount) {
            char storedCh = this.charsStorage[i];
            if (ch == storedCh) {
                return (String)this.stringsStorage.get(i);
            }
            ++i;
        }
        return this.storeCharAndString(ch);
    }

    private String storeCharAndString(char ch) {
        if (this.storedCharsCount == this.charsStorage.length) {
            this.incrementCharsStorage();
        }
        String result = String.valueOf(ch);
        this.charsStorage[this.storedCharsCount++] = ch;
        this.stringsStorage.add(result);
        return result;
    }

    private void incrementCharsStorage() {
        char[] hlpArray = this.charsStorage;
        this.charsStorage = new char[this.charsStorage.length + 10];
        System.arraycopy(hlpArray, 0, this.charsStorage, 0, hlpArray.length);
    }
}

