/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.impl.ffacets.Value;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.automat.ContentAutomat;
import com.sap.engine.lib.schema.validator.identity.IdentityConstraintRegResult;
import com.sap.engine.lib.schema.validator.identity.KeySequence;
import com.sap.engine.lib.schema.validator.identity.KeyWrapper;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.IdentityConstraintXPathMatcher;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.XPathTokenizer;
import com.sap.engine.lib.schema.validator.xpath.AttributeXPathStep;
import com.sap.engine.lib.schema.validator.xpath.ElementXPathStep;
import com.sap.engine.lib.schema.validator.xpath.XPathStep;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import java.util.Hashtable;
import java.util.Vector;

public final class ReusableObjectsPool {
    private Hashtable complTypeToAutomatMapping = new Hashtable();
    private Hashtable stringAndNormWhitespaceValueToNormStringMapping = new Hashtable();
    private Hashtable stringToCharArrayMapping = new Hashtable();
    private Vector fFacetValues = new Vector();
    private Vector elemXPathSteps = new Vector();
    private Vector attribXPathSteps = new Vector();
    private Vector stringBuffers = new Vector();
    private Vector allStructureStates = new Vector();
    private Vector baseStructureStates = new Vector();
    private Vector groupStructureStates = new Vector();
    private Vector particleStructureStates = new Vector();
    private Vector keySequences = new Vector();
    private Vector keyWrappers = new Vector();
    private Vector identConstrRegResults = new Vector();
    private Hashtable qKeyToMatchersMapping = new Hashtable();

    protected ReusableObjectsPool() {
    }

    public IdentityConstraintXPathMatcher getIdentityConstraintXPathMatcher(IdentityConstraintDefinition identConstrDefinition, XPathTokenizer xPathTokenizer) {
        IdentityConstraintXPathMatcher identConstrXPathMatcher = (IdentityConstraintXPathMatcher)this.qKeyToMatchersMapping.get(identConstrDefinition.getQualifiedKey());
        if (identConstrXPathMatcher == null) {
            identConstrXPathMatcher = new IdentityConstraintXPathMatcher(xPathTokenizer, identConstrDefinition);
            this.qKeyToMatchersMapping.put(identConstrDefinition.getQualifiedKey(), identConstrXPathMatcher);
        }
        return identConstrXPathMatcher;
    }

    protected ContentAutomat getContentAutomat(ComplexTypeDefinition complTypeDefinition) {
        ContentAutomat contentAutomat = (ContentAutomat)this.complTypeToAutomatMapping.get(complTypeDefinition);
        if (contentAutomat == null) {
            contentAutomat = new ContentAutomat(complTypeDefinition);
            this.complTypeToAutomatMapping.put(complTypeDefinition, contentAutomat);
        } else if (!contentAutomat.isUntouched()) {
            contentAutomat = new ContentAutomat(complTypeDefinition);
        }
        return contentAutomat;
    }

    protected String getString(CharArray charArray) {
        return charArray.getStringFast();
    }

    protected String getNormalizedString(String initialString, String normWhitespaceValue) {
        if (normWhitespaceValue != null) {
            Hashtable stringToNormStringMapping = (Hashtable)this.stringAndNormWhitespaceValueToNormStringMapping.get(normWhitespaceValue);
            if (stringToNormStringMapping != null) {
                String normString = (String)stringToNormStringMapping.get(initialString);
                if (normString == null) {
                    normString = this.storeNormalizedString(initialString, normWhitespaceValue, stringToNormStringMapping);
                }
                return normString;
            }
            stringToNormStringMapping = new Hashtable();
            this.stringAndNormWhitespaceValueToNormStringMapping.put(normWhitespaceValue, stringToNormStringMapping);
            return this.storeNormalizedString(initialString, normWhitespaceValue, stringToNormStringMapping);
        }
        return Tools.normalizeValue(initialString, normWhitespaceValue);
    }

    private String storeNormalizedString(String initialString, String normWhitespaceValue, Hashtable stringToNormStringMapping) {
        String normString = Tools.normalizeValue(initialString, normWhitespaceValue);
        stringToNormStringMapping.put(initialString, normString);
        return normString;
    }

    protected void reuseFFacetValue(Value fFacetValue) {
        if (fFacetValue != null) {
            fFacetValue.reuse();
            if (fFacetValue.isReusable()) {
                this.fFacetValues.add(fFacetValue);
            }
        }
    }

    protected CharArray getCharArray(String string) {
        CharArray charArray = (CharArray)this.stringToCharArrayMapping.get(string);
        if (charArray == null) {
            charArray = new CharArray(string);
            this.stringToCharArrayMapping.put(string, charArray);
        }
        return charArray;
    }

    public Value getFFacetValue() {
        if (this.fFacetValues.size() > 0) {
            return (Value)this.fFacetValues.remove(this.fFacetValues.size() - 1);
        }
        return new Value();
    }

    public ElementXPathStep getElementXPathStep() {
        if (this.elemXPathSteps.size() > 0) {
            return (ElementXPathStep)this.elemXPathSteps.remove(this.elemXPathSteps.size() - 1);
        }
        return new ElementXPathStep(this);
    }

    public void reuseElementXPathStep(XPathStep elemXPathStep) {
        elemXPathStep.reuse();
        this.elemXPathSteps.add(elemXPathStep);
    }

    public AttributeXPathStep getAttributeXPathStep() {
        if (this.attribXPathSteps.size() > 0) {
            return (AttributeXPathStep)this.attribXPathSteps.remove(this.attribXPathSteps.size() - 1);
        }
        return new AttributeXPathStep(this);
    }

    public void reuseAttributeXPathStep(XPathStep attribXPathStep) {
        attribXPathStep.reuse();
        this.attribXPathSteps.add(attribXPathStep);
    }

    public StringBuffer getStringBuffer() {
        if (this.stringBuffers.size() > 0) {
            return (StringBuffer)this.stringBuffers.remove(this.stringBuffers.size() - 1);
        }
        return new StringBuffer();
    }

    public void reuseStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.delete(0, stringBuffer.length());
        this.stringBuffers.add(stringBuffer);
    }

    public KeySequence getKeySequence() {
        if (this.keySequences.size() > 0) {
            return (KeySequence)this.keySequences.remove(this.keySequences.size() - 1);
        }
        return new KeySequence();
    }

    public void reuseKeySequence(KeySequence keySequence) {
        keySequence.reuse();
        KeyWrapper[] keyWrappers = keySequence.getKeyWrappers();
        int i = 0;
        while (i < keyWrappers.length) {
            this.reuseKeyWrapper(keyWrappers[i]);
            ++i;
        }
        this.keySequences.add(keySequence);
    }

    public KeyWrapper getKeyWrapper() {
        if (this.keyWrappers.size() > 0) {
            return (KeyWrapper)this.keyWrappers.remove(this.keyWrappers.size() - 1);
        }
        return new KeyWrapper();
    }

    public void reuseKeyWrapper(KeyWrapper keyWrapper) {
        Value fFacetsValue = keyWrapper.getFFacetsValue();
        if (fFacetsValue != null) {
            this.reuseFFacetValue(fFacetsValue);
        }
        this.keyWrappers.add(keyWrapper);
    }

    public IdentityConstraintRegResult getIdentityConstraintRegResult() {
        if (this.identConstrRegResults.size() > 0) {
            return (IdentityConstraintRegResult)this.identConstrRegResults.remove(this.identConstrRegResults.size() - 1);
        }
        return new IdentityConstraintRegResult();
    }

    public void reuseIdentityConstraintRegResult(IdentityConstraintRegResult identConstrRegResult) {
        identConstrRegResult.reuse();
        this.identConstrRegResults.add(identConstrRegResult);
    }
}

