/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator;

import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.ComplexTypeDefinition;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.FundamentalFacets;
import com.sap.engine.lib.schema.components.Loader;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.SimpleTypeDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.components.Wildcard;
import com.sap.engine.lib.schema.components.impl.LoaderImpl;
import com.sap.engine.lib.schema.components.impl.ffacets.Value;
import com.sap.engine.lib.schema.components.impl.ffacets.ValueComparator;
import com.sap.engine.lib.schema.components.impl.structures.SchemaImpl;
import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.validator.NamespaceHandler;
import com.sap.engine.lib.schema.validator.ReusableObjectsPool;
import com.sap.engine.lib.schema.validator.SimpleTypeValidator;
import com.sap.engine.lib.schema.validator.ValidationConfigContext;
import com.sap.engine.lib.schema.validator.automat.ContentAutomat;
import com.sap.engine.lib.schema.validator.identity.IdentityConstraintRegResult;
import com.sap.engine.lib.schema.validator.identity.IdentityConstraintsValidator;
import com.sap.engine.lib.schema.validator.xpath.AttributeXPathStep;
import com.sap.engine.lib.schema.validator.xpath.ElementXPathStep;
import com.sap.engine.lib.schema.validator.xpath.XPath;
import com.sap.engine.lib.schema.validator.xpath.XPathStep;
import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.dom.AttrImpl;
import com.sap.engine.lib.xml.dom.Base;
import com.sap.engine.lib.xml.dom.DOMDocHandler1;
import com.sap.engine.lib.xml.dom.ElementImpl;
import com.sap.engine.lib.xml.dom.NodeImpl;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.URLLoader;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.parser.helpers.Reference;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.URIResolver;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class SchemaDocHandler
implements DocHandler,
Constants {
    private ValidationConfigContext validationConfigContext;
    private XPath xPath;
    private Loader loader;
    private Vector errors;
    private NamespaceHandler namespaceHandler;
    private IdentityConstraintsValidator identConstrValidator;
    private Vector idValues;
    private Hashtable attribRepresentToIdrefValueMapping;
    private Hashtable attribRepresentToIdrefValuesMapping;
    private boolean canonicalProcessing;
    private boolean validateXSDDoc;
    private EntityResolver entityResolver;
    private ReusableObjectsPool reusableObjectsPool;
    private Vector attribUses;

    public SchemaDocHandler(ValidationConfigContext validationConfigContext) {
        this.validationConfigContext = validationConfigContext;
        this.reusableObjectsPool = new ReusableObjectsPool();
        this.xPath = new XPath(this.reusableObjectsPool);
        this.errors = new Vector();
        this.namespaceHandler = new NamespaceHandler();
        this.idValues = new Vector();
        this.attribRepresentToIdrefValueMapping = new Hashtable();
        this.attribRepresentToIdrefValuesMapping = new Hashtable();
        this.identConstrValidator = new IdentityConstraintsValidator(this);
        this.attribUses = new Vector();
    }

    public ReusableObjectsPool getReusableObjectsPool() {
        return this.reusableObjectsPool;
    }

    @Override
    public void onXMLDecl(String version, String encoding, String ssdecl) throws Exception {
        this.validationConfigContext.getDocHandler().onXMLDecl(version, encoding, ssdecl);
    }

    @Override
    public void startElementStart(CharArray uri, CharArray localName, CharArray qname) throws Exception {
        ElementXPathStep elemXPathStep = this.createElementXPathStep(uri, localName);
        this.xPath.addXPathStep(elemXPathStep);
        this.namespaceHandler.levelUp();
        this.validationConfigContext.getDocHandler().startElementStart(uri, localName, qname);
    }

    private ElementXPathStep createElementXPathStep(CharArray uri, CharArray localName) {
        ElementXPathStep elemXPathStep = this.reusableObjectsPool.getElementXPathStep();
        elemXPathStep.setUriStr(this.reusableObjectsPool.getString(uri));
        elemXPathStep.setLocalNameStr(this.reusableObjectsPool.getString(localName));
        elemXPathStep.setLine(this.validationConfigContext.getLocator().getLineNumber());
        elemXPathStep.setColumn(this.validationConfigContext.getLocator().getColumnNumber());
        return elemXPathStep;
    }

    @Override
    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        String attribUri = this.reusableObjectsPool.getString(uri);
        String attribLocalName = this.reusableObjectsPool.getString(localName);
        String attribValue = this.reusableObjectsPool.getString(value).trim();
        ElementXPathStep elemXPathStep = (ElementXPathStep)this.xPath.getLastXPathStep();
        AttributeXPathStep attribXPathStep = null;
        if (attribUri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            if (attribLocalName.equals("schemaLocation")) {
                attribXPathStep = this.initSchema(uri, prefix, localName, qname, value, type, attribUri, attribLocalName, attribValue, elemXPathStep.getUriStr(), true);
            } else if (attribLocalName.equals("noNamespaceSchemaLocation")) {
                attribXPathStep = this.initSchema(uri, prefix, localName, qname, value, type, attribUri, attribLocalName, attribValue, elemXPathStep.getUriStr(), false);
            } else if (attribLocalName.equals("type")) {
                elemXPathStep.setXsiTypeAttributeValue(attribValue);
            } else if (attribLocalName.equals("nil")) {
                elemXPathStep.setXsiNillAttributeValue(attribValue);
            } else {
                attribXPathStep = this.createAttributeXPathStep(uri, prefix, localName, qname, type, value, attribUri, attribLocalName, attribValue);
            }
        } else if (this.reusableObjectsPool.getString(qname).equals("xmlns")) {
            this.namespaceHandler.addUri("", attribValue);
        } else if (attribUri.equals("http://www.w3.org/2000/xmlns/")) {
            this.namespaceHandler.addUri(attribLocalName, attribValue);
        } else {
            attribXPathStep = this.createAttributeXPathStep(uri, prefix, localName, qname, type, value, attribUri, attribLocalName, attribValue);
        }
        if (attribXPathStep != null) {
            elemXPathStep.addAttributeXPathStep(attribXPathStep);
        } else {
            this.validationConfigContext.getDocHandler().addAttribute(uri, prefix, localName, qname, type, value);
        }
    }

    private AttributeXPathStep initSchema(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, CharArray value, String type, String attribUri, String attribLocalName, String attribValue, String parentUri, boolean hasNamespace) throws Exception {
        AttributeXPathStep attribXPathStep = null;
        if (this.xPath.getXPathStepsCount() == 1) {
            if (this.validationConfigContext.getSchema() == null || !this.validationConfigContext.getSchema().getTargetNamespace().equals(parentUri)) {
                this.validationConfigContext.setSchema(hasNamespace ? this.loadSchema_Namespace(attribValue) : this.loadSchema_NoNamespace(attribValue));
            }
        } else {
            attribXPathStep = this.createAttributeXPathStep(uri, prefix, localName, qname, type, value, attribUri, attribLocalName, attribValue);
        }
        return attribXPathStep;
    }

    private Object determineXSDDocSourceObject(String xsdDocSystemId) throws Exception {
        String xmlDocSystemId = this.validationConfigContext.getLocator().getSystemId();
        Loader loader = this.determineLoader();
        URIResolver uriResolver = loader.getUriResolver();
        EntityResolver entityResolver = loader.getEntityResolver();
        if (uriResolver != null && uriResolver.resolve(xsdDocSystemId, xmlDocSystemId) != null || entityResolver != null && entityResolver.resolveEntity(null, xsdDocSystemId) != null) {
            return xsdDocSystemId;
        }
        URL xmlDocURL = null;
        if (xmlDocSystemId != null) {
            xmlDocURL = URLLoader.fileOrURLToURL(null, xmlDocSystemId);
        }
        URL xsdDocURL = URLLoader.fileOrURLToURL(xmlDocURL, xsdDocSystemId);
        InputSource inputSource = new InputSource();
        inputSource.setSystemId(xsdDocURL.toExternalForm());
        inputSource.setByteStream(xsdDocURL.openStream());
        return inputSource;
    }

    private SchemaImpl loadSchema_Namespace(String location) throws Exception {
        StringTokenizer strTokenizer = new StringTokenizer(location);
        int countTokens = strTokenizer.countTokens() / 2;
        if (strTokenizer.countTokens() % 2 != 0) {
            throw new SchemaException("Incorrect initializing of external schema locations. The count of the relevant target namespaces must be equal to the count of the schema locations.");
        }
        String[] namespaces = new String[countTokens];
        Object[] xsdDocSourceObjects = new Object[countTokens];
        int index = 0;
        while (strTokenizer.hasMoreTokens()) {
            namespaces[index] = strTokenizer.nextToken();
            xsdDocSourceObjects[index] = this.determineXSDDocSourceObject(strTokenizer.nextToken());
            ++index;
        }
        return (SchemaImpl)this.determineLoader().load(namespaces, xsdDocSourceObjects);
    }

    private SchemaImpl loadSchema_NoNamespace(String location) throws Exception {
        return (SchemaImpl)this.determineLoader().load(this.determineXSDDocSourceObject(location));
    }

    private AttributeXPathStep createAttributeXPathStep(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value, String uriStr, String localNameStr, String valueStr) {
        AttributeXPathStep attribXPathStep = this.reusableObjectsPool.getAttributeXPathStep();
        attribXPathStep.setUri(uri);
        attribXPathStep.setPrefix(prefix);
        attribXPathStep.setLocalName(localName);
        attribXPathStep.setQName(qname);
        attribXPathStep.setType(type);
        attribXPathStep.setValue(value);
        attribXPathStep.setUriStr(uriStr);
        attribXPathStep.setLocalNameStr(localNameStr);
        attribXPathStep.setValueStr(valueStr);
        attribXPathStep.setLine(this.validationConfigContext.getLocator().getLineNumber());
        attribXPathStep.setColumn(this.validationConfigContext.getLocator().getColumnNumber());
        return attribXPathStep;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void startElementEnd(boolean isEmpty) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 54[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void augmentNodeForCanonicalizationProcessing_ElementDeclaration(ElementXPathStep elemXPathStep, ModelGroup modelGroup_All) {
        if (this.canonicalProcessing && !elemXPathStep.isSkip() && this.validationConfigContext.getDocHandler() instanceof DOMDocHandler1) {
            ElementImpl node = ((DOMDocHandler1)this.validationConfigContext.getDocHandler()).getElement();
            node.setAugmentation("[type definition]", elemXPathStep.getTypeDefinition());
            ElementDeclaration elemDeclaration = elemXPathStep.getElementDeclaration();
            node.setAugmentation("[element declaration]", elemDeclaration);
            node.setAugmentation("[annotation]", elemDeclaration != null ? elemDeclaration.getAnnotation() : null);
            node.setAugmentation("[validating model group all]", modelGroup_All);
            NamedNodeMap namedNodeMap = ((Base)node).getAttributes();
            int i = 0;
            while (i < namedNodeMap.getLength()) {
                NodeImpl attr = (NodeImpl)namedNodeMap.item(i);
                if (attr.getAugmentation("[validation attempted]") == null) {
                    node.setAugmentation("[validation attempted]", "partial");
                    break;
                }
                ++i;
            }
            if (node.getAugmentation("[validation attempted]") == null) {
                NodeList nodeList = node.getChildNodes();
                int i2 = 0;
                while (i2 < nodeList.getLength()) {
                    Base childNode = (Base)nodeList.item(i2);
                    if (childNode instanceof Element && childNode.getAugmentation("[validation attempted]") == null) {
                        node.setAugmentation("[validation attempted]", "partial");
                        break;
                    }
                    ++i2;
                }
            }
            if (node.getAugmentation("[validation attempted]") == null) {
                node.setAugmentation("[validation attempted]", "full");
            }
        }
    }

    private void initElementXPathStep_Error(String errorMessage, ElementXPathStep elemXPathStep) throws Exception {
        this.collectError(elemXPathStep.getRepresentation(), errorMessage);
        elemXPathStep.setLax(false);
        elemXPathStep.setSkip(true);
        elemXPathStep.setContentAutomat(null);
        elemXPathStep.setElementDeclaration(null);
        elemXPathStep.setTypeDefinition(null);
    }

    private void initParentElementXPathStep_Error(ElementXPathStep parentElemXPathStep) throws Exception {
        parentElemXPathStep.setLax(false);
        parentElemXPathStep.setSkip(true);
    }

    private void initElementXPathStep_LaxContent(ElementXPathStep elemXPathStep, boolean isLax) {
        elemXPathStep.setLax(isLax);
        elemXPathStep.setSkip(isLax);
    }

    private void validateAttributeDeclaration(AttributeXPathStep attribXPathStep, AttributeDeclaration attribDeclaration, String attribUseFixedValue) throws Exception {
        String fixedValue;
        String initialValue = attribXPathStep.getValueStr();
        SimpleTypeDefinition typeDefinition = (SimpleTypeDefinition)attribDeclaration.getTypeDefinition();
        String normalizedValue = this.reusableObjectsPool.getNormalizedString(initialValue, typeDefinition.getWhiteSpaceNormalizationValue());
        this.validationConfigContext.getDocHandler().addAttribute(attribXPathStep.getUri(), attribXPathStep.getPrefix(), attribXPathStep.getLocalName(), attribXPathStep.getQName(), attribXPathStep.getType(), this.reusableObjectsPool.getCharArray(normalizedValue));
        if (!attribXPathStep.getUriStr().equals(attribDeclaration.getTargetNamespace()) || !attribXPathStep.getLocalNameStr().equals(attribDeclaration.getName())) {
            this.collectError(attribXPathStep.getRepresentation(), "The namespace and name do not match.");
            return;
        }
        AttrImpl attr = this.validationConfigContext.getDocHandler() instanceof DOMDocHandler1 ? ((DOMDocHandler1)this.validationConfigContext.getDocHandler()).getAttr() : null;
        String string = fixedValue = attribUseFixedValue == null ? attribDeclaration.getValueConstraintFixed() : attribUseFixedValue;
        if (!this.validateData(initialValue, normalizedValue, typeDefinition, fixedValue, attribXPathStep.getRepresentation(), false, attr)) {
            return;
        }
        this.augmentNodeForCanonicalizationProcessing_AttributeDeclaration(attr, attribDeclaration, typeDefinition);
    }

    private void augmentNodeForCanonicalizationProcessing_AttributeDeclaration(AttrImpl attr, AttributeDeclaration attribDeclaration, TypeDefinitionBase typeDefinition) {
        if (this.canonicalProcessing && attr != null) {
            attr.setAugmentation("[attribute declaration]", attribDeclaration);
            attr.setAugmentation("[type definition]", typeDefinition);
            attr.setAugmentation("[annotation]", attribDeclaration.getAnnotation());
            attr.setAugmentation("[validation attempted]", "full");
        }
    }

    private boolean validateWildcardAllowanceNamespace(Wildcard wildcard, XPathStep xPathStep) throws SAXException {
        String uri = xPathStep.getUriStr();
        if (wildcard.isNamespaceConstraintAny()) {
            return true;
        }
        String constraintNegated = wildcard.getNamespaceConstraintNegated();
        if (constraintNegated != null && !uri.equals(constraintNegated)) {
            return true;
        }
        String[] namespaceConstrMembers = wildcard.getNamespaceConstraintMembersAsArray();
        if (namespaceConstrMembers != null) {
            int i = 0;
            while (i < namespaceConstrMembers.length) {
                if (uri.equals(namespaceConstrMembers[i])) {
                    return true;
                }
                ++i;
            }
        }
        this.collectError(xPathStep.getRepresentation(), "Information item is matched to a wildcard. The uri '" + uri + "' is not allowed according to the wildcard's {namespace constraint} property.");
        return false;
    }

    private boolean validateData(String initialValue, String normalizedValue, SimpleTypeDefinition simpleTypeDefinition, String fixedValue, String nodeRepresent, boolean isNillableElemDeclaration, NodeImpl node) throws SAXException {
        boolean fFacetsNormalizedValueIsRegistered;
        Value fFacetsFixedValue;
        Value fFacetsNormalizedValue;
        block13: {
            block12: {
                block11: {
                    fFacetsNormalizedValue = null;
                    fFacetsFixedValue = null;
                    fFacetsNormalizedValueIsRegistered = false;
                    try {
                        FundamentalFacets fFacets = simpleTypeDefinition.getFundamentalFacets();
                        fFacetsNormalizedValue = fFacets.parse(normalizedValue, this.reusableObjectsPool);
                        if (fixedValue != null) {
                            fFacetsFixedValue = fFacets.parse(fixedValue, this.reusableObjectsPool);
                        }
                        if (SimpleTypeValidator.validateSimpleTypeDefinition(simpleTypeDefinition, this, fFacetsNormalizedValue, normalizedValue, nodeRepresent, node)) break block11;
                        if (!fFacetsNormalizedValueIsRegistered) {
                            this.reusableObjectsPool.reuseFFacetValue(fFacetsNormalizedValue);
                        }
                        this.reusableObjectsPool.reuseFFacetValue(fFacetsFixedValue);
                        return false;
                    }
                    catch (Throwable throwable) {
                        if (!fFacetsNormalizedValueIsRegistered) {
                            this.reusableObjectsPool.reuseFFacetValue(fFacetsNormalizedValue);
                        }
                        this.reusableObjectsPool.reuseFFacetValue(fFacetsFixedValue);
                        throw throwable;
                    }
                }
                if (fFacetsFixedValue == null || ValueComparator.compare(fFacetsFixedValue, fFacetsNormalizedValue) == 1) break block12;
                this.collectError(nodeRepresent, "Node is associated with declaration, whose {fixed value constraint} property is '" + fFacetsFixedValue.getValue() + "'. Value '" + initialValue + "' should be identical to this constraint fixed value.");
                if (!fFacetsNormalizedValueIsRegistered) {
                    this.reusableObjectsPool.reuseFFacetValue(fFacetsNormalizedValue);
                }
                this.reusableObjectsPool.reuseFFacetValue(fFacetsFixedValue);
                return false;
            }
            IdentityConstraintRegResult regResult = this.identConstrValidator.registerValue(fFacetsNormalizedValue, normalizedValue, nodeRepresent);
            fFacetsNormalizedValueIsRegistered = regResult.valueIsRegistered();
            boolean identConstrRegFail = regResult.registraitionFail();
            this.reusableObjectsPool.reuseIdentityConstraintRegResult(regResult);
            if (this.registerValueForIdentityValidation_ID_IDREF_IDREFS(simpleTypeDefinition, normalizedValue, nodeRepresent) && !identConstrRegFail) break block13;
            this.collectError(nodeRepresent, "The value '" + normalizedValue + "' can not be registered for identity constraint validation.");
            if (!fFacetsNormalizedValueIsRegistered) {
                this.reusableObjectsPool.reuseFFacetValue(fFacetsNormalizedValue);
            }
            this.reusableObjectsPool.reuseFFacetValue(fFacetsFixedValue);
            return false;
        }
        this.augmentNodeForCanonicalizationProcessing_Value(node, initialValue, normalizedValue);
        if (!fFacetsNormalizedValueIsRegistered) {
            this.reusableObjectsPool.reuseFFacetValue(fFacetsNormalizedValue);
        }
        this.reusableObjectsPool.reuseFFacetValue(fFacetsFixedValue);
        return true;
    }

    private void augmentNodeForCanonicalizationProcessing_Value(NodeImpl node, String initialValue, String normalizedValue) {
        if (this.canonicalProcessing && node != null) {
            node.setAugmentation("[normalized value]", initialValue);
            node.setAugmentation("[schema normalized value]", normalizedValue);
        }
    }

    private boolean registerValueForIdentityValidation_ID_IDREF_IDREFS(TypeDefinitionBase typeDefinition, String value, String nodeRepresent) throws SAXException {
        if (typeDefinition != null) {
            if (typeDefinition.isDerivedFrom(this.validationConfigContext.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "ID"), false, false)) {
                if (this.idValues.contains(value)) {
                    this.collectError(nodeRepresent, "Attribute is declared to be with type derived form {http://www.w3.org/2001/XMLSchema}:ID. It's value '" + value + "' is not unique.");
                    return false;
                }
                this.idValues.add(value);
            } else if (typeDefinition.isDerivedFrom(this.validationConfigContext.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "IDREF"), false, false)) {
                this.attribRepresentToIdrefValueMapping.put(nodeRepresent, value);
            } else if (typeDefinition.isDerivedFrom(this.validationConfigContext.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "IDREFS"), false, false)) {
                this.attribRepresentToIdrefValuesMapping.put(nodeRepresent, value);
            }
        }
        return true;
    }

    private SimpleTypeDefinition determineSimpleTypeDefinition(TypeDefinitionBase typeDefBase) {
        if (typeDefBase instanceof SimpleTypeDefinition) {
            return (SimpleTypeDefinition)typeDefBase;
        }
        return ((ComplexTypeDefinition)typeDefBase).getContentTypeSimpleTypeDefinition();
    }

    private ComplexTypeDefinition determineComplexTypeDefinition(TypeDefinitionBase typeDefBase) {
        if (typeDefBase instanceof ComplexTypeDefinition) {
            return (ComplexTypeDefinition)typeDefBase;
        }
        return null;
    }

    private void validateIdentityConstraintDefinitions(ElementDeclaration elemDeclaration, ElementXPathStep elemXPathStep) throws SAXException {
        Vector identityConstrDefinitions = elemDeclaration.getIdentityConstraintDefinitions();
        if (!elemXPathStep.isNil() && identityConstrDefinitions != null && identityConstrDefinitions.size() != 0) {
            if (!this.identConstrValidator.validate(identityConstrDefinitions)) {
                this.collectError(elemXPathStep.getRepresentation(), "Element is not valid according to the defined identity constraints.");
            }
            this.identConstrValidator.unregisterValidators(identityConstrDefinitions);
        }
    }

    private void validateComplexContent(ElementXPathStep elemXPathStep) throws SAXException {
        ContentAutomat contentAutomat = elemXPathStep.getContentAutomat();
        if (contentAutomat != null) {
            if (!contentAutomat.isSatisfied() && !elemXPathStep.isNil()) {
                this.collectError(elemXPathStep.getRepresentation(), "Element is not valid according to it's complex type. Expected children elements : " + contentAutomat.getExpected() + ".");
            }
            contentAutomat.reset();
        }
    }

    private void validateSimpleContent(ElementXPathStep elemXPathStep, SimpleTypeDefinition simpleTypeDefinition, String fixedValue, String defaultValue) throws Exception {
        CharArray data;
        CharArray docHandlerInvokationData = data = elemXPathStep.getValue();
        NodeImpl node = this.validationConfigContext.getDocHandler() instanceof DOMDocHandler1 ? ((DOMDocHandler1)this.validationConfigContext.getDocHandler()).getCurrentNode() : null;
        String constrValue = null;
        constrValue = fixedValue != null ? fixedValue : defaultValue;
        if (elemXPathStep.isNil() && data != null) {
            this.collectError(elemXPathStep.getRepresentation(), "Element is declared to be nil. No character children are allowed.");
        }
        if (constrValue != null && data == null) {
            FundamentalFacets fFacets = simpleTypeDefinition.getFundamentalFacets();
            Value fFacetsConstrValue = fFacets.parse(constrValue, this.reusableObjectsPool);
            if (!SimpleTypeValidator.validateSimpleTypeDefinition(simpleTypeDefinition, this, fFacetsConstrValue, constrValue, elemXPathStep.getRepresentation(), null)) {
                this.collectError(elemXPathStep.getRepresentation(), "Element is matched to an element declaration whose {value constraint} property is '" + constrValue + "'. This value is not valid according to the element's simple type definition.");
            }
            this.reusableObjectsPool.reuseFFacetValue(fFacetsConstrValue);
            docHandlerInvokationData = this.reusableObjectsPool.getCharArray(constrValue);
            this.augmentNodeForCanonicalizatinProcessing_ValueConstraint(node, constrValue);
        } else if (!elemXPathStep.isNil()) {
            String initialValue = data == null ? "" : this.reusableObjectsPool.getString(data);
            String normalizedValue = this.reusableObjectsPool.getNormalizedString(initialValue, simpleTypeDefinition.getWhiteSpaceNormalizationValue());
            this.validateData(initialValue, normalizedValue, simpleTypeDefinition, fixedValue, elemXPathStep.getRepresentation(), elemXPathStep.isNil(), node);
            docHandlerInvokationData = this.reusableObjectsPool.getCharArray(normalizedValue);
        }
        if (docHandlerInvokationData != null) {
            this.invokeDocHandler_CharData(docHandlerInvokationData, elemXPathStep.getBDisableOutputEscaping(), elemXPathStep.hasTextNodeChild());
        }
    }

    private void augmentNodeForCanonicalizatinProcessing_ValueConstraint(NodeImpl node, String valueConstraint) {
        if (this.canonicalProcessing && node != null) {
            node.setAugmentation("[normalized value]", valueConstraint);
            node.setAugmentation("[schema normalized value]", valueConstraint);
        }
    }

    @Override
    public void endElement(CharArray uri, CharArray localName, CharArray qname, boolean isEmpty) throws Exception {
        ElementXPathStep elemXPathStep = (ElementXPathStep)this.xPath.getLastXPathStep();
        if (!elemXPathStep.isSkip()) {
            ElementDeclaration elemDeclaration = elemXPathStep.getElementDeclaration();
            SimpleTypeDefinition simpleTypeDefinition = this.determineSimpleTypeDefinition(elemXPathStep.getTypeDefinition());
            String fixedValue = null;
            String defaultValue = null;
            if (elemDeclaration != null) {
                fixedValue = elemDeclaration.getValueConstraintFixed();
                defaultValue = elemDeclaration.getValueConstraintDefault();
                this.validateIdentityConstraintDefinitions(elemDeclaration, elemXPathStep);
            }
            this.validateComplexContent(elemXPathStep);
            if (simpleTypeDefinition != null) {
                this.validateSimpleContent(elemXPathStep, simpleTypeDefinition, fixedValue, defaultValue);
            }
        }
        this.xPath.removeXPathStep();
        this.namespaceHandler.levelDown();
        this.validationConfigContext.getDocHandler().endElement(uri, localName, qname, isEmpty);
    }

    private void invokeDocHandler_CharData(CharArray data, boolean bDisableOutputEscaping, boolean isTextNode) throws Exception {
        if (isTextNode) {
            this.validationConfigContext.getDocHandler().charData(data, bDisableOutputEscaping);
        } else {
            this.validationConfigContext.getDocHandler().onCDSect(data);
        }
    }

    @Override
    public void startDocument() throws Exception {
        this.validationConfigContext.getDocHandler().startDocument();
    }

    @Override
    public void endDocument() throws Exception {
        this.validateRegisteredValuesForIdentityValidation_ID_IDREF_IDREFS();
        this.validationConfigContext.getDocHandler().endDocument();
    }

    @Override
    public void charData(CharArray data, boolean bDisableOutputEscaping) throws Exception {
        this.processCharData(data, bDisableOutputEscaping, true);
    }

    private void processCharData(CharArray data, boolean bDisableOutputEscaping, boolean isTextNode) throws Exception {
        boolean invokeDocHandler_CharData = true;
        try {
            ElementXPathStep elemXPathStep = (ElementXPathStep)this.xPath.getLastXPathStep();
            if (!elemXPathStep.isSkip()) {
                ElementDeclaration elemDeclaration = elemXPathStep.getElementDeclaration();
                ComplexTypeDefinition complTypeDefinition = this.determineComplexTypeDefinition(elemXPathStep.getTypeDefinition());
                SimpleTypeDefinition simpleTypeDefinition = this.determineSimpleTypeDefinition(elemXPathStep.getTypeDefinition());
                if (simpleTypeDefinition != null) {
                    elemXPathStep.appendValue(data);
                    elemXPathStep.setBDisableOutputEscaping(bDisableOutputEscaping);
                    elemXPathStep.setHasTextNodeChild(isTextNode);
                    invokeDocHandler_CharData = false;
                } else if (!this.isWhitespace(data)) {
                    if (complTypeDefinition.isMixed()) {
                        String valueConstraintFixed;
                        String initialValue = this.reusableObjectsPool.getString(data);
                        if (elemXPathStep.isNil()) {
                            this.collectError(elemXPathStep.getRepresentation(), "Element is declared to be nil. No character children are allowed.");
                        }
                        String string = valueConstraintFixed = elemDeclaration != null ? elemDeclaration.getValueConstraintFixed() : null;
                        if (valueConstraintFixed != null && !valueConstraintFixed.equals(initialValue)) {
                            this.collectError(elemXPathStep.getRepresentation(), "Element is matched to an element declaration, whose {fixed value constraint} is '" + valueConstraintFixed + "'. Value '" + initialValue + "' is not identical to this constraint fixed value.");
                        }
                        IdentityConstraintRegResult regResult = this.identConstrValidator.registerValue(null, this.reusableObjectsPool.getNormalizedString(initialValue, "replace"), elemXPathStep.getRepresentation());
                        this.reusableObjectsPool.reuseIdentityConstraintRegResult(regResult);
                    } else {
                        this.collectError(elemXPathStep.getRepresentation(), "Element is declared to be with complex type. No character children are allowed.");
                    }
                }
            }
        }
        finally {
            if (invokeDocHandler_CharData) {
                this.invokeDocHandler_CharData(data, bDisableOutputEscaping, isTextNode);
            }
        }
    }

    private boolean isWhitespace(CharArray data) {
        int offset;
        char[] chars = data.getData();
        int i = offset = data.getOffset();
        while (i < data.getSize() + offset) {
            char ch = chars[i];
            if (!Symbols.isWhitespace(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void onPI(CharArray target, CharArray data) throws Exception {
        this.validationConfigContext.getDocHandler().onPI(target, data);
    }

    @Override
    public void onComment(CharArray text) throws Exception {
        this.validationConfigContext.getDocHandler().onComment(text);
    }

    @Override
    public void onCDSect(CharArray text) throws Exception {
        this.processCharData(text, false, false);
    }

    @Override
    public void onDTDElement(CharArray name, CharArray model) throws Exception {
        this.validationConfigContext.getDocHandler().onDTDElement(name, model);
    }

    @Override
    public void onDTDAttListStart(CharArray name) throws Exception {
        this.validationConfigContext.getDocHandler().onDTDAttListStart(name);
    }

    @Override
    public void onDTDAttListItem(CharArray name, CharArray attname, String type, String defDecl, CharArray vAttValue, String note) throws Exception {
        this.validationConfigContext.getDocHandler().onDTDAttListItem(name, attname, type, defDecl, vAttValue, note);
    }

    @Override
    public void onDTDAttListEnd() throws Exception {
        this.validationConfigContext.getDocHandler().onDTDAttListEnd();
    }

    @Override
    public void onDTDEntity(Entity entity) throws Exception {
        this.validationConfigContext.getDocHandler().onDTDEntity(entity);
    }

    @Override
    public void onDTDNotation(CharArray name, CharArray pub, CharArray sys) throws Exception {
        this.validationConfigContext.getDocHandler().onDTDNotation(name, pub, sys);
    }

    @Override
    public void startDTD(CharArray name, CharArray pub, CharArray sys) throws Exception {
        this.validationConfigContext.getDocHandler().startDTD(name, pub, sys);
    }

    @Override
    public void endDTD() throws Exception {
        this.validationConfigContext.getDocHandler().endDTD();
    }

    @Override
    public void onContentReference(Reference ref) throws Exception {
        this.validationConfigContext.getDocHandler().onContentReference(ref);
    }

    @Override
    public void startPrefixMapping(CharArray prefix, CharArray uri) throws Exception {
        this.validationConfigContext.getDocHandler().startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(CharArray prefix) throws Exception {
        this.validationConfigContext.getDocHandler().endPrefixMapping(prefix);
    }

    @Override
    public void onWarning(String warning) throws Exception {
        this.validationConfigContext.getDocHandler().onWarning(warning);
    }

    @Override
    public void onCustomEvent(int eventId, Object obj) throws Exception {
        this.validationConfigContext.getDocHandler().onCustomEvent(eventId, obj);
    }

    @Override
    public void onStartContentEntity(CharArray name, boolean isExpandingReferences) throws Exception {
        this.validationConfigContext.getDocHandler().onStartContentEntity(name, isExpandingReferences);
    }

    @Override
    public void onEndContentEntity(CharArray name) throws Exception {
        this.validationConfigContext.getDocHandler().onEndContentEntity(name);
    }

    public void collectError(String nodeWrapperRepresent, String errorMessage) throws SAXException {
        this.collectError(String.valueOf(nodeWrapperRepresent) + " : " + errorMessage);
    }

    public void collectError(String errorMessage) throws SAXException {
        this.errors.add(errorMessage);
        if (this.validationConfigContext.getErrorHandler() != null) {
            this.validationConfigContext.getErrorHandler().error(new SAXParseException("Validation error : " + errorMessage, this.validationConfigContext.getLocator()));
        }
    }

    public String getErrorsRepresentation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nERRORS : \n");
        if (this.errors.size() == 0) {
            buffer.append("none");
        } else {
            int i = 0;
            while (i < this.errors.size()) {
                buffer.append(this.errors.get(i));
                buffer.append("\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    public boolean hasErrors() {
        return this.errors.size() != 0;
    }

    private Loader determineLoader() {
        if (this.loader == null) {
            this.loader = new LoaderImpl();
        }
        this.loader.setEntityResolver(this.entityResolver);
        this.loader.setValidateXSDDoc(this.validateXSDDoc);
        return this.loader;
    }

    private void validateRegisteredValuesForIdentityValidation_ID_IDREF_IDREFS() throws SAXException {
        this.validateRegisteredValuesForIdentityValidation_ID_IDREF();
        this.validateRegisteredValuesForIdentityValidation_ID_IDREFS();
    }

    private void validateRegisteredValuesForIdentityValidation_ID_IDREF() throws SAXException {
        Enumeration enum1 = this.attribRepresentToIdrefValueMapping.keys();
        while (enum1.hasMoreElements()) {
            String attribRepresent = (String)enum1.nextElement();
            String value = (String)this.attribRepresentToIdrefValueMapping.get(attribRepresent);
            if (this.idValues.contains(value)) continue;
            this.collectError(attribRepresent, "Attribute has a type, derived from the {http://www.w3.org/2001/XMLSchema}:IDREF. It's value '" + value + "' is not identical to any of the attribute values which type is derived from the {http://www.w3.org/2001/XMLSchema}:ID.");
        }
    }

    private void validateRegisteredValuesForIdentityValidation_ID_IDREFS() throws SAXException {
        Enumeration enum1 = this.attribRepresentToIdrefValuesMapping.keys();
        while (enum1.hasMoreElements()) {
            String attribRepresent = (String)enum1.nextElement();
            String values = (String)this.attribRepresentToIdrefValuesMapping.get(attribRepresent);
            StringTokenizer valuesTokenizer = new StringTokenizer(values);
            while (valuesTokenizer.hasMoreTokens()) {
                String value = valuesTokenizer.nextToken();
                if (this.idValues.contains(value)) continue;
                this.collectError(attribRepresent, "Attribute has a type, derived from {http://www.w3.org/2001/XMLSchema}:IDREFS. The value '" + value + "' is not identical to any of the attribute values which type is derived from the {http://www.w3.org/2001/XMLSchema}:ID.");
            }
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver(EntityResolver entityResolver) {
        return entityResolver;
    }

    public XPath getXPath() {
        return this.xPath;
    }

    public void setCanonicalizationProcessing(boolean canonicalProcessing) {
        this.canonicalProcessing = canonicalProcessing;
    }

    public boolean getCanonicalizationProcessing() {
        return this.canonicalProcessing;
    }

    public void setValidateXSDDoc(boolean validateXSDDoc) {
        this.validateXSDDoc = validateXSDDoc;
    }

    public boolean getValidateXSDDoc() {
        return this.validateXSDDoc;
    }
}

