/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.automat;

import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.validator.automat.AllAutomatState;
import com.sap.engine.lib.schema.validator.automat.AutomatState;
import com.sap.engine.lib.schema.validator.automat.GroupAutomat;
import com.sap.engine.lib.schema.validator.automat.ParticleAutomat;
import com.sap.engine.lib.schema.validator.automat.Switch;
import java.util.Vector;

public final class AllAutomat
extends GroupAutomat {
    private Vector privateParticleAutomats;
    private ModelGroup modelGroupAll;

    protected AllAutomat(ModelGroup modelGroup) {
        super(modelGroup);
        this.modelGroupAll = modelGroup;
        this.privateParticleAutomats = new Vector(this.particleAutomats);
    }

    @Override
    public Switch switchState(String uri, String name) {
        int i = 0;
        while (i < this.privateParticleAutomats.size()) {
            ParticleAutomat particleAutomat = (ParticleAutomat)this.privateParticleAutomats.get(i);
            Switch switchResult = particleAutomat.switchState(uri, name);
            if (switchResult != null) {
                this.isUntouched = false;
                particleAutomat.reset();
                this.privateParticleAutomats.removeElementAt(i);
                switchResult.scopeModelGroupAll = this.modelGroupAll;
                return switchResult;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.privateParticleAutomats.clear();
        this.privateParticleAutomats.addAll(this.particleAutomats);
    }

    @Override
    protected boolean isSatisfied() {
        int i = 0;
        while (i < this.privateParticleAutomats.size()) {
            ParticleAutomat particleAutomat = (ParticleAutomat)this.privateParticleAutomats.get(i);
            if (!particleAutomat.isSatisfied()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected boolean isDrained() {
        return this.privateParticleAutomats.size() == 0;
    }

    @Override
    protected AutomatState createState() {
        return new AllAutomatState();
    }

    @Override
    protected void initState(AutomatState state) {
        super.initState(state);
        AllAutomatState allAutomatState = (AllAutomatState)state;
        allAutomatState.privateParticleAutomats = new Vector(this.privateParticleAutomats);
    }

    @Override
    protected void setState(AutomatState state) {
        super.setState(state);
        AllAutomatState allAutomatState = (AllAutomatState)state;
        this.privateParticleAutomats.clear();
        this.privateParticleAutomats.addAll(allAutomatState.privateParticleAutomats);
    }

    @Override
    protected void initToStringBuffer_GroupCompositor(StringBuffer toStringBuffer) {
        toStringBuffer.append("All");
    }

    @Override
    protected void initExpectedBuffer(StringBuffer expectedBuffer) {
        int i = 0;
        while (i < this.privateParticleAutomats.size()) {
            ParticleAutomat particleAutomat = (ParticleAutomat)this.privateParticleAutomats.get(i);
            particleAutomat.initExpectedBuffer(expectedBuffer);
            ++i;
        }
    }

    @Override
    protected void initExpectedBuffer_Partialy(StringBuffer expectedBuffer, int automatIndex) {
        this.initExpectedBuffer(expectedBuffer);
    }
}

