/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.automat;

import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.validator.automat.Automat;
import com.sap.engine.lib.schema.validator.automat.AutomatState;
import com.sap.engine.lib.schema.validator.automat.GroupAutomatState;
import com.sap.engine.lib.schema.validator.automat.ParticleAutomat;
import java.util.Vector;

public abstract class GroupAutomat
extends Automat {
    protected Vector particleAutomats;
    protected int switchingAutomatIndex;

    protected GroupAutomat(ModelGroup modelGroup) {
        this.initParicleAutomats(modelGroup);
    }

    private void initParicleAutomats(ModelGroup modelGroup) {
        this.particleAutomats = new Vector();
        Vector particles = modelGroup.getParticles();
        int i = 0;
        while (i < particles.size()) {
            Particle particle = (Particle)particles.get(i);
            ParticleAutomat particleAutomat = new ParticleAutomat(particle);
            this.particleAutomats.add(particleAutomat);
            ++i;
        }
    }

    @Override
    protected AutomatState createState() {
        return new GroupAutomatState();
    }

    @Override
    protected void initState(AutomatState state) {
        super.initState(state);
        GroupAutomatState groupAutomatState = (GroupAutomatState)state;
        groupAutomatState.switchingAutomatIndex = this.switchingAutomatIndex;
        ParticleAutomat switchingAutomat = this.determineSwitchingAutomat();
        groupAutomatState.switchingAutomatState = switchingAutomat == null ? null : switchingAutomat.getState();
    }

    @Override
    protected void setState(AutomatState state) {
        super.setState(state);
        GroupAutomatState groupAutomatState = (GroupAutomatState)state;
        this.switchingAutomatIndex = groupAutomatState.switchingAutomatIndex;
        ParticleAutomat switchingAutomat = this.determineSwitchingAutomat();
        if (switchingAutomat != null) {
            switchingAutomat.setState(groupAutomatState.switchingAutomatState);
        }
    }

    @Override
    protected void reset() {
        if (!this.isUntouched) {
            super.reset();
            ParticleAutomat switchingAutomat = this.determineSwitchingAutomat();
            if (switchingAutomat != null) {
                switchingAutomat.reset();
            }
            this.switchingAutomatIndex = 0;
        }
    }

    protected ParticleAutomat determineSwitchingAutomat() {
        if (this.particleAutomats.size() != 0) {
            ParticleAutomat switchingAutomat = (ParticleAutomat)this.particleAutomats.get(this.switchingAutomatIndex);
            return switchingAutomat;
        }
        return null;
    }

    @Override
    protected void initToStringBuffer(StringBuffer toStringBuffer, String offset) {
        toStringBuffer.append(offset);
        this.initToStringBuffer_GroupCompositor(toStringBuffer);
        this.initToStringBuffer_Automats(toStringBuffer, String.valueOf(offset) + "    ");
    }

    protected void initToStringBuffer_Automats(StringBuffer toStringBuffer, String offset) {
        int i = 0;
        while (i < this.particleAutomats.size()) {
            toStringBuffer.append("\n");
            ParticleAutomat automat = (ParticleAutomat)this.particleAutomats.get(i);
            automat.initToStringBuffer(toStringBuffer, offset);
            ++i;
        }
    }

    protected abstract void initToStringBuffer_GroupCompositor(StringBuffer var1);

    protected abstract void initExpectedBuffer_Partialy(StringBuffer var1, int var2);
}

