/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.impl.ffacets.Value;
import com.sap.engine.lib.schema.util.MappingCollectorPool;
import com.sap.engine.lib.schema.validator.SchemaDocHandler;
import com.sap.engine.lib.schema.validator.identity.IdentityConstraintRegResult;
import com.sap.engine.lib.schema.validator.identity.KeySequence;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.IdentityConstraintXPathMatcher;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.XPathMatchResult;
import org.xml.sax.SAXException;

public abstract class IdentityConstraintValidator {
    protected SchemaDocHandler schemaDocHandler;
    protected IdentityConstraintDefinition identConstrDefinition;
    protected IdentityConstraintXPathMatcher matcher;
    protected int contextXPathOffset;
    protected MappingCollectorPool selectorRepresentToKeySequenceMapping;

    protected IdentityConstraintValidator(SchemaDocHandler schemaDocHandler, IdentityConstraintDefinition identConstrDefinition, IdentityConstraintXPathMatcher matcher) {
        this.schemaDocHandler = schemaDocHandler;
        this.identConstrDefinition = identConstrDefinition;
        this.matcher = matcher;
        this.selectorRepresentToKeySequenceMapping = new MappingCollectorPool();
    }

    protected void setContextXPathOffset(int contextXPathOffset) {
        this.contextXPathOffset = contextXPathOffset;
    }

    protected IdentityConstraintDefinition getIdentityConstraintDefinition() {
        return this.identConstrDefinition;
    }

    protected void registerValue(IdentityConstraintRegResult result, Value ffacetsValue, String value, String represent) throws SAXException {
        XPathMatchResult matchResult = this.matcher.match(this.contextXPathOffset);
        if (matchResult != null) {
            int selectorXPathStepIndex = matchResult.getSelectorXPathStepIndex();
            int fieldIndex = matchResult.getFieldIndex();
            String selectorRepresent = this.schemaDocHandler.getXPath().getXPathStep(selectorXPathStepIndex).getRepresentation();
            KeySequence keySequence = (KeySequence)this.selectorRepresentToKeySequenceMapping.get(selectorRepresent);
            if (keySequence != null) {
                if (keySequence.isRegistered(fieldIndex)) {
                    this.schemaDocHandler.collectError("Field '" + matchResult.getFieldXPathExpression() + "' matches more than one value within the scope of it's selector (identity constraint definition '" + this.identConstrDefinition.getQualifiedKey() + "').");
                    result.setRegistrationFail(true);
                    return;
                }
            } else {
                keySequence = this.schemaDocHandler.getReusableObjectsPool().getKeySequence();
                keySequence.setSchemaDocHandler(this.schemaDocHandler);
                keySequence.setKeyCount(this.matcher.getFieldXPathMatchersCount());
                this.selectorRepresentToKeySequenceMapping.put(selectorRepresent, keySequence);
            }
            keySequence.registerValue(ffacetsValue, value, represent, fieldIndex);
            result.setValueIsRegistered(true);
        }
    }

    protected void clear() {
        while (this.selectorRepresentToKeySequenceMapping.size() > 0) {
            KeySequence keySequence = (KeySequence)this.selectorRepresentToKeySequenceMapping.remove(this.selectorRepresentToKeySequenceMapping.size() - 1);
            this.schemaDocHandler.getReusableObjectsPool().reuseKeySequence(keySequence);
        }
    }

    public abstract boolean validate() throws SAXException;
}

