/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.impl.ffacets.Value;
import com.sap.engine.lib.schema.validator.SchemaDocHandler;
import com.sap.engine.lib.schema.validator.identity.IdentityConstraintRegResult;
import com.sap.engine.lib.schema.validator.identity.IdentityConstraintValidator;
import com.sap.engine.lib.schema.validator.identity.KeyIdentityConstraintValidator;
import com.sap.engine.lib.schema.validator.identity.KeyrefIdentityConstraintValidator;
import com.sap.engine.lib.schema.validator.identity.UniqueIdentityConstraintValidator;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.XPathTokenizer;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.SAXException;

public final class IdentityConstraintsValidator {
    private SchemaDocHandler schemaDocHandler;
    private Vector registeredValidators;
    private Hashtable qKeyToUnregisteredValidatorsMapping;
    private XPathTokenizer xPathTokenizer;

    public IdentityConstraintsValidator(SchemaDocHandler schemaDocHandler) {
        this.schemaDocHandler = schemaDocHandler;
        this.registeredValidators = new Vector();
        this.qKeyToUnregisteredValidatorsMapping = new Hashtable();
        this.xPathTokenizer = new XPathTokenizer(schemaDocHandler.getXPath());
    }

    public void registerValidators(Vector identityConstrDefinitions, int contextXPathStepsCount) {
        Vector<IdentityConstraintValidator> keyrefIdentConstrValidators = new Vector<IdentityConstraintValidator>();
        int i = 0;
        while (i < identityConstrDefinitions.size()) {
            IdentityConstraintDefinition identConstrDefinition = (IdentityConstraintDefinition)identityConstrDefinitions.get(i);
            IdentityConstraintValidator validator = (IdentityConstraintValidator)this.qKeyToUnregisteredValidatorsMapping.get(identConstrDefinition.getQualifiedKey());
            if (validator == null) {
                if (identConstrDefinition.isIdentityConstraintCategoryKey()) {
                    validator = new KeyIdentityConstraintValidator(this.schemaDocHandler, identConstrDefinition, this.schemaDocHandler.getReusableObjectsPool().getIdentityConstraintXPathMatcher(identConstrDefinition, this.xPathTokenizer));
                } else if (identConstrDefinition.isIdentityConstraintCategoryUnique()) {
                    validator = new UniqueIdentityConstraintValidator(this.schemaDocHandler, identConstrDefinition, this.schemaDocHandler.getReusableObjectsPool().getIdentityConstraintXPathMatcher(identConstrDefinition, this.xPathTokenizer));
                } else {
                    validator = new KeyrefIdentityConstraintValidator(this.schemaDocHandler, identConstrDefinition, this.schemaDocHandler.getReusableObjectsPool().getIdentityConstraintXPathMatcher(identConstrDefinition, this.xPathTokenizer));
                    keyrefIdentConstrValidators.add(validator);
                }
            } else {
                this.qKeyToUnregisteredValidatorsMapping.remove(identConstrDefinition.getQualifiedKey());
            }
            validator.setContextXPathOffset(contextXPathStepsCount);
            this.registeredValidators.add(validator);
            ++i;
        }
        i = 0;
        while (i < keyrefIdentConstrValidators.size()) {
            KeyrefIdentityConstraintValidator keyrefIdentConstrvalidator = (KeyrefIdentityConstraintValidator)keyrefIdentConstrValidators.get(i);
            IdentityConstraintDefinition refKeyIdentConstrDefinition = keyrefIdentConstrvalidator.getIdentityConstraintDefinition().getReferencedKey();
            int j = this.registeredValidators.size() - 1;
            while (j >= 0) {
                IdentityConstraintValidator registeredIdentConstrValidator = (IdentityConstraintValidator)this.registeredValidators.get(j);
                if (registeredIdentConstrValidator.getIdentityConstraintDefinition().getQualifiedKey().equals(refKeyIdentConstrDefinition.getQualifiedKey())) {
                    keyrefIdentConstrvalidator.setReferedIdentityConstraintValidator(registeredIdentConstrValidator);
                    break;
                }
                --j;
            }
            ++i;
        }
    }

    public boolean validate(Vector identityConstrDefinitions) throws SAXException {
        boolean result = true;
        int i = 0;
        while (i < identityConstrDefinitions.size()) {
            IdentityConstraintValidator validator = (IdentityConstraintValidator)this.registeredValidators.get(this.registeredValidators.size() - 1 - i);
            result = result && validator.validate();
            ++i;
        }
        return result;
    }

    public void unregisterValidators(Vector identityConstrDefinitions) {
        int i = 0;
        while (i < identityConstrDefinitions.size()) {
            this.unregisterLastValidator();
            ++i;
        }
    }

    private void unregisterLastValidator() {
        IdentityConstraintValidator validator = (IdentityConstraintValidator)this.registeredValidators.remove(this.registeredValidators.size() - 1);
        validator.clear();
        this.qKeyToUnregisteredValidatorsMapping.put(validator.getIdentityConstraintDefinition().getQualifiedKey(), validator);
    }

    public IdentityConstraintRegResult registerValue(Value ffacetsValue, String value, String represent) throws SAXException {
        IdentityConstraintRegResult result = this.schemaDocHandler.getReusableObjectsPool().getIdentityConstraintRegResult();
        int i = 0;
        while (i < this.registeredValidators.size()) {
            IdentityConstraintValidator validator = (IdentityConstraintValidator)this.registeredValidators.get(i);
            validator.registerValue(result, ffacetsValue, value, represent);
            ++i;
        }
        return result;
    }
}

