/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.validator.SchemaDocHandler;
import com.sap.engine.lib.schema.validator.identity.IdentityConstraintValidator;
import com.sap.engine.lib.schema.validator.identity.KeySequence;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.IdentityConstraintXPathMatcher;
import java.util.Vector;
import org.xml.sax.SAXException;

public final class KeyIdentityConstraintValidator
extends IdentityConstraintValidator {
    protected KeyIdentityConstraintValidator(SchemaDocHandler schemaDocHandler, IdentityConstraintDefinition identConstrDefinition, IdentityConstraintXPathMatcher matcher) {
        super(schemaDocHandler, identConstrDefinition, matcher);
    }

    @Override
    public boolean validate() throws SAXException {
        Vector keySequences = this.selectorRepresentToKeySequenceMapping.values();
        int i = 0;
        while (i < keySequences.size()) {
            KeySequence keySequence1 = (KeySequence)keySequences.get(i);
            if (keySequence1.isQualified()) {
                int j = i + 1;
                while (j < keySequences.size()) {
                    KeySequence keySequence2 = (KeySequence)keySequences.get(j);
                    if (keySequence2.isQualified()) {
                        if (keySequence1.match(keySequence2)) {
                            this.schemaDocHandler.collectError("Node sequence " + keySequence1.getRepresentation() + " is identical to the node sequence " + keySequence2.getRepresentation() + ". (identity constraint definition '" + this.identConstrDefinition.getQualifiedKey() + "').");
                            return false;
                        }
                    } else {
                        this.schemaDocHandler.collectError("Node sequence " + keySequence2.getRepresentation() + " has to be qualified. All of the {fields}, with the node selected by the {selector} as a context node, should select exactly one node (identity constraint definition '" + this.identConstrDefinition.getQualifiedKey() + "').");
                        return false;
                    }
                    ++j;
                }
            } else {
                this.schemaDocHandler.collectError("Node sequence " + keySequence1.getRepresentation() + " has to be qualified. All of the {fields}, with the node selected by the {selector} as a context node, should select exactly one node (identity constraint definition '" + this.identConstrDefinition.getQualifiedKey() + "').");
                return false;
            }
            ++i;
        }
        return true;
    }
}

