/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.components.impl.ffacets.Value;
import com.sap.engine.lib.schema.validator.SchemaDocHandler;
import com.sap.engine.lib.schema.validator.identity.KeyWrapper;
import org.xml.sax.SAXException;

public final class KeySequence {
    private KeyWrapper[] keyWrappers;
    private int registeredKeys = 0;
    private SchemaDocHandler schemaDocHandler;

    protected void setSchemaDocHandler(SchemaDocHandler schemaDocHandler) {
        this.schemaDocHandler = schemaDocHandler;
    }

    protected void setKeyCount(int keysCount) {
        this.keyWrappers = new KeyWrapper[keysCount];
    }

    public KeyWrapper[] getKeyWrappers() {
        return this.keyWrappers;
    }

    protected boolean isRegistered(int keyIndex) {
        return this.keyWrappers[keyIndex] != null;
    }

    protected void registerValue(Value ffacetsValue, String value, String represent, int keyIndex) throws SAXException {
        KeyWrapper keyWrapper = this.schemaDocHandler.getReusableObjectsPool().getKeyWrapper();
        keyWrapper.setSchemaDocHandler(this.schemaDocHandler);
        keyWrapper.setFFacetsValue(ffacetsValue);
        keyWrapper.setValue(value);
        keyWrapper.setNodeRepresentation(represent);
        this.keyWrappers[keyIndex] = keyWrapper;
        ++this.registeredKeys;
    }

    protected boolean match(KeySequence keySequence) {
        if (this.keyWrappers.length != keySequence.keyWrappers.length) {
            return false;
        }
        int i = 0;
        while (i < this.keyWrappers.length) {
            if (!this.keyWrappers[i].match(keySequence.keyWrappers[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isQualified() {
        return this.registeredKeys == this.keyWrappers.length;
    }

    protected String getRepresentation() {
        StringBuffer representBuffer = this.schemaDocHandler.getReusableObjectsPool().getStringBuffer();
        representBuffer.append("[");
        int i = 0;
        while (i < this.keyWrappers.length) {
            KeyWrapper keyWrapper = this.keyWrappers[i];
            representBuffer.append(keyWrapper == null ? "no selection" : keyWrapper.getRepresentation());
            representBuffer.append(i == this.keyWrappers.length - 1 ? "]" : "; ");
            ++i;
        }
        String represent = representBuffer.toString();
        this.schemaDocHandler.getReusableObjectsPool().reuseStringBuffer(representBuffer);
        return represent;
    }

    public void reuse() {
        this.registeredKeys = 0;
    }
}

