/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.validator.SchemaDocHandler;
import com.sap.engine.lib.schema.validator.identity.IdentityConstraintValidator;
import com.sap.engine.lib.schema.validator.identity.KeySequence;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.IdentityConstraintXPathMatcher;
import java.util.Vector;
import org.xml.sax.SAXException;

public final class KeyrefIdentityConstraintValidator
extends IdentityConstraintValidator {
    private IdentityConstraintValidator referedIdentityConstraintValidator;

    protected KeyrefIdentityConstraintValidator(SchemaDocHandler schemaDocHandler, IdentityConstraintDefinition identConstrDefinition, IdentityConstraintXPathMatcher matcher) {
        super(schemaDocHandler, identConstrDefinition, matcher);
    }

    protected void setReferedIdentityConstraintValidator(IdentityConstraintValidator referedIdentityConstraintValidator) {
        this.referedIdentityConstraintValidator = referedIdentityConstraintValidator;
    }

    @Override
    public boolean validate() throws SAXException {
        boolean result = true;
        Vector keySequences = this.selectorRepresentToKeySequenceMapping.values();
        int i = 0;
        while (i < keySequences.size()) {
            KeySequence keySequence1 = (KeySequence)keySequences.get(i);
            if (keySequence1.isQualified()) {
                boolean hasDublicate = false;
                if (this.referedIdentityConstraintValidator != null) {
                    int j = 0;
                    while (j < this.referedIdentityConstraintValidator.selectorRepresentToKeySequenceMapping.values().size()) {
                        KeySequence keySequence2 = (KeySequence)this.referedIdentityConstraintValidator.selectorRepresentToKeySequenceMapping.values().get(j);
                        if (keySequence2.isQualified() && keySequence1.match(keySequence2)) {
                            hasDublicate = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!hasDublicate) {
                    result = false;
                    this.schemaDocHandler.collectError("Node sequence " + keySequence1.getRepresentation() + " does not have a duplicate among the selected node sequences from the refered identity constraint definition (identity constraint definition '" + this.identConstrDefinition.getQualifiedKey() + "').");
                }
            }
            ++i;
        }
        return result;
    }
}

