/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity.xpathmatcher;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.FieldXPathMatcher;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.XPathMatchResult;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.XPathTokenizer;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Vector;

public final class IdentityConstraintXPathMatcher {
    private FieldXPathMatcher[] fieldMatchers;

    public IdentityConstraintXPathMatcher(XPathTokenizer xPathTokenizer, IdentityConstraintDefinition identCostrDefinition) {
        String selectorXPathExpression = identCostrDefinition.getSelector();
        Vector fieldsXPathExpressionsCollector = identCostrDefinition.getFields();
        this.fieldMatchers = new FieldXPathMatcher[fieldsXPathExpressionsCollector.size()];
        int i = 0;
        while (i < fieldsXPathExpressionsCollector.size()) {
            String fieldXPathExpression = (String)fieldsXPathExpressionsCollector.get(i);
            this.fieldMatchers[i] = new FieldXPathMatcher(xPathTokenizer, selectorXPathExpression, fieldXPathExpression, DOM.getNamespaceMappingsInScope(identCostrDefinition.getAssociatedDOMNode()));
            ++i;
        }
    }

    public int getFieldXPathMatchersCount() {
        return this.fieldMatchers.length;
    }

    public XPathMatchResult match(int contextXPathStepsCount) {
        int i = 0;
        while (i < this.fieldMatchers.length) {
            XPathMatchResult matchResult = this.fieldMatchers[i].matches(contextXPathStepsCount);
            if (matchResult != null) {
                matchResult.setFieldIndex(i);
                return matchResult;
            }
            ++i;
        }
        return null;
    }
}

