/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity.xpathmatcher;

import com.sap.engine.lib.schema.util.LexicalTokenizer;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.AttributeMatchingStructure;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.ChildElementMatchingStructure;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.ChoiceElementMatchingStructure;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.ContextElementMatchingStructure;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.DescendentAttributeMatchingStructure;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.DescendentElementMatchingStructure;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.ElementMatchingStructure;
import com.sap.engine.lib.schema.validator.identity.xpathmatcher.NodeMatchingStructure;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class NodeMatchingStructureFactory {
    protected static NodeMatchingStructure create(String xPathExpr, Hashtable prefixesMapping) {
        if (xPathExpr.indexOf("|") >= 0) {
            return NodeMatchingStructureFactory.createChoiceNodeMatchingStructure(xPathExpr, prefixesMapping);
        }
        return NodeMatchingStructureFactory.createNodeMatchingStructure(xPathExpr, prefixesMapping);
    }

    private static NodeMatchingStructure createNodeMatchingStructure(String xPathExpression, Hashtable prefixesMapping) {
        return NodeMatchingStructureFactory.createNodeMatchingStructure(new LexicalTokenizer(xPathExpression, new String[]{"//", "/"}), prefixesMapping);
    }

    private static ElementMatchingStructure createChoiceNodeMatchingStructure(String xPathExpression, Hashtable prefixesMapping) {
        StringTokenizer strTokenizer = new StringTokenizer(xPathExpression, "|");
        NodeMatchingStructure[] structures = new NodeMatchingStructure[strTokenizer.countTokens()];
        int i = 0;
        while (i < structures.length) {
            String elemMatchingStrucXPathExpr = strTokenizer.nextToken();
            structures[i] = NodeMatchingStructureFactory.createNodeMatchingStructure(elemMatchingStrucXPathExpr, prefixesMapping);
            ++i;
        }
        return new ChoiceElementMatchingStructure(structures);
    }

    private static NodeMatchingStructure createNodeMatchingStructure(LexicalTokenizer tokenizer, Hashtable prefixesMapping) {
        String token = null;
        while ((token = tokenizer.next()) != null) {
            if (token.equals("/")) continue;
            if (token.equals("//")) {
                token = tokenizer.next();
                if (token.equals(".")) continue;
                if (token.startsWith("@")) {
                    token = token.substring(1);
                    String[] uriAndName = NodeMatchingStructureFactory.parseQName(token, prefixesMapping);
                    return new DescendentAttributeMatchingStructure(uriAndName[0], uriAndName[1]);
                }
                String[] uriAndName = NodeMatchingStructureFactory.parseQName(token, prefixesMapping);
                return new DescendentElementMatchingStructure(uriAndName[0], uriAndName[1], NodeMatchingStructureFactory.createNodeMatchingStructure(tokenizer, prefixesMapping));
            }
            if (token.startsWith("@")) {
                token = token.substring(1);
                String[] uriAndName = NodeMatchingStructureFactory.parseQName(token, prefixesMapping);
                return new AttributeMatchingStructure(uriAndName[0], uriAndName[1]);
            }
            if (token.startsWith(".")) {
                return new ContextElementMatchingStructure(NodeMatchingStructureFactory.createNodeMatchingStructure(tokenizer, prefixesMapping));
            }
            String[] uriAndName = NodeMatchingStructureFactory.parseQName(token, prefixesMapping);
            return new ChildElementMatchingStructure(uriAndName[0], uriAndName[1], NodeMatchingStructureFactory.createNodeMatchingStructure(tokenizer, prefixesMapping));
        }
        return null;
    }

    private static String[] parseQName(String qName, Hashtable prefixesMapping) {
        if (qName.equals("*")) {
            return new String[2];
        }
        String[] prefixAndName = Tools.parseQName(qName);
        String prefix = prefixAndName[0];
        String name = prefixAndName[1].equals("*") ? null : prefixAndName[1];
        String uri = null;
        if (prefix == null || prefix.equals("")) {
            uri = "";
        } else {
            uri = (String)prefixesMapping.get(prefix);
            if (uri == null) {
                uri = "";
            }
        }
        return new String[]{uri, name};
    }
}

