/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.regexp;

import com.sap.engine.lib.schema.exception.SchemaRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class RegularExpression {
    private static final String SUN_REG_EXP_CLASS_NAME = "com.sun.org.apache.xerces.internal.impl.xpath.regex.RegularExpression";
    private static final String IBM_REG_EXP_CLASS_NAME = "org.apache.xerces.impl.xpath.regex.RegularExpression";
    private static final String REG_EXP_MATCHES_METHOD_NAME = "matches";
    private static final Class[] REG_EXP_MATCHES_METHOD_PARAM_CLASSES = new Class[]{String.class};
    private static final Class[] REG_EXP_CONSTRUCTOR_PARAM_CLASSES = new Class[]{String.class, String.class};
    private Object regExp;
    private Method regExpMatchesMethod;

    public RegularExpression(String regExpString) {
        try {
            Class regExpClass = this.loadRegularExpressionClass();
            this.regExp = this.createRegularExpression(regExpClass, regExpString);
            this.regExpMatchesMethod = regExpClass.getDeclaredMethod(REG_EXP_MATCHES_METHOD_NAME, REG_EXP_MATCHES_METHOD_PARAM_CLASSES);
        }
        catch (Exception exc) {
            throw new SchemaRuntimeException(exc);
        }
    }

    private final Class loadRegularExpressionClass() throws ClassNotFoundException {
        try {
            return Class.forName(SUN_REG_EXP_CLASS_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(IBM_REG_EXP_CLASS_NAME);
        }
    }

    private final Object createRegularExpression(Class _class, String regExpString) throws Exception {
        Constructor regExpConstructor = _class.getDeclaredConstructor(REG_EXP_CONSTRUCTOR_PARAM_CLASSES);
        return regExpConstructor.newInstance(regExpString, "X");
    }

    public final boolean matches(String value) {
        try {
            Boolean matchesResult = (Boolean)this.regExpMatchesMethod.invoke(this.regExp, (Object[])new String[]{value});
            return matchesResult;
        }
        catch (Exception exc) {
            throw new SchemaRuntimeException(exc);
        }
    }
}

