/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.xpath;

import com.sap.engine.lib.schema.validator.ReusableObjectsPool;
import com.sap.engine.lib.schema.validator.xpath.AttributeXPathStep;
import com.sap.engine.lib.schema.validator.xpath.ElementXPathStep;
import com.sap.engine.lib.schema.validator.xpath.XPathStep;
import java.util.Vector;

public final class XPath {
    private Vector xPathSteps = new Vector();
    private ReusableObjectsPool pool;

    public XPath(ReusableObjectsPool pool) {
        this.pool = pool;
    }

    public int getXPathStepsCount() {
        return this.xPathSteps.size();
    }

    public ElementXPathStep getParentElementXPathStep() {
        return this.xPathSteps.size() > 1 ? (ElementXPathStep)this.xPathSteps.get(this.xPathSteps.size() - 2) : null;
    }

    public XPathStep getLastXPathStep() {
        return (XPathStep)this.xPathSteps.lastElement();
    }

    public void addXPathStep(XPathStep xPathStep) {
        this.xPathSteps.add(xPathStep);
    }

    public void removeXPathStep() {
        XPathStep xPathStep = (XPathStep)this.xPathSteps.remove(this.xPathSteps.size() - 1);
        if (xPathStep instanceof ElementXPathStep) {
            this.pool.reuseElementXPathStep(xPathStep);
        } else {
            ElementXPathStep elemXPathstep = (ElementXPathStep)this.xPathSteps.lastElement();
            elemXPathstep.removeAttributeXPathStep((AttributeXPathStep)xPathStep);
            this.pool.reuseAttributeXPathStep(xPathStep);
        }
    }

    public Vector getXPathSteps() {
        return this.xPathSteps;
    }

    public XPathStep getXPathStep(int index) {
        return (XPathStep)this.xPathSteps.get(index);
    }
}

