/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom;

import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.dom.ElementImpl;
import com.sap.engine.lib.xml.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

@Deprecated
public class AttrImpl
extends NodeImpl
implements Attr {
    private String qname = null;
    private String localName = null;
    private String prefix = null;
    private String namespaceURI = null;
    private String value = "";
    private NodeImpl ownerElement = null;
    boolean specified = true;
    private boolean isDefaultAttribute = false;
    AttrImpl overridden = null;
    private boolean bUseNS = false;

    public AttrImpl() {
        this.setParent(null);
    }

    public AttrImpl(Document owner) {
        this.setParent(null);
        this.setOwnerDocument(owner);
    }

    private void checkQualifedName(String namespaceURI, String qualifiedName, boolean useNS) {
        int indexOfColon;
        if (qualifiedName == null) {
            throw new IllegalArgumentException();
        }
        if (!Symbols.isName(qualifiedName)) {
            throw new DOMException(5, "'" + qualifiedName + "' is not a valid name.");
        }
        if (!useNS) {
            return;
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if ((indexOfColon = qualifiedName.indexOf(58)) != qualifiedName.lastIndexOf(58)) {
            throw new DOMException(14, "More than one ':' in qualified name, '" + qualifiedName + "'");
        }
        if (indexOfColon != -1) {
            String prefix = qualifiedName.substring(0, indexOfColon);
            if (prefix.equals("xml") && !namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                throw new DOMException(14, "Prefix is 'xml', but URI is not 'http://www.w3.org/XML/1998/namespace' in the qualified name, '" + qualifiedName + "'");
            }
            if (prefix.equals("xmlns") && !namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                throw new DOMException(14, "Prefix is 'xmlns', but URI is not 'http://www.w3.org/2000/xmlns/' in the qualified name, '" + qualifiedName + "'");
            }
            if (namespaceURI.length() == 0) {
                throw new DOMException(14, "There is a prefix, but the URI is null");
            }
        } else if (qualifiedName.equals("xmlns") && !namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            throw new DOMException(14, "QName is 'xmlns', but URI is not 'http://www.w3.org/2000/xmlns/' in the qualified name, '" + qualifiedName + "'");
        }
    }

    public final AttrImpl init(String uri, String qname, boolean useNS, String value, NodeImpl owner, boolean doCheck, boolean isSpecified) {
        if (doCheck) {
            this.checkQualifedName(uri, qname, useNS);
        }
        if (!useNS && qname.startsWith("xmlns")) {
            useNS = true;
            uri = "http://www.w3.org/2000/xmlns/";
        }
        this.bUseNS = useNS;
        this.qname = qname;
        this.ownerElement = owner;
        if (useNS) {
            this.prefix = DOM.qnameToPrefix(qname);
            if (this.prefix != null && this.prefix.length() == 0) {
                this.prefix = null;
            }
            this.localName = DOM.qnameToLocalName(qname);
            this.namespaceURI = uri;
        } else {
            this.prefix = null;
            this.localName = null;
            this.namespaceURI = null;
        }
        this.value = value == null ? "" : value;
        this.specified = isSpecified;
        this.isDefaultAttribute = !isSpecified;
        return this;
    }

    public final AttrImpl init(String name, NodeImpl owner) {
        this.init(null, name, false, null, owner, true, true);
        return this;
    }

    public final AttrImpl init(String name, NodeImpl owner, String value) {
        return this.init(null, name, false, value, owner, true, true);
    }

    public final AttrImpl init(String uri, String name, NodeImpl owner) {
        return this.init(uri, name, true, null, owner, true, true);
    }

    public final AttrImpl init(String uri, String name, NodeImpl owner, String value) {
        return this.init(uri, name, true, value, owner, true, true);
    }

    @Override
    public String getName() {
        return this.qname;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public Element getOwnerElement() {
        return (ElementImpl)this.ownerElement;
    }

    @Override
    public boolean getSpecified() {
        return !this.isDefaultAttribute && this.specified;
    }

    @Override
    public String getNodeName() {
        return this.qname;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.value;
    }

    @Override
    public void setNodeValue(String value) throws DOMException {
        this.value = value;
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    public void setOwner(NodeImpl owner) {
        this.ownerElement = owner;
    }

    @Override
    public Node cloneNode(boolean deep) {
        AttrImpl result = new AttrImpl();
        result.init(this.namespaceURI, this.qname, this.bUseNS, this.value, null, false, this.specified);
        this.transferData(this, result, deep);
        result.setOwnerDocument(this.getOwnerDocument());
        return result;
    }

    @Override
    public String getNamespaceURI() {
        if (this.namespaceURI == null || this.namespaceURI.length() == 0) {
            return null;
        }
        return this.namespaceURI;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        if (prefix == null || !Symbols.isName(prefix)) {
            throw new DOMException(5, "Invalid prefix");
        }
        if (this.namespaceURI == null || prefix.equals("xml") && !this.namespaceURI.equals("http://www.w3.org/XML/1998/namespace") || prefix.equals("xmlns") && !this.namespaceURI.equals("http://www.w3.org/2000/xmlns/") || this.qname.equals("xmlns")) {
            throw new DOMException(14, "Invalid prefix: 'xml', 'xmlns', or a QName that is 'xmlns'");
        }
        if (!Symbols.isNCName(prefix)) {
            throw new DOMException(14, "Invalid prefix, '" + prefix + "'");
        }
        this.prefix = prefix.trim();
        this.repairName();
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    private void repairName() {
        if (this.prefix == null) {
            return;
        }
        if (this.prefix.equals("")) {
            this.prefix = null;
            return;
        }
        this.qname = String.valueOf(this.prefix) + this.localName;
    }

    public String toString() {
        String ret = String.valueOf(this.getName()) + "='" + this.getValue() + "'";
        return ret;
    }

    @Override
    public void normalize() {
    }

    @Override
    protected boolean checkChildNodeType(Node node) {
        short t = node.getNodeType();
        return t == 3 || t == 5;
    }

    protected boolean isDefaultAttribute() {
        return this.isDefaultAttribute;
    }

    protected void setDefaultAttribute(boolean defaultAttribute) {
        this.isDefaultAttribute = defaultAttribute;
    }

    protected AttrImpl getOverridden() {
        return this.overridden;
    }

    protected void setOverriden(AttrImpl overriden) {
        this.overridden = overriden;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public boolean isId() {
        return false;
    }
}

