/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom;

import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.dom.AttrImpl;
import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.dom.DocumentTypeImpl;
import com.sap.engine.lib.xml.dom.NodeImpl;
import java.io.Serializable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

@Deprecated
public class ElementImpl
extends NodeImpl
implements Element,
NodeList {
    private static final int INITIAL_N_ATTRIBUTES = 4;
    private NodeImpl parent;
    private String name;
    private String prefix;
    private String uri;
    private String local;
    private AttrImpl[] attributes = null;
    private int nAttributes;
    private NamedNodeMapImplForAttributes map = null;

    public ElementImpl() {
    }

    protected ElementImpl(Document owner) {
        this.setOwnerDocument(owner);
    }

    protected void updateDefaultAttributesFromDTD(DocumentTypeImpl dtd) {
        int i = 0;
        while (i < this.nAttributes) {
            if (this.attributes[i].isDefaultAttribute()) {
                --this.nAttributes;
                this.attributes[i] = this.attributes[this.nAttributes];
                continue;
            }
            this.attributes[i].setOverriden(null);
            ++i;
        }
        if (dtd == null) {
            return;
        }
        String[][] a = dtd.getDefaultAttributes(this.name);
        if (a == null) {
            return;
        }
        String[] aQNames = a[0];
        String[] aValues = a[1];
        i = 0;
        while (i < aQNames.length) {
            AttrImpl attrImpl = new AttrImpl(this.getOwnerDocument()).init(DOM.qnameToURI(aQNames[i], this), aQNames[i], true, aValues[i], this, false, false);
            attrImpl.setDefaultAttribute(true);
            boolean becomesOverridden = false;
            int j = 0;
            while (j < this.nAttributes) {
                if (this.attributes[j].getNodeName().equals(aQNames[i])) {
                    this.attributes[j].setOverriden(attrImpl);
                    becomesOverridden = true;
                    break;
                }
                ++j;
            }
            if (!becomesOverridden) {
                if (this.attributes == null) {
                    this.attributes = new AttrImpl[4];
                }
                this.ensureAttributes();
                this.attributes[this.nAttributes] = attrImpl;
                ++this.nAttributes;
            }
            ++i;
        }
    }

    private void checkQualifiedName(String namespaceURI, String qualifiedName, boolean useNS) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException();
        }
        if (!Symbols.isName(qualifiedName)) {
            throw new DOMException(5, "'" + qualifiedName + "' is not a valid name.");
        }
        if (!useNS) {
            return;
        }
        int indexOfColon = qualifiedName.indexOf(58);
        if (indexOfColon != qualifiedName.lastIndexOf(58)) {
            throw new DOMException(14, "More than one ':' in qualified name, '" + qualifiedName + "'");
        }
        if (indexOfColon != -1) {
            if (qualifiedName.startsWith("xml:") && !namespaceURI.equals("http://www.w3.org/XML/1998/namespace")) {
                throw new DOMException(14, "Prefix is 'xml', but URI is not 'http://www.w3.org/XML/1998/namespace' in the qualified name, '" + qualifiedName + "'");
            }
            if (namespaceURI.length() == 0) {
                throw new DOMException(14, "There is a prefix, but the URI is null");
            }
        }
    }

    public final ElementImpl init(String uri, String qname, boolean useNS, NodeImpl parent, boolean doCheck) {
        super.init();
        if (doCheck) {
            this.checkQualifiedName(uri, qname, useNS);
        }
        this.parent = parent;
        this.name = qname;
        if (useNS) {
            this.prefix = DOM.qnameToPrefix(qname);
            if (this.prefix != null && this.prefix.length() == 0) {
                this.prefix = null;
            }
            this.local = DOM.qnameToLocalName(qname);
            this.uri = uri;
        } else {
            this.prefix = null;
            this.local = null;
            this.uri = null;
        }
        this.nAttributes = 0;
        return this;
    }

    public final ElementImpl init(String name, NodeImpl parent) {
        return this.init(null, name, false, parent, true);
    }

    public final ElementImpl init(String uri, String qname, NodeImpl parent) {
        return this.init(uri, qname, true, parent, true);
    }

    @Override
    public String getAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        return attr == null ? "" : attr.getValue();
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        return attr == null ? "" : attr.getValue();
    }

    @Override
    public Attr getAttributeNode(String name) {
        int i = 0;
        while (i < this.nAttributes) {
            if (this.attributes[i].getName().equals(name)) {
                return this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        int i = 0;
        while (i < this.nAttributes) {
            AttrImpl attr = this.attributes[i];
            String attrLocalName = attr.getLocalName();
            if (attrLocalName != null && attrLocalName.equals(localName) && ElementImpl.areNamespaceURIEqual(attr.getNamespaceURI(), namespaceURI)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getTagName() {
        return this.name;
    }

    @Override
    public boolean hasAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        return attr != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        return attr != null;
    }

    @Override
    public void removeAttribute(String name) {
        Attr attr = this.getAttributeNode(name);
        if (attr != null) {
            this.removeAttributeNode(attr);
        }
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) {
        Attr attr = this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            this.removeAttributeNode(attr);
        }
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) {
        AttrImpl oldAttr1 = (AttrImpl)oldAttr;
        if (oldAttr1.isDefaultAttribute()) {
            return oldAttr;
        }
        int i = 0;
        while (i < this.nAttributes) {
            if (this.attributes[i] == oldAttr) {
                if (oldAttr1.getOverridden() == null) {
                    oldAttr1.setOwner(null);
                    --this.nAttributes;
                    this.attributes[i] = this.attributes[this.nAttributes];
                    return oldAttr;
                }
                oldAttr1.setOwner(null);
                this.attributes[i] = oldAttr1.getOverridden();
                return oldAttr1;
            }
            ++i;
        }
        throw new DOMException(8, "Attempt to remove an attribute from an element which is not its owner.");
    }

    @Override
    public void setAttribute(String name, String value) {
        AttrImpl attr = (AttrImpl)this.getAttributeNode(name);
        if (attr != null) {
            if (attr.isDefaultAttribute()) {
                if (attr.getValue().equals(value)) {
                    return;
                }
            } else {
                attr.setNodeValue(value);
                return;
            }
        }
        attr = new AttrImpl(this.getOwnerDocument()).init(name, this, value);
        this.setAttributeNode(attr);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qname, String value) {
        AttrImpl attr = (AttrImpl)this.getAttributeNodeNS(namespaceURI, qname);
        if (attr != null) {
            if (attr.isDefaultAttribute()) {
                if (attr.getValue().equals(value)) {
                    return;
                }
            } else {
                attr.setNodeValue(value);
                return;
            }
        }
        attr = new AttrImpl(this.getOwnerDocument()).init(namespaceURI, qname, this, value);
        this.setAttributeNodeNS(attr);
    }

    private AttrImpl replaceAttr(int index, AttrImpl x) {
        AttrImpl y = this.attributes[index];
        if (y.isDefaultAttribute()) {
            x.setOverriden(y);
            this.attributes[index] = x;
            return null;
        }
        AttrImpl yOverridden = y.getOverridden();
        y.setOverriden(null);
        y.setOwner(null);
        x.setOverriden(yOverridden);
        x.setOwner(this);
        this.attributes[index] = x;
        return y;
    }

    @Override
    public Attr setAttributeNode(Attr newAt) {
        if (newAt == null) {
            throw new IllegalArgumentException("A null attribute cannot be set.");
        }
        AttrImpl newAttr1 = (AttrImpl)newAt;
        Element oe = newAttr1.getOwnerElement();
        if (oe != null && oe != this) {
            throw new DOMException(10, "The attribute node being set already belongs to another element.");
        }
        ElementImpl.checkCompatibleOwnerDocuments(newAttr1, this);
        String newAttrName = newAttr1.getNodeName();
        int i = 0;
        while (i < this.nAttributes) {
            if (newAttrName.equals(this.attributes[i].getNodeName())) {
                return this.replaceAttr(i, newAttr1);
            }
            ++i;
        }
        this.ensureAttributes();
        this.attributes[this.nAttributes] = newAttr1;
        newAttr1.setOwner(this);
        ++this.nAttributes;
        return null;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAt) {
        if (newAt == null) {
            throw new IllegalArgumentException("A null attribute cannot be set.");
        }
        AttrImpl newAttr1 = (AttrImpl)newAt;
        Element oe = newAttr1.getOwnerElement();
        if (oe != null && oe != this) {
            throw new DOMException(10, "The attribute node being set already belongs to another element.");
        }
        ElementImpl.checkCompatibleOwnerDocuments(newAttr1, this);
        String newAttrUri = newAttr1.getNamespaceURI();
        newAttrUri = newAttrUri == null ? "" : newAttrUri;
        String newAttrLocal = newAttr1.getLocalName();
        int i = 0;
        while (i < this.nAttributes) {
            String uri = this.attributes[i].getNamespaceURI();
            String string = uri = uri == null ? "" : uri;
            if (uri.equals(newAttrUri) && this.attributes[i].getLocalName().equals(newAttrLocal)) {
                return this.replaceAttr(i, newAttr1);
            }
            ++i;
        }
        this.ensureAttributes();
        this.attributes[this.nAttributes] = newAttr1;
        newAttr1.setOwner(this);
        ++this.nAttributes;
        return null;
    }

    private void ensureAttributes() {
        if (this.attributes == null) {
            this.attributes = new AttrImpl[4];
        }
        if (this.attributes.length == this.nAttributes) {
            AttrImpl[] old = this.attributes;
            this.attributes = new AttrImpl[2 * this.nAttributes];
            System.arraycopy(old, 0, this.attributes, 0, this.nAttributes);
        }
    }

    @Override
    public void setPrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (!Symbols.isName(prefix)) {
            throw new DOMException(5, "'" + prefix + "' is not a valid prefix.");
        }
        if (prefix.indexOf(58) != -1 || prefix.equals("xml") && !"http://www.w3.org/XML/1998/namespace".equals(this.uri) || prefix.equals("xmlns") && !"http://www.w3.org/2000/xmlns/".equals(this.uri)) {
            throw new DOMException(14, "'" + prefix + "' is not a valid prefix.");
        }
        if (this.uri == null || this.uri.length() == 0) {
            throw new DOMException(14, "Can't set a prefix to an element whose uri is null");
        }
        this.prefix = prefix;
    }

    @Override
    public void setNodeValue(String value) {
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public Node cloneNode(boolean deep) {
        ElementImpl r = new ElementImpl(this.getOwnerDocument());
        this.ensureAttributes();
        super.transferData(this, r, deep);
        r.parent = null;
        r.nAttributes = this.nAttributes;
        r.attributes = new AttrImpl[this.attributes.length];
        r.map = null;
        if (deep) {
            int i = 0;
            while (i < this.nAttributes) {
                r.attributes[i] = (AttrImpl)this.attributes[i].cloneNode(true);
                r.attributes[i].setOwner(r);
                ++i;
            }
        } else {
            System.arraycopy(this.attributes, 0, r.attributes, 0, this.nAttributes);
        }
        r.name = this.name;
        r.prefix = this.prefix;
        r.uri = this.uri;
        r.local = this.local;
        r.setOwnerDocument(this.getOwnerDocument());
        return r;
    }

    @Override
    public NamedNodeMap getAttributes() {
        if (this.map == null) {
            this.map = new NamedNodeMapImplForAttributes();
        }
        return this.map;
    }

    @Override
    public String getLocalName() {
        return this.local;
    }

    @Override
    public String getNamespaceURI() {
        if (this.uri != null && this.uri.length() == 0) {
            return null;
        }
        return this.uri;
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean hasAttributes() {
        return this.nAttributes != 0;
    }

    @Override
    protected void setParent(NodeImpl parent) {
        this.parent = parent;
    }

    public String toString() {
        return ElementImpl.serializeNode(this);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    public class NamedNodeMapImplForAttributes
    implements NamedNodeMap,
    Serializable {
        private NamedNodeMapImplForAttributes() {
        }

        @Override
        public int getLength() {
            return ElementImpl.this.nAttributes;
        }

        @Override
        public Node getNamedItem(String name) {
            return ElementImpl.this.getAttributeNode(name);
        }

        @Override
        public Node getNamedItemNS(String namespaceURI, String localName) {
            return ElementImpl.this.getAttributeNodeNS(namespaceURI, localName);
        }

        @Override
        public Node item(int index) {
            if (index < 0 || index >= ElementImpl.this.nAttributes) {
                return null;
            }
            return ElementImpl.this.attributes[index];
        }

        @Override
        public Node removeNamedItem(String name) {
            Attr r = ElementImpl.this.getAttributeNode(name);
            if (r == null) {
                throw new DOMException(8, "There is no named item '" + name + "' in this NamedNodeMap.");
            }
            ElementImpl.this.removeAttributeNode(r);
            return r;
        }

        @Override
        public Node removeNamedItemNS(String namespaceURI, String localName) {
            Attr r = ElementImpl.this.getAttributeNodeNS(namespaceURI, localName);
            if (r == null) {
                throw new DOMException(8, "There is no named item '" + ElementImpl.this.name + "' in this NamedNodeMap.");
            }
            ElementImpl.this.removeAttributeNode(r);
            return r;
        }

        @Override
        public Node setNamedItem(Node arg) {
            ElementImpl.checkCompatibleOwnerDocuments(ElementImpl.this, arg);
            return ElementImpl.this.setAttributeNode((Attr)arg);
        }

        @Override
        public Node setNamedItemNS(Node arg) {
            ElementImpl.checkCompatibleOwnerDocuments(ElementImpl.this, arg);
            return ElementImpl.this.setAttributeNodeNS((Attr)arg);
        }
    }
}

