/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom.xpath;

import com.sap.engine.lib.xml.dom.QNameResolver;
import java.util.Hashtable;
import org.w3c.dom.Node;

public final class XPathNSResolverImpl {
    private Hashtable namespaceMappings;
    private Node node;

    public XPathNSResolverImpl(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.namespaceMappings = null;
        this.node = node;
    }

    protected void addNamespaceMapping(String prefix, String uri) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (uri == null) {
            uri = "";
        }
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new Hashtable();
        }
        this.namespaceMappings.put(prefix, uri);
    }

    public String lookupNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        String uri = null;
        if (this.namespaceMappings != null) {
            uri = (String)this.namespaceMappings.get(prefix);
        }
        if (uri == null) {
            return QNameResolver.prefixToURI(prefix, this.node);
        }
        return uri;
    }
}

