/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom.xpath;

import com.sap.engine.lib.xml.dom.xpath.XPathExpressionImpl;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathSetIteratorImpl {
    private DTM dtm = null;
    private int count = 0;
    private int size = 0;
    private XNodeSet xo = null;
    private Document owner = null;

    public void setOwnerDocument(Document owner) {
        this.owner = owner;
    }

    public Node getOwnerDocument() {
        return this.owner;
    }

    XPathSetIteratorImpl(XNodeSet xo) {
        this.xo = xo;
        this.dtm = xo.dtm;
        this.dtm.initializeDOM();
        this.size = xo.size();
        this.count = 1;
    }

    public Node nextNode() throws DOMException {
        if (this.size - this.count >= 0) {
            DTM dtm = this.xo.dtm;
            int[] ancestry = XPathExpressionImpl.getAncestry(dtm, this.xo.getKth(this.count++));
            Node n = XPathExpressionImpl.getNodeFromAncestry(this.owner, ancestry);
            return n;
        }
        throw new DOMException(11, "INVALID_STATE_ERR: No more elements.");
    }

    public boolean hasNext() {
        return this.size - this.count >= 0;
    }
}

