/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.dom.xpath;

import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.dom.xpath.XPathEvaluatorImpl;
import com.sap.engine.lib.xml.dom.xpath.XPathException;
import com.sap.engine.lib.xml.dom.xpath.XPathNSResolverImpl;
import com.sap.engine.lib.xml.dom.xpath.XPathResultImpl;
import com.sap.engine.lib.xml.dom.xpath.XPointerSplitter;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XPointerEvaluator {
    private Vector vSchemes = new Vector();
    private Vector vExpressions = new Vector();
    private XPathEvaluatorImpl evaluator = new XPathEvaluatorImpl();
    private XPathResultImpl result = this.evaluator.createResult();
    private Hashtable documents = new Hashtable();
    private DocumentBuilder builder;

    public XPointerEvaluator() throws ParserConfigurationException {
        SystemProperties.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        this.builder = factory.newDocumentBuilder();
    }

    public Node evaluateToNode(String url) throws IOException, SAXException {
        NodeList nl = this.evaluateToNodeList(url);
        return nl.getLength() > 0 ? nl.item(0) : null;
    }

    public NodeList evaluateToNodeList(String url) throws IOException, SAXException {
        XPathResultImpl res;
        NodeList nl;
        int p = url.indexOf(35);
        String query = p == -1 ? "xpointer(/)" : url.substring(p + 1);
        url = p == -1 ? url : url.substring(0, p);
        Document document = (Document)this.documents.get(url);
        if (document == null) {
            document = this.builder.parse(new URL(url).openStream());
            this.documents.put(url, document);
        }
        if ((nl = (res = this.evaluate(document, query)).getSetSnapshot(false).getNodeList()).getLength() > 0) {
            this.documents.put(url, nl.item(0).getOwnerDocument());
        }
        return nl;
    }

    public XPathResultImpl evaluate(Document document, String query) throws XPathException {
        this.vSchemes.clear();
        this.vExpressions.clear();
        XPointerSplitter.split(query, this.vSchemes, this.vExpressions);
        XPathNSResolverImpl resolver = new XPathNSResolverImpl(document.getDocumentElement());
        int n = this.vSchemes.size();
        int i = 0;
        while (i < n) {
            if ("xmlns".equals(this.vSchemes.get(i))) {
                String s = (String)this.vExpressions.get(i);
                int p = s.indexOf(61);
                if (p != -1) {
                    resolver.addNamespaceMapping(s.substring(0, p).trim(), s.substring(p + 1).trim());
                }
            } else if ("xpointer".equals(this.vSchemes.get(i))) {
                this.result = this.evaluator.evaluate((String)this.vExpressions.get(i), document.getDocumentElement(), resolver, (short)0, this.result);
                if (this.result.getResultType() != 4 || this.result.getSetSnapshot(false).getLength() != 0) {
                    return this.result;
                }
            }
            ++i;
        }
        return null;
    }

    public Hashtable getDocuments() {
        return this.documents;
    }
}

