/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.dom.DOMDocHandler1;
import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.lib.xml.parser.Features;
import com.sap.engine.lib.xml.parser.NestedSAXParseException;
import com.sap.engine.lib.xml.parser.Parser;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.dtd.ValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

@Deprecated
public class DOMParser
extends Parser {
    private Document document = null;
    private boolean isIgnoringComments = false;
    private Class documentClass = null;

    public DOMParser() throws Exception {
        this.xmlParser.setWellformed(true);
        try {
            this.documentClass = Class.forName("com.sap.engine.lib.xml.dom.DocumentImpl");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            try {
                this.documentClass = new DocumentImpl().getClass();
            }
            catch (Exception t) {
                LogWriter.getSystemLogWriter().println("DOMParser: could not load DocumentImpl, and get it's Class");
                t.printStackTrace();
            }
        }
        this.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException arg0) throws SAXException {
                throw arg0;
            }

            @Override
            public void fatalError(SAXParseException arg0) throws SAXException {
                throw arg0;
            }

            @Override
            public void warning(SAXParseException arg0) throws SAXException {
            }
        });
    }

    public DOMParser(XMLParser xmlParser) throws ParserException {
        super(xmlParser);
    }

    public void setIgnoringComments(boolean b) {
        this.isIgnoringComments = b;
    }

    public Document parse(String systemId) throws IOException, SAXException {
        return this.parse(new InputSource(systemId));
    }

    public Document parse(InputSource input) throws SAXException, IOException {
        try {
            DOMDocHandler1 domdoc = null;
            domdoc = this.document == null ? new DOMDocHandler1((DocumentImpl)this.documentClass.newInstance()) : new DOMDocHandler1(this.document);
            domdoc.setErrorHandler(this.errorHandler);
            domdoc.setIgnoringComments(this.isIgnoringComments);
            domdoc.setXMLValidator(this.xmlParser.getXMLValidator());
            super.parse(input, domdoc);
            this.document = domdoc.getDocument();
            if (this.document instanceof DocumentImpl) {
                this.document.normalize();
            } else {
                try {
                    this.document.normalize();
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            }
            Document result = this.document;
            this.document = null;
            Document document = result;
            return document;
        }
        catch (Exception e) {
            Locator loc = new LocatorImpl();
            if (e instanceof ParserException) {
                ((LocatorImpl)loc).setSystemId(((ParserException)e).getSourceID());
                ((LocatorImpl)loc).setLineNumber(((ParserException)e).getRow());
                ((LocatorImpl)loc).setColumnNumber(((ParserException)e).getCol());
                if (loc.getSystemId() == null || loc.getSystemId().equals(":main:")) {
                    ((LocatorImpl)loc).setSystemId(this.xmlParser.getSystemId());
                }
            } else {
                loc = this.xmlParser;
            }
            if (this.errorHandler != null) {
                if (e instanceof ValidationException) {
                    this.errorHandler.error(new NestedSAXParseException("Validation Error: " + e, loc, e));
                } else {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    this.errorHandler.fatalError(new NestedSAXParseException("Fatal Error: " + e, loc, e));
                    if (e instanceof UnsupportedEncodingException) {
                        throw new NestedSAXParseException(e.toString(), loc, e);
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new NestedSAXParseException(e.toString(), loc, e);
                }
                return null;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new NestedSAXParseException(e.toString(), loc, e);
        }
        finally {
            if (this.xmlParser != null) {
                this.xmlParser.clearDocHandler();
            }
        }
    }

    public Document parse(InputStream in) throws SAXException, IOException {
        return this.parse(new InputSource(in));
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException {
        if (name.equals("http://xml.org/sax/features/external-general-entities")) {
            throw new SAXNotRecognizedException("");
        }
        if (name.equals("http://xml.org/sax/features/external-parameter-entities")) {
            throw new SAXNotRecognizedException("");
        }
        if (name.equals("http://xml.org/sax/features/string-interning")) {
            throw new SAXNotRecognizedException("");
        }
        try {
            return super.getFeature(name);
        }
        catch (SAXNotSupportedException exc) {
            throw new SAXNotRecognizedException(exc.getMessage());
        }
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException {
        if (name.equals("http://xml.org/sax/features/external-general-entities")) {
            throw new SAXNotRecognizedException("");
        }
        if (name.equals("http://xml.org/sax/features/external-parameter-entities")) {
            throw new SAXNotRecognizedException("");
        }
        if (name.equals("http://xml.org/sax/features/string-interning")) {
            throw new SAXNotRecognizedException("");
        }
        try {
            super.setFeature(name, value);
        }
        catch (SAXNotSupportedException exc) {
            throw new SAXNotRecognizedException(exc.getMessage());
        }
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException {
        try {
            return super.getProperty(name);
        }
        catch (Exception exc) {
            throw new SAXNotRecognizedException(exc.getMessage());
        }
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException {
        try {
            if (name.equals("http://inqmy.org/dom/document-class-name-string")) {
                this.setDocumentClassName((String)value);
            } else if (name.equals("http://sap.com/xml/max-references")) {
                this.xmlParser.setMaximumProcessingReferences(value);
            } else if (name.indexOf("/features/") > -1) {
                this.setFeature(name, Features.createBooleanValue(value));
            } else {
                super.setProperty(name, value);
            }
        }
        catch (SAXException e) {
            throw new SAXNotRecognizedException(e.toString());
        }
    }

    public void setDocumentClassName(String name) throws SAXException {
        try {
            Object docClass = Class.forName(name).newInstance();
            if (!(docClass instanceof DocumentImpl)) {
                throw new ClassCastException("The class must extend com.sap.engine.lib.xml.dom.DocumentImpl");
            }
            this.documentClass = Class.forName(name);
        }
        catch (Exception e) {
            throw new NestedSAXParseException(e);
        }
    }

    public Class getDocumentClass() {
        return this.documentClass;
    }

    public Document getDocument() {
        LogWriter.getSystemLogWriter().println("This method cannot be used any more due to MemoryLeaking! Use parse(...) instead.");
        throw new RuntimeException("This method cannot be used any more due to MemoryLeaking! Use parse(...) instead.");
    }

    public void setDocument(Document doc) {
        this.document = doc;
        if (doc != null && this.document.getDocumentElement() != null) {
            this.document.removeChild(this.document.getDocumentElement());
        }
    }
}

