/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.jaxp.ParserAttributes;
import com.sap.engine.lib.schema.Constants;
import com.sap.engine.lib.schema.components.Schema;
import com.sap.engine.lib.schema.components.impl.LoaderImpl;
import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.exception.SchemaValidationException;
import com.sap.engine.lib.schema.validator.SchemaDocHandler;
import com.sap.engine.lib.schema.validator.ValidationConfigContext;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.Features;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import java.util.StringTokenizer;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class Parser
implements Constants {
    protected static final String SCHEMA_LOCATION_ATTRIB_NAME = "schemaLocation";
    protected static final String NO_NS_SCHEMA_LOCATION_ATTRIB_NAME = "noNamespaceSchemaLocation";
    protected XMLParser xmlParser;
    protected String schemaLanguage;
    protected String dtdLanguage;
    protected Object schemaSourceObj;
    protected ErrorHandler errorHandler;
    protected boolean apacheSchemaValidationFeature;
    protected boolean schemaAwareFeature;
    protected boolean validationFeature;
    protected boolean dynamicValidationFeature;
    protected boolean validateXSDDoc;
    protected Object schemaSource;
    protected Schema externalSchema;
    protected LoaderImpl loader;
    protected boolean canonicalizationProcessing;

    public Parser() throws ParserException {
        this(new XMLParser());
    }

    public Parser(XMLParser xmlParser) throws ParserException {
        this.xmlParser = xmlParser;
        this.validateXSDDoc = true;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://apache.org/xml/features/validation/schema")) {
            this.apacheSchemaValidationFeature = value;
        } else if (name.equals("http://sap.com/xml/schema-awareness")) {
            this.schemaAwareFeature = value;
        } else if (name.equals("http://sap.com/xml/validateXSDDoc")) {
            this.validateXSDDoc = value;
        } else if (name.equals("http://sap.com/xml/schemaCanonicalizationProcessing")) {
            this.canonicalizationProcessing = value;
        } else {
            if (name.equals("http://xml.org/sax/features/validation")) {
                this.validationFeature = value;
            } else if (name.equals("http://apache.org/xml/features/validation/dynamic")) {
                this.dynamicValidationFeature = value;
            }
            this.xmlParser.setFeature(name, value);
        }
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://apache.org/xml/features/validation/schema")) {
            return this.apacheSchemaValidationFeature;
        }
        if (name.equals("http://sap.com/xml/schema-awareness")) {
            return this.schemaAwareFeature;
        }
        if (name.equals("http://xml.org/sax/features/validation")) {
            return this.validationFeature;
        }
        if (name.equals("http://apache.org/xml/features/validation/dynamic")) {
            return this.dynamicValidationFeature;
        }
        return this.xmlParser.getFeature(name);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://apache.org/xml/properties/schema/external-schemaLocation")) {
            throw new SAXNotSupportedException("");
        }
        if (name.equals("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) {
            throw new SAXNotSupportedException("");
        }
        if (name.equals("http://apache.org/xml/properties/schema/schemaObject")) {
            return this.externalSchema;
        }
        if (name.equals("http://java.sun.com/xml/jaxp/properties/schemaLanguage")) {
            return this.schemaLanguage;
        }
        if (name.equals("http://java.sun.com/xml/jaxp/properties/schemaSource")) {
            return this.schemaSourceObj;
        }
        return this.xmlParser.getProperty(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://apache.org/xml/properties/schema/external-schemaLocation")) {
            this.checkForceSchemaValidation();
            this.externalSchema = null;
            if (value == null) {
                this.schemaSource = null;
            } else {
                this.checkStringValue(name, value);
                String targetNsesAndLocations = (String)value;
                StringTokenizer tokenizer = new StringTokenizer(targetNsesAndLocations);
                int toukensCount = tokenizer.countTokens();
                if (toukensCount % 2 != 0) {
                    throw new SAXNotSupportedException("The value property 'http://apache.org/xml/properties/schema/external-schemaLocation' must contain taget namespaces and schema locations, separated with white spaces.");
                }
                int count = toukensCount / 2;
                this.schemaSource = new String[2][count];
                int index = 0;
                while (tokenizer.hasMoreTokens()) {
                    ((String[][])this.schemaSource)[0][index] = tokenizer.nextToken();
                    ((String[][])this.schemaSource)[1][index++] = tokenizer.nextToken();
                }
            }
        } else if (name.equals("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) {
            this.checkForceSchemaValidation();
            this.externalSchema = null;
            if (value == null) {
                this.schemaSource = null;
            } else {
                this.checkStringValue(name, value);
                this.schemaSource = new String[2][1];
                ((String[][])this.schemaSource)[0][0] = "";
                ((String[][])this.schemaSource)[1][0] = (String)value;
            }
        } else if (name.equals("http://apache.org/xml/properties/schema/schemaObject")) {
            this.checkForceSchemaValidation();
            this.schemaSource = null;
            if (value == null) {
                this.externalSchema = null;
            } else {
                if (!(value instanceof Schema)) {
                    throw new SAXNotSupportedException("Attempting to set property '" + name + "' to an object, which class is not com.sap.engine.lib.schema.components.Schema.");
                }
                this.externalSchema = (Schema)value;
            }
        } else if (name.equals("http://java.sun.com/xml/jaxp/properties/schemaLanguage")) {
            if (value == null) {
                this.schemaLanguage = null;
            } else {
                this.checkStringValue(name, value);
                this.schemaLanguage = (String)value;
            }
        } else if (name.equals("http://java.sun.com/xml/jaxp/properties/schemaSource")) {
            if (this.schemaLanguage == null || !this.schemaLanguage.equals("http://www.w3.org/2001/XMLSchema")) {
                throw new SAXNotSupportedException("Attempting to set property 'http://java.sun.com/xml/jaxp/properties/schemaSource' without setting property 'http://java.sun.com/xml/jaxp/properties/schemaLanguage' to value 'http://www.w3.org/2001/XMLSchema'.");
            }
            this.externalSchema = null;
            if (value == null) {
                this.schemaSourceObj = null;
                this.schemaSource = null;
            } else {
                this.schemaSource = this.schemaSourceObj = value;
            }
        } else if (name.equals("http://sap.com/xml/jaxp/properties/dtdLanguage")) {
            if (value == null) {
                this.dtdLanguage = null;
            } else {
                this.checkStringValue(name, value);
                this.dtdLanguage = (String)value;
            }
        } else {
            this.xmlParser.setProperty(name, value);
        }
    }

    private Schema loadSchema(String[] targetNamespaces, String[] locations) throws SAXNotSupportedException {
        try {
            LoaderImpl loader = this.determineLoader();
            return loader.load(targetNamespaces, locations);
        }
        catch (Exception exc) {
            throw new SAXNotSupportedException(exc.getMessage());
        }
    }

    private Schema loadSchema(Object schemaSource) throws SAXNotSupportedException {
        try {
            LoaderImpl loader = this.determineLoader();
            return loader.load(schemaSource);
        }
        catch (Exception exc) {
            throw new SAXNotSupportedException(exc.getMessage());
        }
    }

    private LoaderImpl determineLoader() {
        if (this.loader == null) {
            this.loader = new LoaderImpl();
        }
        this.loader.setEntityResolver(this.getEntityResolver());
        this.loader.setValidateXSDDoc(this.validateXSDDoc);
        return this.loader;
    }

    private void checkStringValue(String name, Object value) throws SAXNotSupportedException {
        if (!(value instanceof String)) {
            throw new SAXNotSupportedException("Attempting to set property '" + name + "' to an object, which class is not java.lang.String.");
        }
    }

    private void checkForceSchemaValidation() throws SAXNotSupportedException {
        if (!(this.schemaLanguage != null && this.schemaLanguage.equals("http://www.w3.org/2001/XMLSchema") || this.apacheSchemaValidationFeature || this.schemaAwareFeature)) {
            throw new SAXNotSupportedException("Attempting to set an external schema without setting any of the features : 'http://apache.org/xml/features/validation/schema'; 'http://sap.com/xml/schema-awareness or property 'http://java.sun.com/xml/jaxp/properties/schemaLanguage' to value 'http://www.w3.org/2001/XMLSchema'.");
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.xmlParser.setEntityResolver(resolver);
    }

    public EntityResolver getEntityResolver() {
        return this.xmlParser.getEntityResolver();
    }

    protected void parse_SchemaValidation(InputSource input, DocHandler handler) throws Exception {
        this.configureParser_DTDLanguage();
        SchemaDocHandler schemaDocHandler = new SchemaDocHandler(this.createValidationConfigContext(handler));
        schemaDocHandler.setValidateXSDDoc(this.validateXSDDoc);
        schemaDocHandler.setEntityResolver(this.getEntityResolver());
        schemaDocHandler.setCanonicalizationProcessing(this.canonicalizationProcessing);
        this.xmlParser.parse(input, (DocHandler)schemaDocHandler);
        if (this.errorHandler == null && schemaDocHandler.hasErrors()) {
            throw new SchemaValidationException(schemaDocHandler.getErrorsRepresentation());
        }
    }

    private ValidationConfigContext createValidationConfigContext(DocHandler handler) throws SchemaException {
        ValidationConfigContext validationConfigContext = new ValidationConfigContext();
        validationConfigContext.setDocHandler(handler);
        validationConfigContext.setDynamicValidationFeature(this.dynamicValidationFeature);
        validationConfigContext.setErrorHandler(this.errorHandler);
        validationConfigContext.setParser(this.xmlParser);
        validationConfigContext.setSchema(this.determineExternalSchema());
        return validationConfigContext;
    }

    private void configureParser_DTDLanguage() {
        if (this.dtdLanguage != null && this.dtdLanguage.equals("http://sap.com/XMLDTD")) {
            this.xmlParser.setValidation(this.validationFeature);
            this.xmlParser.setDynamicValidation(this.dynamicValidationFeature);
        } else {
            this.xmlParser.setValidation(false);
        }
    }

    private Schema determineExternalSchema() throws SchemaException {
        if (this.externalSchema != null) {
            return this.externalSchema;
        }
        if (this.schemaSource == null) {
            return null;
        }
        LoaderImpl loader = this.determineLoader();
        this.externalSchema = loader.load(this.schemaSource);
        return this.externalSchema;
    }

    private void parse_DTDValidation(InputSource input, DocHandler handler) throws Exception {
        this.xmlParser.setValidation(this.validationFeature);
        this.xmlParser.setDynamicValidation(this.dynamicValidationFeature);
        this.xmlParser.setActiveParse(false);
        this.xmlParser.parse(input, handler);
    }

    protected void parse(InputSource input, DocHandler handler) throws Exception {
        if (this.validationFeature) {
            if (this.schemaLanguage != null && this.schemaLanguage.equals("http://www.w3.org/2001/XMLSchema") || this.apacheSchemaValidationFeature || this.schemaAwareFeature) {
                this.parse_SchemaValidation(input, handler);
            } else {
                this.parse_DTDValidation(input, handler);
            }
        } else {
            this.parse_DTDValidation(input, handler);
        }
    }

    public void setAttributes(ParserAttributes attributes) throws SAXNotSupportedException, SAXNotRecognizedException {
        int i = 0;
        while (i < attributes.size()) {
            String name = attributes.getName(i);
            Object value = attributes.get(i);
            if (Features.RECOGNIZED.contains(name)) {
                this.setFeature(name, Features.createBooleanValue(value));
            } else {
                this.setProperty(name, value);
            }
            ++i;
        }
    }
}

