/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.log.LogWriter;
import com.sap.engine.lib.xml.parser.helpers.CharArray;

public class ParserException
extends Exception {
    private int row;
    private int col;
    private String sourceID;
    private Throwable cause;
    protected String msg;

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public ParserException(Throwable cause) {
        super(cause.toString());
        this.cause = cause;
        this.row = -1;
        this.col = -1;
        this.msg = null;
    }

    public ParserException(String msg, Throwable cause) {
        super(msg);
        this.cause = cause;
        this.row = -1;
        this.col = -1;
        this.msg = msg;
    }

    public ParserException(String s, int row, int col) {
        super(s);
        this.row = row;
        this.col = col - 1;
        this.msg = s;
    }

    public ParserException(String msg, CharArray sourceID, int row, int col) {
        super(msg);
        this.row = row;
        this.col = col - 1;
        this.msg = msg;
        this.sourceID = sourceID.toString();
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public String getMessage() {
        if (this.sourceID != null) {
            return String.valueOf(this.msg) + " (" + this.sourceID + ", row:" + this.row + ", col:" + this.col + ")";
        }
        return String.valueOf(this.msg) + " (row:" + this.row + ", col:" + this.col + ")";
    }

    @Override
    public String toString() {
        return LogWriter.createExceptionRepresentation(this);
    }
}

