/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser;

import com.sap.engine.lib.xml.parser.NestedSAXParseException;
import com.sap.engine.lib.xml.parser.Parser;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.parser.dtd.ValidationException;
import com.sap.engine.lib.xml.parser.handlers.SAXDocHandler;
import java.io.IOException;
import java.util.Locale;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.LocatorImpl;

@Deprecated
public class SAXParser
extends Parser
implements XMLReader,
org.xml.sax.Parser {
    private ContentHandler contentHandler = null;
    private DocumentHandler documentHandler = null;
    private DTDHandler dtdHandler = null;
    private DeclHandler declHandler = null;
    private LexicalHandler lexicalHandler = null;
    private Locale locale = null;
    private SAXDocHandler saxHandler;

    public SAXParser() throws ParserException {
    }

    public SAXParser(XMLParser xmlParser) throws ParserException {
        super(xmlParser);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/declaration-handler")) {
            return this.declHandler;
        }
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        if (name.equals("http://xml.org/sax/properties/xml-string")) {
            throw new SAXNotSupportedException("");
        }
        throw new SAXNotRecognizedException("");
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/declaration-handler")) {
            this.declHandler = (DeclHandler)value;
        } else if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.lexicalHandler = (LexicalHandler)value;
        } else {
            if (name.equals("http://xml.org/sax/properties/xml-string")) {
                throw new SAXNotSupportedException("");
            }
            super.setProperty(name, value);
        }
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setDTDHandler(handler);
        }
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setContentHandler(handler);
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = handler;
        if (this.saxHandler != null) {
            this.saxHandler.setDocumentHandler(handler);
        }
    }

    public DocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        String sysId = input.getSystemId();
        String pubId = input.getPublicId();
        this.xmlParser.setSystemId(sysId);
        this.xmlParser.setPublicId(pubId);
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(this.xmlParser);
        }
        if (this.documentHandler != null) {
            this.documentHandler.setDocumentLocator(this.xmlParser);
        }
        try {
            if (this.saxHandler == null) {
                this.saxHandler = new SAXDocHandler();
            }
            this.saxHandler.setLexicalHandler(this.lexicalHandler);
            this.saxHandler.setDocumentHandler(this.documentHandler);
            this.saxHandler.setDeclHandler(this.declHandler);
            this.saxHandler.setContentHandler(this.contentHandler);
            this.saxHandler.setDTDHandler(this.dtdHandler);
            this.saxHandler.setErrorHandler(this.errorHandler);
            super.parse(input, this.saxHandler);
        }
        catch (ParserException parserExc) {
            LocatorImpl loc = new LocatorImpl();
            loc.setPublicId(input.getPublicId());
            loc.setSystemId(parserExc.getSourceID());
            loc.setLineNumber(parserExc.getRow());
            loc.setColumnNumber(parserExc.getCol());
            if (this.contentHandler != null) {
                this.contentHandler.setDocumentLocator(loc);
            }
            if (this.documentHandler != null) {
                this.documentHandler.setDocumentLocator(loc);
            }
            if (this.errorHandler != null) {
                if (parserExc instanceof ValidationException) {
                    this.errorHandler.error(new NestedSAXParseException("Validation Error: " + parserExc, loc, parserExc));
                    this.errorHandler.fatalError(new NestedSAXParseException("Fatal Error: " + parserExc, loc, parserExc));
                }
                this.errorHandler.fatalError(new NestedSAXParseException("Fatal Error: " + parserExc, loc, parserExc));
                throw new NestedSAXParseException(parserExc.toString(), loc, parserExc);
            }
            throw new NestedSAXParseException(parserExc.getMessage(), loc, parserExc);
        }
        catch (SAXException saxExc) {
            throw saxExc;
        }
        catch (IOException ioExc) {
            throw ioExc;
        }
        catch (Exception exc) {
            throw new NestedSAXParseException("Generic Exception: ", exc);
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

